/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.jsfsession;

import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.WebResponse;
import java.util.Iterator;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.jboss.jsfunit.context.JSFUnitFacesContext;
import org.jboss.jsfunit.context.NoNewEntryMap;
import org.jboss.jsfunit.framework.FacesContextBridge;
import org.jboss.jsfunit.framework.RequestListener;
import org.jboss.jsfunit.jsfsession.ClientIDs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSFServerSession
implements RequestListener {
    private ClientIDs clientIDs;
    private FacesContext currentFacesContext;

    JSFServerSession() {
        this.pageCreated();
    }

    public ClientIDs getClientIDs() {
        return this.clientIDs;
    }

    public String getCurrentViewID() {
        return this.getFacesContext().getViewRoot().getViewId();
    }

    public FacesContext getFacesContext() {
        return FacesContextBridge.getCurrentInstance();
    }

    public UIComponent findComponent(String componentID) {
        return this.clientIDs.findComponent(componentID);
    }

    public Object getComponentValue(String componentID) {
        return this.clientIDs.getComponentValue(componentID);
    }

    public Object getManagedBeanValue(String elExpression) {
        FacesContext facesContext = this.getFacesContext();
        try {
            this.setELRunning(true, facesContext.getExternalContext());
            Object object = facesContext.getApplication().createValueBinding(elExpression).getValue(facesContext);
            return object;
        }
        catch (RuntimeException re) {
            Throwable chain = re;
            do {
                if (!(chain instanceof NoNewEntryMap.NewEntryNotAllowedException)) continue;
                Object var5_6 = null;
                return var5_6;
            } while ((chain = chain.getCause()) != null);
            throw re;
        }
        finally {
            this.setELRunning(false, facesContext.getExternalContext());
        }
    }

    private void setELRunning(boolean isELRunning, ExternalContext extContext) {
        NoNewEntryMap requestMap = (NoNewEntryMap)extContext.getRequestMap();
        requestMap.setELRunning(isELRunning);
        NoNewEntryMap sessionMap = (NoNewEntryMap)extContext.getSessionMap();
        sessionMap.setELRunning(isELRunning);
        NoNewEntryMap applicationMap = (NoNewEntryMap)extContext.getApplicationMap();
        applicationMap.setELRunning(isELRunning);
    }

    public Iterator<FacesMessage> getFacesMessages() {
        return this.getFacesContext().getMessages();
    }

    public Iterator<FacesMessage> getFacesMessages(String componentID) {
        String clientID = this.clientIDs.findClientID(componentID);
        return this.getFacesContext().getMessages(clientID);
    }

    private void pageCreated() {
        JSFUnitFacesContext facesContext = (JSFUnitFacesContext)FacesContextBridge.getCurrentInstance();
        if (facesContext == null) {
            return;
        }
        if (this.currentFacesContext != facesContext) {
            this.clientIDs = new ClientIDs();
            this.currentFacesContext = facesContext;
        }
    }

    @Override
    public void beforeRequest(WebRequestSettings webRequestSettings) {
    }

    @Override
    public void afterRequest(WebResponse webResponse) {
        this.pageCreated();
    }
}

