/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.dependency.plugins.helpers;

import java.util.Collections;
import java.util.Set;

import org.jboss.dependency.plugins.AbstractController;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.tracker.ContextQueries;

/**
 * Stateless controller.
 *
 * @author <a href="ales.justin@jboss.com">Ales Justin</a>
 */
public class StatelessController extends AbstractController
{
   private Controller controller;

   public StatelessController(Controller controller)
   {
      if (controller == null)
         throw new IllegalArgumentException("Null controller");

      this.controller = controller;
      for (ControllerState state : controller.getStates())
         addState(state, null);
   }

   public void enableOnDemand(ControllerContext context) throws Throwable
   {
      // ignore
   }

   @Override
   protected void registerControllerContext(ControllerContext context)
   {
      // do nothing
   }

   @Override
   public void install(ControllerContext context) throws Throwable
   {
      super.install(context);
   }

   public ControllerContext uninstall(Object name)
   {
      return null;
   }

   public ControllerContext getContext(Object name, ControllerState state)
   {
      return controller.getContext(name, state);
   }

   public ControllerContext getInstalledContext(Object name)
   {
      return controller.getInstalledContext(name);
   }

   public boolean isShutdown()
   {
      return controller.isShutdown();
   }

   public void shutdown()
   {
   }

   @Override
   public Set<ControllerContext> getInstantiatedContexts(Class<?> clazz)
   {
      if (controller instanceof ContextQueries)
         return ContextQueries.class.cast(controller).getInstantiatedContexts(clazz);
      else
         return Collections.emptySet();
   }

   @Override
   public Set<ControllerContext> getContexts(Class<?> clazz, ControllerState state)
   {
      if (controller instanceof ContextQueries)
         return ContextQueries.class.cast(controller).getContexts(clazz, state);
      else
         return Collections.emptySet();
   }

   @Override
   public void addInstantiatedContext(ControllerContext context)
   {
   }

   @Override
   public void registerInstantiatedContext(ControllerContext context, Class<?>... classes)
   {
   }

   @Override
   public void unregisterInstantiatedContext(ControllerContext context, Class<?>... classes)
   {
   }

   @Override
   public void removeInstantiatedContext(ControllerContext context)
   {
   }
}