/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.dependency.spi;

import org.jboss.xb.annotations.JBossXmlEnum;

/**
 * Specifies how the {@link Controller} should handle a {@link ControllerContext} that throws 
 * an error when moving between states.
 *
 * @author <a href="ales.justin@jboss.com">Ales Justin</a>
 */
@JBossXmlEnum(ignoreCase=true)
public enum ErrorHandlingMode
{
   /**
    * The default mode, unless otherwise specified when creating the {@link ControllerContext},
    * tells the {@link Controller} to move the failed {@link ControllerContext}s to the
    * {@link ControllerState#ERROR} state.
    */
   DISCARD, // The default as before
   /**
    * The Manual mode allows advanced users to handle {@link ControllerContext}s in error themselves.
    */
   MANUAL, // Handle contexts in error yourself
   /**
    * ???
    */
   CHECKED // As MANUAL but RuntimeExceptions, Errors lead to a DISCARD
}
