/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.dependency.spi.tracker;

import org.jboss.dependency.spi.ControllerContext;

/**
 * Tracking mixin.
 *
 * @author <a href="adrian@jboss.org">Adrian Brock</a>
 * @author <a href="ales.justin@jboss.org">Ales Justin</a>
 */
public interface ContextTracking
{
   /**
    * Get the context tracker associated with this context
    *
    * @return the tracker or null if it doesn't have one
    */
   ContextTracker getContextTracker();

   /**
    * Get the target and update the context tracking
    *
    * @param user the controller context that will use the target
    * @return the object
    */
   Object getTarget(ControllerContext user);

   /**
    * Unget the target and update the context tracking
    *
    * @param user the controller context that used the target
    * @return the object
    */
   Object ungetTarget(ControllerContext user);

   /**
    * Get the target and update context tracking.
    *
    * @param tracker the tracker that will use the target
    * @return the target
    */
   Object getTarget(ContextTracker tracker);

   /**
    * Get the target and update context tracking.
    *
    * @param tracker the tracker that will use the target
    * @return the target
    */
   Object ungetTarget(ContextTracker tracker);
}