/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dependency.plugins;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.dependency.plugins.AbstractControllerStateModel;
import org.jboss.dependency.spi.ControllerState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListControllerStateModel
extends AbstractControllerStateModel {
    private List<ControllerState> states = new CopyOnWriteArrayList<ControllerState>();

    @Override
    public boolean addState(ControllerState state, ControllerState before) {
        if (this.states.contains(state)) {
            return false;
        }
        if (before == null) {
            this.states.add(state);
        } else {
            this.states.add(this.getStateIndex(before), state);
        }
        return true;
    }

    protected int getStateIndex(ControllerState state) {
        return this.getStateIndex(state, false);
    }

    protected int getStateIndex(ControllerState state, boolean allowNotFound) {
        if (state == null) {
            throw new IllegalArgumentException("Null state");
        }
        int stateIndex = this.states.indexOf(state);
        if (stateIndex < 0 && !allowNotFound) {
            throw new IllegalArgumentException("No such state " + state + " in states " + this.states);
        }
        return stateIndex;
    }

    protected ControllerState getState(int index) {
        if (index < 0 || index >= this.states.size()) {
            return null;
        }
        return this.states.get(index);
    }

    @Override
    public ControllerState getPreviousState(ControllerState state) {
        return this.getState(this.getStateIndex(state) - 1);
    }

    @Override
    public ControllerState getNextState(ControllerState state) {
        return this.getState(this.getStateIndex(state) + 1);
    }

    @Override
    public boolean isBeforeState(ControllerState state, ControllerState reference) {
        int referenceIndex;
        int stateIndex = this.getStateIndex(state, true);
        return stateIndex < (referenceIndex = this.getStateIndex(reference, true));
    }

    @Override
    public boolean isAfterState(ControllerState state, ControllerState reference) {
        int referenceIndex;
        int stateIndex = this.getStateIndex(state, true);
        return stateIndex > (referenceIndex = this.getStateIndex(reference, true));
    }

    @Override
    public Iterator<ControllerState> iterator() {
        return this.states.iterator();
    }

    @Override
    public ListIterator<ControllerState> listIteraror() {
        return this.states.listIterator(this.states.size() - 1);
    }

    @Override
    public boolean isValidState(ControllerState state) {
        return this.states.indexOf(state) >= 0;
    }

    @Override
    public ControllerState getInitialState() {
        if (this.states.size() == 0) {
            throw new IllegalStateException("No intial state");
        }
        return this.states.get(0);
    }
}

