/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dependency.spi;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.annotation.XmlType;
import org.jboss.dependency.spi.ControllerStateValueAdapter;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;
import org.jboss.xb.annotations.JBossXmlAdaptedType;

@XmlType(propOrder={})
@JBossXmlAdaptedType(valueAdapter=ControllerStateValueAdapter.class)
public class ControllerState
extends JBossObject
implements Serializable {
    private static final long serialVersionUID = 2L;
    public static final ControllerState ERROR = new ControllerState("**ERROR**", false);
    public static final ControllerState NOT_INSTALLED = new ControllerState("Not Installed", false);
    public static final ControllerState PRE_INSTALL = new ControllerState("PreInstall", false);
    public static final ControllerState DESCRIBED = new ControllerState("Described", false);
    public static final ControllerState INSTANTIATED = new ControllerState("Instantiated", false);
    public static final ControllerState CONFIGURED = new ControllerState("Configured", false);
    public static final ControllerState CREATE = new ControllerState("Create", false);
    public static final ControllerState START = new ControllerState("Start", false);
    public static final ControllerState INSTALLED = new ControllerState("Installed", false);
    protected final String stateString;
    private static Set<String> deprecatedCallers = new HashSet<String>();
    private static ConcurrentHashMap<String, ControllerState> values = new ConcurrentHashMap(16, 0.75f, 1);

    private ControllerState(String stateString, boolean warning) {
        if (stateString == null) {
            throw new IllegalArgumentException("Null state string");
        }
        this.stateString = stateString;
        if (warning) {
            String className;
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            StackTraceElement caller = null;
            for (StackTraceElement element : stack) {
                String className2 = element.getClassName();
                if (Thread.class.getName().equals(className2) || ControllerState.class.getName().equals(className2)) continue;
                caller = element;
                break;
            }
            if (caller != null && deprecatedCallers.add(className = caller.getClassName())) {
                this.log.warn((Object)("Deprecated usage of 'new ControllerState', use getInstance, caller: " + caller));
            }
        }
    }

    @Deprecated
    public ControllerState(String stateString) {
        this(stateString, true);
    }

    public static ControllerState getInstance(String stateString) {
        return ControllerState.getOrCreateState(stateString, false);
    }

    public static ControllerState newState(String stateString) {
        return ControllerState.getOrCreateState(stateString, true);
    }

    public static ControllerState valueOf(String stateString) {
        return ControllerState.getInstance(stateString);
    }

    public String getStateString() {
        return this.stateString;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ControllerState)) {
            return false;
        }
        ControllerState other = (ControllerState)object;
        return this.stateString.equals(other.stateString);
    }

    public void toString(JBossStringBuilder buffer) {
        buffer.append(this.stateString);
    }

    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.stateString);
    }

    protected int getHashCode() {
        return this.stateString.hashCode();
    }

    protected Object readResolve() throws ObjectStreamException {
        return values.get(this.stateString);
    }

    private static ControllerState getOrCreateState(String stateString, boolean create) {
        if (stateString == null) {
            throw new IllegalArgumentException("Null state string");
        }
        if (stateString.trim().length() == 0) {
            throw new IllegalArgumentException("Empty state string");
        }
        ControllerState state = values.get(stateString);
        if (state == null) {
            if (!create) {
                throw new IllegalArgumentException("An invalid state was used: " + stateString);
            }
            state = new ControllerState(stateString, false);
            ControllerState old = values.putIfAbsent(stateString, state);
            if (old != null) {
                state = old;
            }
        }
        return state;
    }

    static {
        values.put(ERROR.getStateString(), ERROR);
        values.put(NOT_INSTALLED.getStateString(), NOT_INSTALLED);
        values.put(PRE_INSTALL.getStateString(), PRE_INSTALL);
        values.put(DESCRIBED.getStateString(), DESCRIBED);
        values.put(INSTANTIATED.getStateString(), INSTANTIATED);
        values.put(CONFIGURED.getStateString(), CONFIGURED);
        values.put(CREATE.getStateString(), CREATE);
        values.put(START.getStateString(), START);
        values.put(INSTALLED.getStateString(), INSTALLED);
    }
}

