/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dependency.plugins;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jboss.dependency.plugins.AbstractAliasControllerContext;
import org.jboss.dependency.plugins.AbstractControllerContextActions;
import org.jboss.dependency.plugins.AbstractControllerMBean;
import org.jboss.dependency.plugins.AbstractControllerStateModel;
import org.jboss.dependency.plugins.AliasControllerContext;
import org.jboss.dependency.plugins.JMXObjectNameFix;
import org.jboss.dependency.plugins.MapControllerStateModel;
import org.jboss.dependency.plugins.SecurityActions;
import org.jboss.dependency.plugins.StateStatistics;
import org.jboss.dependency.plugins.action.ControllerContextAction;
import org.jboss.dependency.plugins.action.SimpleControllerContextAction;
import org.jboss.dependency.plugins.tracker.AbstractContextRegistry;
import org.jboss.dependency.spi.CallbackItem;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerContextActions;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.ControllerStateModel;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.dependency.spi.LifecycleCallbackItem;
import org.jboss.dependency.spi.asynchronous.AsynchronousController;
import org.jboss.dependency.spi.graph.GraphController;
import org.jboss.dependency.spi.graph.LookupStrategy;
import org.jboss.dependency.spi.graph.SearchInfo;
import org.jboss.dependency.spi.tracker.ContextFilter;
import org.jboss.dependency.spi.tracker.ContextQueries;
import org.jboss.dependency.spi.tracker.ContextRegistry;
import org.jboss.util.JBossObject;
import org.jboss.util.collection.CollectionsFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractController
extends JBossObject
implements Controller,
GraphController,
AbstractControllerMBean,
AsynchronousController,
ContextQueries,
ContextRegistry {
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Executor executor;
    private boolean shutdown = false;
    private final AbstractControllerStateModel stateModel = new MapControllerStateModel();
    private final Map<Object, ControllerContext> allContexts = new ConcurrentHashMap<Object, ControllerContext>();
    private final Map<ControllerState, Set<ControllerContext>> contextsByState = new ConcurrentHashMap<ControllerState, Set<ControllerContext>>();
    private final Map<Object, ControllerContext> errorContexts = new ConcurrentHashMap<Object, ControllerContext>();
    private final Set<ControllerContext> installing = new CopyOnWriteArraySet<ControllerContext>();
    private final ContextsInstalledByExecutor contextsInstalledByExecutor = new ContextsInstalledByExecutor();
    private volatile AbstractController parentController;
    private final Set<AbstractController> childControllers = new CopyOnWriteArraySet<AbstractController>();
    private final Map<Object, Set<CallbackItem<?>>> installCallbacks = new HashMap();
    private final Map<Object, Set<CallbackItem<?>>> uninstallCallbacks = new HashMap();
    private boolean onDemandEnabled = true;
    private boolean collectStats = false;
    private volatile StateStatistics installStats = null;
    private final AbstractContextRegistry registry;
    protected final ControllerState indexedInstalledState;

    public AbstractController() {
        this.addState(ControllerState.NOT_INSTALLED, null);
        this.addState(ControllerState.PRE_INSTALL, null);
        this.addState(ControllerState.DESCRIBED, null);
        this.addState(ControllerState.INSTANTIATED, null);
        this.addState(ControllerState.CONFIGURED, null);
        this.addState(ControllerState.CREATE, null);
        this.addState(ControllerState.START, null);
        this.addState(ControllerState.INSTALLED, null);
        this.indexedInstalledState = this.indexState(ControllerState.INSTALLED);
        this.registry = this.createContextRegistry();
    }

    protected AbstractContextRegistry createContextRegistry() {
        return new AbstractContextRegistry(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExecutor(Executor executor) {
        this.lockWrite();
        try {
            this.executor = executor;
        }
        finally {
            this.unlockWrite();
        }
    }

    public Executor getExecutor() {
        return this.getExecutionEnvironment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Executor getExecutionEnvironment() {
        this.lockRead();
        try {
            Executor executor = this.executor;
            return executor;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isShutdown() {
        this.lockWrite();
        try {
            boolean bl = this.shutdown;
            return bl;
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkShutdown() {
        this.lockWrite();
        try {
            if (this.shutdown) {
                throw new IllegalStateException("Already shutdown");
            }
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.lockWrite();
        try {
            Set<ControllerContext> contexts;
            Set<AbstractController> children = this.getControllers();
            if (children != null && !children.isEmpty()) {
                for (AbstractController child : children) {
                    try {
                        child.shutdown();
                    }
                    catch (Throwable t) {
                        this.log.warn((Object)("Error during shutdown of child: " + child), t);
                    }
                }
            }
            if ((contexts = this.getAllContexts()) != null && !contexts.isEmpty()) {
                for (ControllerContext context : contexts) {
                    try {
                        this.uninstall(context.getName());
                    }
                    catch (Throwable t) {
                        this.log.warn((Object)("Error during shutdown while uninstalling: " + context), t);
                    }
                }
            }
        }
        finally {
            this.shutdown = true;
            this.unlockWrite();
        }
    }

    public boolean isCollectStats() {
        return this.collectStats;
    }

    public void setCollectStats(boolean collectStats) {
        this.collectStats = collectStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String listStateTimes(boolean details) {
        AbstractController abstractController = this;
        synchronized (abstractController) {
            if (this.installStats == null) {
                return "No statistics available";
            }
            return this.installStats.listTimes(details);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addState(ControllerState state, ControllerState before) {
        this.lockWrite();
        try {
            if (this.stateModel.addState(state, before)) {
                CopyOnWriteArraySet contexts = new CopyOnWriteArraySet();
                this.contextsByState.put(state, contexts);
            }
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addControllerContext(ControllerContext context) {
        this.lockWrite();
        try {
            this.registerControllerContext(context);
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeControllerContext(ControllerContext context) {
        this.lockWrite();
        try {
            this.unregisterControllerContext(context);
        }
        finally {
            this.unlockWrite();
        }
    }

    public AbstractController getParentController() {
        return this.parentController;
    }

    protected void setParentController(AbstractController parentController) {
        this.parentController = parentController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<AbstractController> getControllers() {
        this.lockRead();
        try {
            Set<AbstractController> set = Collections.unmodifiableSet(this.childControllers);
            return set;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addController(AbstractController controller) {
        this.lockWrite();
        try {
            boolean bl = this.childControllers.add(controller);
            return bl;
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeController(AbstractController controller) {
        this.lockWrite();
        try {
            boolean bl = this.childControllers.remove(controller);
            return bl;
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        this.lockRead();
        try {
            if (!this.allContexts.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            for (AbstractController child : this.getControllers()) {
                if (!child.isActive()) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlockRead();
        }
    }

    @Override
    public ControllerContext getContext(Object name, ControllerState state, SearchInfo info) {
        if (info == null) {
            throw new IllegalArgumentException("Null search info.");
        }
        LookupStrategy strategy = info.getStrategy();
        if (strategy == null) {
            throw new IllegalArgumentException("AbstractController doesn't implement this search info: " + info);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Executing search " + info.getType()));
        }
        return strategy.getContext(this, name, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ControllerContext> getAllContexts() {
        this.lockRead();
        try {
            LinkedHashSet<ControllerContext> result = new LinkedHashSet<ControllerContext>();
            ListIterator<ControllerState> it = this.stateModel.listIteraror();
            if (it.hasNext()) {
                result.addAll(this.getContextsByState(it.next()));
                while (it.hasPrevious()) {
                    result.addAll(this.getContextsByState(it.previous()));
                }
            }
            result.addAll(this.errorContexts.values());
            LinkedHashSet<ControllerContext> linkedHashSet = result;
            return linkedHashSet;
        }
        finally {
            this.unlockRead();
        }
    }

    @Override
    public ControllerContext getContext(Object name, ControllerState state) {
        return this.getContext(name, state, false);
    }

    @Override
    public ControllerContext getContext(Object name, ControllerState state, boolean enableOnDemand) {
        return this.getContextInternal(name, state, enableOnDemand, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ControllerContext getContextInternal(Object name, ControllerState state, boolean enableOnDemand, Controller initiatingController) {
        boolean needsReadLock;
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        boolean bl = needsReadLock = !this.lock.isWriteLockedByCurrentThread();
        if (needsReadLock) {
            this.lockRead();
        }
        try {
            ControllerContext result = this.getRegisteredControllerContext(name, false);
            if (result == null && name instanceof Class) {
                result = this.getContextByClass((Class)name);
            }
            if (result != null && state != null && this.stateModel.isBeforeState(result.getState(), state)) {
                if (enableOnDemand && ControllerMode.ON_DEMAND.equals((Object)result.getMode())) {
                    if (needsReadLock && initiatingController == this) {
                        this.unlockRead();
                    }
                    try {
                        initiatingController.enableOnDemand(result);
                    }
                    catch (Throwable ignored) {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)"Unexpected error", ignored);
                        }
                    }
                    finally {
                        if (needsReadLock && initiatingController == this) {
                            this.lockRead();
                        }
                    }
                }
                ControllerContext controllerContext = null;
                return controllerContext;
            }
            ControllerContext controllerContext = result;
            return controllerContext;
        }
        finally {
            if (needsReadLock) {
                this.unlockRead();
            }
        }
    }

    @Override
    public ControllerContext getInstalledContext(Object name) {
        return this.getContext(name, this.indexedInstalledState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ControllerContext> getNotInstalled() {
        this.lockWrite();
        try {
            ControllerState state;
            HashSet<ControllerContext> result = new HashSet<ControllerContext>(this.errorContexts.values());
            Iterator i$ = this.stateModel.iterator();
            while (i$.hasNext() && !this.indexedInstalledState.equals(state = (ControllerState)i$.next())) {
                Set<ControllerContext> stateContexts = this.getContextsByState(state);
                result.addAll(stateContexts);
            }
            HashSet<ControllerContext> hashSet = result;
            return hashSet;
        }
        finally {
            this.unlockWrite();
        }
    }

    @Override
    public ControllerStateModel getStates() {
        return this.stateModel;
    }

    public ControllerState indexState(ControllerState state) {
        return this.stateModel.indexState(state);
    }

    @Override
    public Set<ControllerContext> getContextsByState(ControllerState state) {
        return this.contextsByState.get(state);
    }

    @Override
    public void install(ControllerContext context) throws Throwable {
        boolean trace = this.log.isTraceEnabled();
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        Object name = context.getName();
        if (name == null) {
            throw new IllegalArgumentException("Null name " + context.toShortString());
        }
        this.install(context, trace);
    }

    @Override
    public void change(ControllerContext context, ControllerState state) throws Throwable {
        boolean trace = this.log.isTraceEnabled();
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        if (state == null) {
            throw new IllegalArgumentException("Null state");
        }
        this.change(context, this.indexState(state), trace);
    }

    @Override
    public void enableOnDemand(ControllerContext context) throws Throwable {
        boolean trace = this.log.isTraceEnabled();
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        this.enableOnDemand(context, trace);
    }

    @Override
    public ControllerContext uninstall(Object name) {
        return this.uninstall(name, 0);
    }

    protected String getId() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getSimpleName());
        buffer.append("[").append(System.identityHashCode(this)).append("]");
        return buffer.toString();
    }

    @Override
    public void addAlias(Object alias, Object original) throws Throwable {
        Map<ControllerState, ControllerContextAction> map = this.createAliasActions();
        AbstractControllerContextActions actions = new AbstractControllerContextActions(map);
        InnerAliasControllerContext context = new InnerAliasControllerContext(alias, this.getId(), original, actions);
        this.preAliasInstall(context);
        this.install(context);
        Throwable error = context.getError();
        if (error != null) {
            throw error;
        }
        if (ControllerState.ERROR.equals(context.getState())) {
            throw new IllegalArgumentException("Alias " + context + " is in error.");
        }
    }

    protected Map<ControllerState, ControllerContextAction> createAliasActions() {
        return Collections.singletonMap(this.indexedInstalledState, new AliasControllerContextAction());
    }

    protected void preAliasInstall(ControllerContext aliasContext) {
    }

    @Override
    public void removeAlias(Object alias) {
        this.uninstall(alias + "_Alias_" + this.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ControllerContext uninstall(Object name, int level) {
        boolean trace = this.log.isTraceEnabled();
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        this.lockWrite();
        try {
            ControllerContext context;
            if (this.errorContexts.remove(name) != null && trace) {
                this.log.trace((Object)("Tidied up context in error state: " + name));
            }
            if ((context = this.getRegisteredContextAndInterruptAsynchronousInstall(name)) != null) {
                if (trace) {
                    this.log.trace((Object)("Uninstalling " + context.toShortString()));
                }
                AbstractController parent = this.getParentController();
                this.uninstallContext(context, this.stateModel.getInitialState(), trace);
                try {
                    this.unregisterControllerContext(context);
                }
                catch (Throwable t) {
                    this.log.warn((Object)("Error unregistering context: " + context.toShortString() + " with name: " + name));
                }
                while (parent != null) {
                    try {
                        parent.unregisterControllerContext(context);
                    }
                    catch (Throwable t) {
                        this.log.warn((Object)("Error unregistering context in parent controller: " + context.toShortString() + " with name: " + name));
                    }
                    parent = parent.getParentController();
                }
            } else {
                AbstractController controller;
                Iterator<AbstractController> i$ = this.getControllers().iterator();
                while (i$.hasNext() && (context = (controller = i$.next()).uninstall(name, level + 1)) == null) {
                }
            }
            if (context == null && level == 0) {
                throw new IllegalStateException("Not installed: " + name);
            }
            ControllerContext controllerContext = context;
            return controllerContext;
        }
        finally {
            this.unlockWrite();
        }
    }

    private ControllerContext getRegisteredContextAndInterruptAsynchronousInstall(Object name) {
        ControllerContext context = this.getRegisteredControllerContext(name, false);
        if (context != null) {
            this.contextsInstalledByExecutor.interruptTaskAndBlock(context, this);
            context = this.getRegisteredControllerContext(name, false);
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void install(ControllerContext context, boolean trace) throws Throwable {
        block17: {
            this.lockWrite();
            try {
                boolean ok;
                this.checkShutdown();
                Object name = context.getName();
                if (this.getRegisteredControllerContext(name, false) != null) {
                    throw new IllegalStateException(name + " is already installed.");
                }
                Set<Object> aliases = context.getAliases();
                if (aliases != null && !aliases.isEmpty()) {
                    for (Object alias : aliases) {
                        if (this.getRegisteredControllerContext(alias, false) == null) continue;
                        throw new IllegalStateException(alias + " an alias of " + name + " is already installed.");
                    }
                }
                ControllerMode mode = context.getMode();
                context.setRequiredState(this.indexState(mode.getRequiredState()));
                if (trace) {
                    this.log.trace((Object)("Installing " + context.toShortString()));
                }
                context.setController(this);
                DependencyInfo dependencies = context.getDependencyInfo();
                if (trace) {
                    String dependsOn = "[]";
                    if (dependencies != null) {
                        try {
                            Set<DependencyItem> set = dependencies.getIDependOn(null);
                            if (set != null) {
                                dependsOn = set.toString();
                            }
                        }
                        catch (Throwable t) {
                            this.log.warn((Object)("Exception getting dependencies: " + t));
                            dependsOn = null;
                        }
                    }
                    if (dependsOn != null) {
                        this.log.trace((Object)("Dependencies for " + name + ": " + dependsOn));
                    }
                }
                if (ok = this.incrementState(context, trace)) {
                    try {
                        this.registerControllerContext(context);
                    }
                    catch (Throwable t) {
                        ok = false;
                        throw t;
                    }
                }
                if (ok) {
                    this.resolveContexts(trace);
                    break block17;
                }
                this.errorContexts.remove(context);
                throw context.getError();
            }
            finally {
                this.unlockWrite();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void change(ControllerContext context, ControllerState state, boolean trace) throws Throwable {
        this.lockWrite();
        try {
            this.checkShutdown();
            if (!this.stateModel.isValidState(state)) {
                throw new IllegalArgumentException("Unknown state: " + state);
            }
            if (context.getState().equals(state)) {
                if (trace) {
                    this.log.trace((Object)("No change required toState=" + state.getStateString() + " " + context.toShortString()));
                }
                return;
            }
            if (trace) {
                this.log.trace((Object)("Change toState=" + state.getStateString() + " " + context.toShortString()));
            }
            context.setRequiredState(state);
            if (this.stateModel.isBeforeState(context.getState(), state)) {
                this.resolveContexts(trace);
            } else {
                while (this.stateModel.isAfterState(context.getState(), state)) {
                    this.uninstallContext(context, trace);
                }
            }
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enableOnDemand(ControllerContext context, boolean trace) throws Throwable {
        Controller controller = null;
        this.lockWrite();
        try {
            this.checkShutdown();
            controller = context.getController();
            if (this.indexedInstalledState.equals(context.getRequiredState())) {
                return;
            }
            if (controller == this) {
                if (!ControllerMode.ON_DEMAND.equals((Object)context.getMode())) {
                    throw new IllegalStateException("Context is not ON DEMAND: " + context.toShortString());
                }
                this.getRegisteredControllerContext(context.getName(), true);
                context.setRequiredState(this.indexedInstalledState);
                if (trace) {
                    this.log.trace((Object)("Enable onDemand: " + context.toShortString()));
                }
            }
        }
        finally {
            this.unlockWrite();
        }
        if (controller != this) {
            controller.enableOnDemand(context);
        }
        this.lockWrite();
        try {
            this.onDemandEnabled = true;
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean incrementState(ControllerContext context, boolean trace) {
        ControllerState fromState = context.getState();
        Controller fromController = context.getController();
        if (ControllerState.ERROR.equals(fromState)) {
            ControllerState initialState = this.stateModel.getInitialState();
            this.errorContexts.remove(context);
            Throwable error = null;
            this.unlockWrite();
            try {
                this.install(context, ControllerState.ERROR, initialState);
            }
            catch (Throwable t) {
                error = t;
                return (boolean)error;
            }
            finally {
                this.lockWrite();
                if (error != null) {
                    this.log.error((Object)("Error during initial installation: " + context.toShortString()), error);
                    context.setError(error);
                    this.errorContexts.put(context.getName(), context);
                    return false;
                }
            }
            Set<ControllerContext> notInstalled = fromController.getContextsByState(initialState);
            notInstalled.add(context);
            context.setState(initialState);
            return true;
        }
        Set<ControllerContext> fromContexts = fromController.getContextsByState(fromState);
        if (!fromContexts.contains(context)) {
            throw new IllegalStateException("Context not found in previous state (" + fromState + "): " + context.toShortString());
        }
        ControllerState toState = this.stateModel.getNextState(fromState);
        if (toState == null) {
            throw new IllegalStateException("No state after " + fromState);
        }
        this.unlockWrite();
        Throwable error = null;
        try {
            this.install(context, fromState, toState);
            if (fromContexts != null) {
                fromContexts.remove(context);
            }
            Controller toController = context.getController();
            Set<ControllerContext> toContexts = toController.getContextsByState(toState);
            toContexts.add(context);
            context.setState(toState);
            this.handleInstallLifecycleCallbacks(context, toState);
            this.resolveCallbacks(context, toState, true);
        }
        catch (Throwable t) {
            error = t;
            return (boolean)error;
        }
        finally {
            this.lockWrite();
            if (error != null) {
                this.log.error((Object)("Error installing to " + toState.getStateString() + ": " + context.toShortString()), error);
                this.uninstallContext(context, this.stateModel.getInitialState(), trace);
                this.errorContexts.put(context.getName(), context);
                context.setError(error);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolveContexts(boolean trace) {
        AbstractController parent;
        boolean wasOnDemandEnabled = false;
        boolean resolutions = true;
        while (resolutions || this.onDemandEnabled) {
            if (this.onDemandEnabled) {
                wasOnDemandEnabled = true;
            }
            this.onDemandEnabled = false;
            resolutions = false;
            for (ControllerState fromState : this.stateModel) {
                ControllerState toState = this.stateModel.getNextState(fromState);
                if (toState == null || !this.resolveContexts(fromState, toState, trace)) continue;
                resolutions = true;
            }
        }
        if (trace) {
            for (ControllerState state : this.stateModel) {
                Set<ControllerContext> stillUnresolved;
                ControllerState nextState = this.stateModel.getNextState(state);
                if (!this.stateModel.isValidState(nextState) || (stillUnresolved = this.getContextsByState(state)) == null || stillUnresolved.isEmpty()) continue;
                for (ControllerContext ctx : stillUnresolved) {
                    if (!this.advance(ctx)) continue;
                    this.log.trace((Object)("Still unresolved " + nextState.getStateString() + ": " + ctx));
                }
            }
        }
        for (AbstractController controller : this.childControllers) {
            controller.lockWrite();
            try {
                controller.resolveContexts(trace);
            }
            finally {
                controller.unlockWrite();
            }
        }
        if (wasOnDemandEnabled && (parent = this.getParentController()) != null) {
            parent.resolveContexts(trace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean resolveContexts(ControllerState fromState, ControllerState toState, boolean trace) {
        boolean resolutions;
        block16: {
            resolutions = false;
            Set<ControllerContext> unresolved = this.getContextsByState(fromState);
            Set<ControllerContext> resolved = this.resolveContexts(unresolved, fromState, toState, trace);
            if (!resolved.isEmpty()) {
                Object name;
                HashSet<ControllerContext> toProcess = new HashSet<ControllerContext>();
                for (ControllerContext context : resolved) {
                    name = context.getName();
                    if (!fromState.equals(context.getState())) {
                        if (trace) {
                            this.log.trace((Object)("Skipping already installed " + name + " for " + toState.getStateString()));
                        }
                        this.installing.remove(context);
                        continue;
                    }
                    toProcess.add(context);
                }
                try {
                    if (!toProcess.isEmpty()) {
                        Iterator iter = toProcess.iterator();
                        while (iter.hasNext()) {
                            ControllerContext context;
                            context = (ControllerContext)iter.next();
                            iter.remove();
                            name = context.getName();
                            try {
                                if (!fromState.equals(context.getState())) {
                                    if (!trace) continue;
                                    this.log.trace((Object)("Skipping already installed " + name + " for " + toState.getStateString()));
                                    continue;
                                }
                                if (trace) {
                                    this.log.trace((Object)("Dependencies resolved " + name + " for " + toState.getStateString()));
                                }
                                if (!this.executeOrIncrementStateDirectly(context, trace)) continue;
                                resolutions = true;
                                if (!trace) continue;
                                this.log.trace((Object)(name + " " + toState.getStateString()));
                            }
                            finally {
                                this.installing.remove(context);
                            }
                        }
                    }
                    if (toProcess.isEmpty()) break block16;
                }
                catch (Throwable throwable) {
                    if (!toProcess.isEmpty()) {
                        for (ControllerContext context : toProcess) {
                            this.installing.remove(context);
                        }
                    }
                    throw throwable;
                }
                for (ControllerContext context : toProcess) {
                    this.installing.remove(context);
                }
            }
        }
        return resolutions;
    }

    private boolean executeOrIncrementStateDirectly(ControllerContext context, boolean trace) {
        boolean asynch = this.contextsInstalledByExecutor.shouldInstallAsynchronously(context);
        if (asynch) {
            Executor foundExecutor;
            if (this.executor == null) {
                Object ctx = trace ? context : context.getName();
                this.log.warn((Object)("No executor in controller " + this + " to use installing asynchronous context " + ctx));
            }
            if ((foundExecutor = this.searchForExecutor()) != null) {
                InstallControllerContextTask task = new InstallControllerContextTask(context, trace);
                this.contextsInstalledByExecutor.markForTaskExecution(context, task);
                if (trace) {
                    this.log.trace((Object)("Recorded for asynchronous installation " + context.getName()));
                }
                try {
                    foundExecutor.execute(task);
                    return false;
                }
                catch (RejectedExecutionException e) {
                    Object ctx = trace ? context : context.getName();
                    this.log.warn((Object)("Asynchronous execution rejected by executor for context " + ctx + ":" + e.getMessage()));
                    this.contextsInstalledByExecutor.disassociateWithTask(context);
                }
            }
        }
        return this.incrementState(context, trace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Executor searchForExecutor() {
        if (this.executor != null) {
            return this.executor;
        }
        AbstractController parent = this.getParentController();
        if (parent != null) {
            try {
                parent.lockRead();
                Executor executor = parent.searchForExecutor();
                return executor;
            }
            finally {
                parent.unlockRead();
            }
        }
        return null;
    }

    protected Set<ControllerContext> resolveContexts(Set<ControllerContext> contexts, ControllerState fromState, ControllerState toState, boolean trace) {
        HashSet<ControllerContext> result = new HashSet<ControllerContext>();
        if (!contexts.isEmpty()) {
            for (ControllerContext ctx : contexts) {
                Object name = ctx.getName();
                AsynchronousInstallStatus asynchStatus = this.contextsInstalledByExecutor.checkInstalled(ctx);
                if (!fromState.equals(ctx.getState())) {
                    if (!trace) continue;
                    this.log.trace((Object)("Skipping already installed " + name + " for " + toState.getStateString()));
                    continue;
                }
                if (asynchStatus == AsynchronousInstallStatus.OTHER_THREAD) {
                    if (!trace) continue;
                    this.log.trace((Object)("Installed by other thread " + name));
                    continue;
                }
                if (!this.installing.add(ctx)) {
                    if (!trace) continue;
                    this.log.trace((Object)("Already installing " + name + " for " + toState.getStateString()));
                    continue;
                }
                if (asynchStatus == AsynchronousInstallStatus.IN_PROGRESS) {
                    if (trace) {
                        this.log.trace((Object)("Already installing " + name + " for " + toState.getStateString()));
                    }
                    this.installing.remove(ctx);
                    continue;
                }
                if (this.advance(ctx)) {
                    try {
                        if (this.resolveDependencies(ctx, toState)) {
                            result.add(ctx);
                            continue;
                        }
                        this.installing.remove(ctx);
                    }
                    catch (Throwable error) {
                        this.installing.remove(ctx);
                        this.log.error((Object)("Error resolving dependencies for " + toState.getStateString() + ": " + ctx.toShortString()), error);
                        this.uninstallContext(ctx, this.stateModel.getInitialState(), trace);
                        this.errorContexts.put(ctx.getName(), ctx);
                        ctx.setError(error);
                    }
                    continue;
                }
                this.installing.remove(ctx);
            }
        }
        return result;
    }

    private boolean resolveDependencies(ControllerContext ctx, ControllerState state) {
        DependencyInfo dependencies = ctx.getDependencyInfo();
        return dependencies == null || dependencies.resolveDependencies(this, state);
    }

    protected void uninstallContext(ControllerContext context, ControllerState toState, boolean trace) {
        if (!this.stateModel.isValidState(toState)) {
            this.log.error((Object)("INTERNAL ERROR: unknown state " + toState + " states=" + this.stateModel), (Throwable)new Exception("STACKTRACE"));
        }
        ControllerState fromState;
        while (!ControllerState.ERROR.equals(fromState = context.getState())) {
            if (!this.stateModel.isValidState(fromState)) {
                this.log.error((Object)("INTERNAL ERROR: current state not found: " + context.toShortString()), (Throwable)new Exception("STACKTRACE"));
            }
            if (this.stateModel.isAfterState(toState, fromState)) {
                return;
            }
            this.uninstallContext(context, trace);
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void uninstallContext(ControllerContext context, boolean trace) {
        Controller fromController;
        Set<ControllerContext> fromContexts;
        Object name = context.getName();
        ControllerState fromState = context.getState();
        if (trace) {
            this.log.trace((Object)("Uninstalling " + name + " from " + fromState.getStateString()));
        }
        if ((fromContexts = (fromController = context.getController()).getContextsByState(fromState)) == null || !fromContexts.remove(context)) {
            throw new Error("INTERNAL ERROR: context not found in previous state " + fromState.getStateString() + " context=" + context.toShortString(), new Exception("STACKTRACE"));
        }
        DependencyInfo dependencies = context.getDependencyInfo();
        if (dependencies != null) {
            try {
                Set<DependencyItem> iDependOns;
                Set<DependencyItem> dependsOnMe = dependencies.getDependsOnMe(null);
                if (!dependsOnMe.isEmpty()) {
                    for (DependencyItem item : dependsOnMe) {
                        ControllerState dependentState;
                        if (!item.isResolved() || (dependentState = item.getDependentState()) != null && !dependentState.equals(fromState) || !item.unresolved(this)) continue;
                        Set dependents = CollectionsFactory.createLazySet();
                        this.getContexts(item.getName(), dependents);
                        if (dependents.isEmpty()) continue;
                        ControllerState whenRequired = item.getWhenRequired();
                        if (whenRequired == null) {
                            whenRequired = this.stateModel.getInitialState();
                        }
                        for (ControllerContext dependent : dependents) {
                            boolean selfDependency = dependent == context;
                            if (selfDependency) continue;
                            this.contextsInstalledByExecutor.interruptTaskAndBlock(dependent, this);
                            if (this.stateModel.isBeforeState(dependent.getState(), whenRequired)) continue;
                            this.uninstallContext(dependent, whenRequired, trace);
                            dependencies.removeDependsOnMe(item);
                        }
                    }
                }
                if (!(iDependOns = dependencies.getIDependOn(null)).isEmpty()) {
                    for (DependencyItem item : iDependOns) {
                        ControllerState whenRequired;
                        if (!item.isResolved() || (whenRequired = item.getWhenRequired()) != null && !whenRequired.equals(fromState)) continue;
                        Object iDependOn = item.getIDependOn();
                        if (!item.unresolved(this)) continue;
                        try {
                            DependencyInfo info;
                            if (iDependOn == null) {
                                this.log.debug((Object)("Null iDependOn for " + item));
                                continue;
                            }
                            ControllerContext dependency = this.getContext(iDependOn, item.getDependentState());
                            if (dependency == null || (info = dependency.getDependencyInfo()) == null) continue;
                            info.removeDependsOnMe(item);
                        }
                        catch (RuntimeException e) {
                            if (trace) {
                                this.log.warn((Object)("Problem finding dependency for " + item), (Throwable)e);
                                continue;
                            }
                            this.log.warn((Object)("Problem finding dependency for " + item));
                        }
                    }
                }
            }
            catch (Throwable error) {
                this.log.error((Object)("Error resolving dependencies for " + fromState.getStateString() + ": " + context.toShortString()), error);
                this.errorContexts.put(context.getName(), context);
                context.setError(error);
            }
        }
        if (ControllerState.ERROR.equals(fromState = context.getState())) {
            return;
        }
        ControllerState toState = this.stateModel.getPreviousState(fromState);
        if (toState == null) {
            context.setState(ControllerState.ERROR);
            return;
        }
        this.unlockWrite();
        try {
            this.resolveCallbacks(context, fromState, false);
            this.handleUninstallLifecycleCallbacks(context, toState);
            this.uninstall(context, fromState, toState);
            Controller toController = context.getController();
            Set<ControllerContext> toContexts = toController.getContextsByState(toState);
            toContexts.add(context);
            context.setState(toState);
            this.uninstallUnusedOnDemandContexts(context, trace);
        }
        catch (Throwable t) {
            this.log.warn((Object)("Error uninstalling from " + fromState.getStateString() + ": " + context.toShortString()), t);
        }
        finally {
            this.lockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void uninstallUnusedOnDemandContexts(ControllerContext context, boolean trace) {
        this.lockWrite();
        try {
            Set<DependencyItem> iDependOn;
            DependencyInfo dependencies = context.getDependencyInfo();
            if (dependencies != null && !(iDependOn = dependencies.getIDependOn(null)).isEmpty()) {
                for (DependencyItem item : iDependOn) {
                    Object name = item.getIDependOn();
                    if (name == null) continue;
                    ControllerContext other = this.getContext(name, null);
                    if (other == null) {
                        this.log.debug((Object)("Could not find dependency '" + name + "' while uninstalling on demand contexts for " + item));
                        continue;
                    }
                    if (other.getMode() != ControllerMode.ON_DEMAND) continue;
                    Set<ControllerContext> fromContexts = other.getController().getContextsByState(other.getState());
                    if (!fromContexts.contains(other)) {
                        if (!trace) continue;
                        this.log.trace((Object)("Could not find ON_DEMAND context " + other.getName() + " in " + other.getState() + " it is probably being uninstalled"));
                        continue;
                    }
                    DependencyInfo otherDependencies = other.getDependencyInfo();
                    if (otherDependencies == null) continue;
                    Set<DependencyItem> dependsOnOther = otherDependencies.getDependsOnMe(null);
                    boolean isRequired = false;
                    for (DependencyItem dependsOnOtherItem : dependsOnOther) {
                        Set dependsContexts = CollectionsFactory.createLazySet();
                        this.getContexts(dependsOnOtherItem.getName(), dependsContexts);
                        if (!dependsContexts.isEmpty()) {
                            for (ControllerContext dependsContext : dependsContexts) {
                                ControllerState actualState;
                                if (dependsContext == null) {
                                    this.log.debug((Object)("Could not find reverse dependency '" + dependsOnOtherItem.getName() + "' while uninstalling on demand contexts for " + item));
                                    continue;
                                }
                                ControllerState requiredState = item.getWhenRequired();
                                if (!requiredState.equals(actualState = dependsContext.getState()) && !this.stateModel.isBeforeState(requiredState, actualState)) continue;
                                isRequired = true;
                                break;
                            }
                        }
                        if (!isRequired) continue;
                        break;
                    }
                    if (isRequired) continue;
                    ControllerState state = this.stateModel.getNextState(ControllerMode.ON_DEMAND.getRequiredState());
                    this.uninstallContext(other, state, trace);
                }
            }
        }
        finally {
            this.unlockWrite();
        }
    }

    protected void getContexts(Object name, Set<ControllerContext> contexts) {
        Set<AbstractController> children;
        Set<Object> aliases;
        ControllerContext context = this.getContext(name, null);
        if (!(context == null || (aliases = context.getAliases()) != null && aliases.contains(name))) {
            contexts.add(context);
        }
        if ((children = this.getControllers()) != null && !children.isEmpty()) {
            for (AbstractController child : children) {
                child.getContexts(name, contexts);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> void addCallback(Object name, boolean isInstallPhase, CallbackItem<T> callback) {
        this.lockWrite();
        try {
            Map<Object, Set<CallbackItem<?>>> map = isInstallPhase ? this.installCallbacks : this.uninstallCallbacks;
            Set<CallbackItem<?>> callbacks = map.get(name);
            if (callbacks == null) {
                callbacks = new HashSet();
                map.put(name, callbacks);
            }
            callbacks.add(callback);
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> void removeCallback(Object name, boolean isInstallPhase, CallbackItem<T> callback) {
        this.lockWrite();
        try {
            Map<Object, Set<CallbackItem<?>>> map = isInstallPhase ? this.installCallbacks : this.uninstallCallbacks;
            Set<CallbackItem<?>> callbacks = map.get(name);
            if (callbacks != null) {
                callbacks.remove(callback);
                if (callbacks.isEmpty()) {
                    map.remove(name);
                }
            }
        }
        finally {
            this.unlockWrite();
        }
    }

    protected Set<CallbackItem<?>> getDependencyCallbacksForState(ControllerContext context, ControllerState state, boolean isInstallPhase) {
        DependencyInfo di = context.getDependencyInfo();
        if (di != null) {
            Set<CallbackItem<?>> items;
            Set<CallbackItem<?>> set = items = isInstallPhase ? di.getInstallItems() : di.getUninstallItems();
            if (items == null || items.isEmpty()) {
                return null;
            }
            HashSet result = null;
            for (CallbackItem<?> item : items) {
                if (!item.getWhenRequired().equals(state)) continue;
                if (result == null) {
                    result = new HashSet();
                }
                result.add(item);
            }
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<CallbackItem<?>> getCallbacks(Set<CallbackItem<?>> result, Object name, boolean isInstallPhase) {
        this.lockRead();
        try {
            Map<Object, Set<CallbackItem<?>>> map = isInstallPhase ? this.installCallbacks : this.uninstallCallbacks;
            Set<CallbackItem<?>> callbacks = map.get(name);
            if (callbacks != null) {
                if (result == null) {
                    result = new HashSet();
                }
                result.addAll(callbacks);
            }
            Set<CallbackItem<?>> set = result;
            return set;
        }
        finally {
            this.unlockRead();
        }
    }

    protected void resolveCallbacks(Set<CallbackItem<?>> callbacks, ControllerState state, boolean execute, boolean isInstallPhase, boolean type) {
        if (callbacks != null && !callbacks.isEmpty()) {
            for (CallbackItem<?> callback : callbacks) {
                if (!callback.getWhenRequired().equals(state)) {
                    throw new IllegalArgumentException(callback + " does not have the required state " + state);
                }
                if (isInstallPhase) {
                    this.addCallback(callback.getIDependOn(), type, callback);
                } else {
                    this.removeCallback(callback.getIDependOn(), type, callback);
                }
                if (!execute) continue;
                try {
                    callback.ownerCallback(this, isInstallPhase);
                }
                catch (Throwable t) {
                    this.log.warn((Object)("Broken callback: " + callback), t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void resolveCallbacks(ControllerContext context, ControllerState state, boolean isInstallPhase) {
        ClassLoader previous = null;
        try {
            Set<CallbackItem<?>> installs = this.getDependencyCallbacksForState(context, state, true);
            Set<CallbackItem<?>> uninstalls = this.getDependencyCallbacksForState(context, state, false);
            Set<CallbackItem<?>> existingCallbacks = null;
            DependencyInfo dependencyInfo = context.getDependencyInfo();
            if (dependencyInfo != null && dependencyInfo.isAutowireCandidate()) {
                existingCallbacks = this.getCallbacks(existingCallbacks, context.getName(), isInstallPhase);
                Set<Class<?>> classes = this.getExposedClasses(context);
                if (classes != null && !classes.isEmpty()) {
                    for (Class clazz : classes) {
                        existingCallbacks = this.getCallbacks(existingCallbacks, clazz, isInstallPhase);
                    }
                }
            }
            if (installs != null || uninstalls != null || existingCallbacks != null) {
                previous = SecurityActions.setContextClassLoader(context);
                if (installs != null) {
                    this.resolveCallbacks(installs, state, isInstallPhase, isInstallPhase, true);
                }
                if (uninstalls != null) {
                    this.resolveCallbacks(uninstalls, state, !isInstallPhase, isInstallPhase, false);
                }
                if (existingCallbacks != null && existingCallbacks != null && !existingCallbacks.isEmpty()) {
                    for (CallbackItem<?> callback : existingCallbacks) {
                        if (!state.equals(callback.getDependentState())) continue;
                        try {
                            callback.changeCallback(this, context, isInstallPhase);
                        }
                        catch (Throwable throwable) {
                            this.log.warn((Object)("Broken callback: " + callback), throwable);
                        }
                    }
                }
            }
            if (previous == null) return;
        }
        catch (Throwable t) {
            try {
                this.log.warn((Object)("Cannot resolve callbacks, state= " + state + ", isInstall= " + isInstallPhase + ", context= " + context), t);
                if (previous == null) return;
            }
            catch (Throwable throwable) {
                if (previous == null) throw throwable;
                SecurityActions.resetContextClassLoader(previous);
                throw throwable;
            }
            SecurityActions.resetContextClassLoader(previous);
            return;
        }
        SecurityActions.resetContextClassLoader(previous);
        return;
    }

    protected void handleInstallLifecycleCallbacks(ControllerContext context, ControllerState state) throws Throwable {
        this.handleLifecycleCallbacks(context, state, true);
    }

    protected void handleUninstallLifecycleCallbacks(ControllerContext context, ControllerState state) throws Throwable {
        ControllerState oldState = this.stateModel.getNextState(state);
        this.handleLifecycleCallbacks(context, oldState, false);
    }

    protected void handleLifecycleCallbacks(ControllerContext context, ControllerState state, boolean install) throws Throwable {
        DependencyInfo di = context.getDependencyInfo();
        if (di != null) {
            List<LifecycleCallbackItem> callbacks = di.getLifecycleCallbacks();
            for (LifecycleCallbackItem callback : callbacks) {
                if (!callback.getWhenRequired().equals(state)) continue;
                if (install) {
                    callback.install(context);
                    continue;
                }
                callback.uninstall(context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void install(ControllerContext context, ControllerState fromState, ControllerState toState) throws Throwable {
        long time = 0L;
        boolean collectStats = this.collectStats;
        if (collectStats) {
            time = System.currentTimeMillis();
        }
        try {
            context.install(fromState, toState);
        }
        finally {
            if (collectStats && (time = System.currentTimeMillis() - time) > 0L) {
                AbstractController abstractController = this;
                synchronized (abstractController) {
                    if (this.installStats == null) {
                        this.installStats = new StateStatistics();
                    }
                    String state = toState.getStateString();
                    String name = context.getName().toString();
                    this.installStats.addStatistic(state, name, time);
                }
            }
        }
    }

    protected void uninstall(ControllerContext context, ControllerState fromState, ControllerState toState) {
        context.uninstall(fromState, toState);
    }

    protected boolean advance(ControllerContext context) {
        ControllerMode mode = context.getMode();
        if (ControllerMode.DISABLED.equals((Object)mode)) {
            return false;
        }
        return this.stateModel.isBeforeState(context.getState(), context.getRequiredState());
    }

    protected void lockRead() {
        this.lock.readLock().lock();
    }

    protected void unlockRead() {
        this.lock.readLock().unlock();
    }

    protected void lockWrite() {
        this.lock.writeLock().lock();
    }

    protected void unlockWrite() {
        this.lock.writeLock().unlock();
    }

    protected ControllerContext getRegisteredControllerContext(Object name, boolean mustExist) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        ControllerContext result = this.allContexts.get(name);
        if (mustExist && result == null) {
            throw new IllegalStateException("Context does not exist with name: " + name);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void registerControllerContext(ControllerContext context) {
        block14: {
            if (context == null) {
                throw new IllegalArgumentException("Null context");
            }
            Set<Object> aliases = context.getAliases();
            Object name = context.getName();
            this.registerControllerContext(name, context);
            if (aliases != null && !aliases.isEmpty()) {
                int ok = 0;
                for (Object alias : aliases) {
                    this.registerControllerContext(alias, context);
                    ++ok;
                }
                Object var8_7 = null;
                if (ok == aliases.size() || ok <= 0) break block14;
                for (Object alias : aliases) {
                    if (ok-- == 0) break;
                    try {
                        this.unregisterControllerContext(alias);
                    }
                    catch (Throwable ignored) {
                        this.log.debugf(ignored, "Error unregistering alias: %1s", new Object[]{alias});
                    }
                }
                try {
                    this.unregisterControllerContext(name);
                }
                catch (Throwable ignored) {
                    this.log.debugf(ignored, "Error unregistering context with name: %1s", new Object[]{name});
                }
                break block14;
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    if (ok != aliases.size() && ok > 0) {
                        for (Object alias : aliases) {
                            if (ok-- == 0) break;
                            try {
                                this.unregisterControllerContext(alias);
                            }
                            catch (Throwable ignored) {
                                this.log.debugf(ignored, "Error unregistering alias: %1s", new Object[]{alias});
                            }
                        }
                        try {
                            this.unregisterControllerContext(name);
                        }
                        catch (Throwable ignored) {
                            this.log.debugf(ignored, "Error unregistering context with name: %1s", new Object[]{name});
                        }
                    }
                    throw throwable;
                }
            }
        }
    }

    protected void unregisterControllerContext(ControllerContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        Set<Object> aliases = context.getAliases();
        Object name = context.getName();
        this.unregisterControllerContext(name);
        if (aliases != null && !aliases.isEmpty()) {
            for (Object alias : aliases) {
                try {
                    this.unregisterControllerContext(alias);
                }
                catch (Throwable ignored) {
                    this.log.debugf(ignored, "Error unregistering alias: %1s", new Object[]{alias});
                }
            }
        }
    }

    protected void registerControllerContext(Object name, ControllerContext context) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        if (this.allContexts.containsKey(name)) {
            throw new IllegalStateException("Unable to register context " + context.toShortString() + ", name already exists: " + name);
        }
        this.allContexts.put(name, context);
    }

    protected void unregisterControllerContext(Object name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        this.allContexts.remove(name);
    }

    @Override
    public boolean isAsynchronousInstallInProgress(ControllerContext context) {
        if (context.getMode() != ControllerMode.ASYNCHRONOUS) {
            return false;
        }
        return this.contextsInstalledByExecutor.checkInstalled(context) != AsynchronousInstallStatus.NOT_INSTALLING;
    }

    @Override
    public Set<ControllerContext> filter(Iterable<ControllerContext> contexts, ContextFilter filter) {
        return this.registry.filter(contexts, filter);
    }

    @Override
    public Set<ControllerContext> getInstantiatedContexts(Class<?> clazz) {
        return this.registry.getInstantiatedContexts(clazz);
    }

    @Override
    public Set<ControllerContext> getContexts(Class<?> clazz, ControllerState state) {
        return this.registry.getContexts(clazz, state);
    }

    @Override
    public ControllerContext getContextByClass(Class<?> clazz) {
        return this.registry.getContextByClass(clazz);
    }

    @Override
    public void addInstantiatedContext(ControllerContext context) {
        this.registry.addInstantiatedContext(context);
    }

    @Override
    public void registerInstantiatedContext(ControllerContext context, Class<?> ... classes) {
        this.registry.registerInstantiatedContext(context, classes);
    }

    @Override
    public void unregisterInstantiatedContext(ControllerContext context, Class<?> ... classes) {
        this.registry.unregisterInstantiatedContext(context, classes);
    }

    @Override
    public void removeInstantiatedContext(ControllerContext context) {
        this.registry.removeInstantiatedContext(context);
    }

    @Override
    public Set<Class<?>> getExposedClasses(ControllerContext context) {
        return this.registry.getExposedClasses(context);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum AsynchronousInstallStatus {
        NOT_INSTALLING,
        OTHER_THREAD,
        IN_PROGRESS;

    }

    private static class ContextsInstalledByExecutor {
        Map<ControllerContext, InterruptibleControllerTask> executorTasksByContext = new ConcurrentHashMap<ControllerContext, InterruptibleControllerTask>();

        private ContextsInstalledByExecutor() {
        }

        boolean shouldInstallAsynchronously(ControllerContext context) {
            if (context.getMode() == ControllerMode.ASYNCHRONOUS) {
                InterruptibleControllerTask task = this.executorTasksByContext.get(context);
                return task == null || task.getThread() != Thread.currentThread();
            }
            return false;
        }

        void markForTaskExecution(ControllerContext context, InterruptibleControllerTask task) {
            this.executorTasksByContext.put(context, task);
        }

        void disassociateWithTask(ControllerContext context) {
            this.executorTasksByContext.remove(context);
        }

        AsynchronousInstallStatus checkInstalled(ControllerContext context) {
            InterruptibleControllerTask task = this.executorTasksByContext.get(context);
            if (task == null) {
                return AsynchronousInstallStatus.NOT_INSTALLING;
            }
            if (Thread.currentThread() != task.getThread()) {
                return AsynchronousInstallStatus.OTHER_THREAD;
            }
            return AsynchronousInstallStatus.IN_PROGRESS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void interruptTaskAndBlock(ControllerContext context, AbstractController controller) {
            InterruptibleControllerTask task = this.executorTasksByContext.get(context);
            if (task != null) {
                controller.unlockWrite();
                try {
                    CountDownLatch latch = task.interrupt();
                    if (latch != null) {
                        try {
                            latch.await();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
                finally {
                    controller.lockWrite();
                }
            }
        }
    }

    class InstallControllerContextTask
    extends InterruptibleControllerTask {
        ControllerContext context;
        ClassLoader classLoader;
        boolean trace;

        public InstallControllerContextTask(ControllerContext context, boolean trace) {
            this.context = context;
            this.classLoader = SecurityActions.getContextClassLoader();
            this.trace = trace;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this.associateWithThreadOrDisassociateIfInterrupted(this.context)) {
                return;
            }
            if (this.trace) {
                AbstractController.this.log.trace((Object)(Thread.currentThread().getName() + " starting asyncronous install of " + this.context.getName()));
            }
            AbstractController.this.lockWrite();
            ClassLoader tcl = SecurityActions.setContextClassLoader(this.classLoader);
            try {
                boolean stateChanged = false;
                try {
                    stateChanged = this.installMyContext();
                }
                finally {
                    AbstractController.this.contextsInstalledByExecutor.disassociateWithTask(this.context);
                }
                if (stateChanged && !this.interrupted) {
                    AbstractController.this.resolveContexts(this.trace);
                }
            }
            catch (Throwable t) {
                Object ctx = this.trace ? this.context : this.context.getName();
                AbstractController.this.log.error((Object)("Problem installing context asynchronously " + ctx), t);
            }
            finally {
                if (this.trace) {
                    AbstractController.this.log.trace((Object)(Thread.currentThread().getName() + " asynchronous install done for " + this.context.getName()));
                }
                SecurityActions.resetContextClassLoader(tcl);
                AbstractController.this.unlockWrite();
                this.disassociateWithThreadAndSignalEnd();
            }
        }

        boolean installMyContext() {
            boolean stateChanged = false;
            if (!AbstractController.this.stateModel.isValidState(this.context.getRequiredState())) {
                throw new IllegalArgumentException("Unknown state: " + this.context.getRequiredState());
            }
            boolean resolved = true;
            while (resolved && AbstractController.this.stateModel.isBeforeState(this.context.getState(), this.context.getRequiredState()) && !this.interrupted) {
                resolved = false;
                ControllerState toState = AbstractController.this.stateModel.getNextState(this.context.getState());
                if (!AbstractController.this.advance(this.context)) continue;
                try {
                    if (AbstractController.this.resolveDependencies(this.context, toState)) {
                        resolved = true;
                    }
                }
                catch (Throwable error) {
                    Object ctx = this.trace ? this.context : this.context.getName();
                    AbstractController.this.log.error((Object)("Error resolving dependencies for " + toState.getStateString() + ": " + ctx), error);
                    AbstractController.this.uninstallContext(this.context, AbstractController.this.stateModel.getInitialState(), this.trace);
                    AbstractController.this.errorContexts.put(this.context.getName(), this.context);
                    this.context.setError(error);
                }
                if (!resolved || !(resolved = AbstractController.this.incrementState(this.context, this.trace))) continue;
                stateChanged = true;
            }
            return stateChanged;
        }
    }

    abstract class InterruptibleControllerTask
    implements Runnable {
        Thread thread;
        volatile boolean interrupted;
        CountDownLatch interruptedLatch;

        InterruptibleControllerTask() {
        }

        synchronized Thread getThread() {
            return this.thread;
        }

        synchronized CountDownLatch interrupt() {
            this.interrupted = true;
            if (this.thread != null) {
                this.interruptedLatch = new CountDownLatch(1);
                return this.interruptedLatch;
            }
            return null;
        }

        boolean isInterrupted() {
            return this.interrupted;
        }

        synchronized boolean associateWithThreadOrDisassociateIfInterrupted(ControllerContext context) {
            if (this.interrupted) {
                AbstractController.this.contextsInstalledByExecutor.disassociateWithTask(context);
                return true;
            }
            this.thread = Thread.currentThread();
            return false;
        }

        synchronized void disassociateWithThreadAndSignalEnd() {
            this.thread = null;
            if (this.interruptedLatch != null) {
                this.interruptedLatch.countDown();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AliasControllerContextAction
    extends SimpleControllerContextAction<AliasControllerContext> {
        private AliasControllerContextAction() {
        }

        @Override
        protected AliasControllerContext contextCast(ControllerContext context) {
            return (AliasControllerContext)AliasControllerContext.class.cast(context);
        }

        @Override
        protected boolean validateContext(ControllerContext context) {
            return context instanceof AliasControllerContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void installAction(AliasControllerContext context) throws Throwable {
            Object original;
            Object jmxOriginal;
            Object alias = context.getAlias();
            Object jmxAlias = JMXObjectNameFix.needsAnAlias(alias);
            if (jmxAlias != null) {
                alias = jmxAlias;
            }
            if ((jmxOriginal = JMXObjectNameFix.needsAnAlias(original = context.getOriginal())) != null) {
                original = jmxOriginal;
            }
            AbstractController controller = (AbstractController)context.getController();
            AbstractController.this.lockWrite();
            try {
                ControllerContext lookup = controller.getRegisteredControllerContext(original, true);
                controller.registerControllerContext(alias, lookup);
                if (AbstractController.this.log.isTraceEnabled()) {
                    AbstractController.this.log.trace((Object)("Added alias " + alias + " for context " + context));
                }
            }
            finally {
                AbstractController.this.unlockWrite();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void uninstallAction(AliasControllerContext context) {
            AbstractController.this.lockWrite();
            try {
                Object alias = context.getAlias();
                Object jmxAlias = JMXObjectNameFix.needsAnAlias(alias);
                if (jmxAlias != null) {
                    alias = jmxAlias;
                }
                AbstractController controller = (AbstractController)context.getController();
                controller.unregisterControllerContext(alias);
                if (AbstractController.this.log.isTraceEnabled()) {
                    AbstractController.this.log.trace((Object)("Removed alias " + alias));
                }
            }
            finally {
                AbstractController.this.unlockWrite();
            }
        }
    }

    private static class InnerAliasControllerContext
    extends AbstractAliasControllerContext {
        private InnerAliasControllerContext(Object alias, String id, Object original, ControllerContextActions actions) {
            super(alias, id, original, actions);
        }
    }
}

