/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dependency.spi;

import java.util.Arrays;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.util.JBossStringBuilder;
import org.jboss.xb.annotations.JBossXmlEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JBossXmlEnum(ignoreCase=true)
public enum ControllerMode {
    AUTOMATIC("Automatic", ControllerState.INSTALLED),
    ON_DEMAND("On Demand", ControllerState.DESCRIBED),
    MANUAL("Manual"),
    DISABLED("Disabled"),
    ASYNCHRONOUS("Asynchronous", ControllerState.INSTALLED);

    private final String modeString;
    private ControllerState requiredState;

    private ControllerMode(String modeString) {
        this(modeString, null);
    }

    private ControllerMode(String modeString, ControllerState requiredState) {
        if (modeString == null) {
            throw new IllegalArgumentException("Null mode string");
        }
        if (requiredState == null) {
            requiredState = ControllerState.NOT_INSTALLED;
        }
        this.modeString = modeString;
        this.requiredState = requiredState;
    }

    public static ControllerMode getInstance(String modeString) {
        if (modeString == null) {
            throw new IllegalArgumentException("Null mode string.");
        }
        for (ControllerMode cm : ControllerMode.values()) {
            if (!modeString.equalsIgnoreCase(cm.getModeString())) continue;
            return cm;
        }
        throw new IllegalArgumentException("No such controller mode: " + modeString + ", available: " + Arrays.toString((Object[])ControllerMode.values()));
    }

    public String getModeString() {
        return this.modeString;
    }

    public ControllerState getRequiredState() {
        return this.requiredState;
    }

    public void toString(JBossStringBuilder buffer) {
        buffer.append(this.modeString);
    }
}

