/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.guice.plugins;

import com.google.inject.Binder;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.guice.spi.ControllerContextBindFilter;
import org.jboss.guice.spi.GuiceIntegration;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.event.KernelEvent;
import org.jboss.kernel.spi.event.KernelEventListener;
import org.jboss.kernel.spi.registry.KernelRegistry;
import org.jboss.kernel.spi.registry.KernelRegistryEntry;

public class GuiceListener
extends GuiceIntegration
implements KernelEventListener {
    private KernelRegistry registry;
    private ControllerContextBindFilter filter;

    public GuiceListener(Kernel kernel, Binder binder) {
        super(kernel, binder);
        binder.skipSources(new Class[]{GuiceListener.class});
        this.registry = kernel.getRegistry();
    }

    public void start() throws Throwable {
        this.registry.registerListener((KernelEventListener)this, null, null);
    }

    public void stop() throws Throwable {
        this.registry.unregisterListener((KernelEventListener)this, null, null);
    }

    public void onEvent(KernelEvent event, Object handback) {
        Object name = event.getContext();
        String type = event.getType();
        if ("KERNEL_REGISTRY_REGISTERED".equals(type)) {
            Object source = event.getSource();
            if (source instanceof KernelRegistry) {
                KernelRegistry registry = (KernelRegistry)source;
                KernelRegistryEntry entry = registry.getEntry(name);
                if (this.filter == null || this.filter.bind((ControllerContext)entry)) {
                    GuiceListener.bindContext(this.getBinder(), (Controller)this.getController(), (ControllerContext)entry);
                }
            }
        } else if ("KERNEL_REGISTRY_UNREGISTERED".equals(type)) {
            // empty if block
        }
    }

    public void setFilter(ControllerContextBindFilter filter) {
        this.filter = filter;
    }
}

