/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.guice.spi;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.beans.metadata.plugins.AbstractArrayMetaData;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractConstructorMetaData;
import org.jboss.beans.metadata.plugins.AbstractDependencyValueMetaData;
import org.jboss.beans.metadata.plugins.AbstractParameterMetaData;
import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
import org.jboss.beans.metadata.plugins.factory.GenericBeanFactory;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ClassLoaderMetaData;
import org.jboss.beans.metadata.spi.ConstructorMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.guice.plugins.GuiceInjectorFactory;
import org.jboss.guice.plugins.GuiceObject;
import org.jboss.guice.spi.BinderHolder;
import org.jboss.guice.spi.ControllerContextBindFilter;
import org.jboss.guice.spi.GuiceKernelRegistryEntryPlugin;
import org.jboss.guice.spi.InjectableMicrocontainerProvider;
import org.jboss.guice.spi.MicrocontainerProvider;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.config.Configurator;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.reflect.spi.ClassInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GuiceIntegration
extends BinderHolder {
    static final String DEFAULT_GUICE_PLUGIN_PREFIX = "GuicePlugin";
    static final AtomicInteger GUICE_PLUGIN_COUNTER = new AtomicInteger();
    private static final ControllerContextBindFilter ALL = new ControllerContextBindFilter(){

        public boolean bind(ControllerContext context) {
            return true;
        }
    };
    private KernelController controller;

    protected GuiceIntegration(Kernel kernel, Binder binder) {
        super(binder);
        binder.skipSources(new Class[]{GuiceIntegration.class});
        if (kernel == null) {
            throw new IllegalArgumentException("Null kernel.");
        }
        this.controller = kernel.getController();
    }

    protected KernelController getController() {
        return this.controller;
    }

    public static <T> Provider<T> fromMicrocontainer(Class<T> type, Object name) {
        return new InjectableMicrocontainerProvider<T>(type, name);
    }

    public static <T> Provider<T> fromMicrocontainer(Class<T> type) {
        return GuiceIntegration.fromMicrocontainer(type, type);
    }

    public static void bindAll(Binder binder, Controller controller) {
        GuiceIntegration.bindAll(binder, controller, ALL);
    }

    public static void bindAll(Binder binder, Controller controller, ControllerContextBindFilter filter) {
        Set installedContexts = controller.getContextsByState(ControllerState.INSTALLED);
        if (installedContexts != null && !installedContexts.isEmpty()) {
            for (ControllerContext context : installedContexts) {
                if (!filter.bind(context)) continue;
                GuiceIntegration.bindContext(binder, controller, context);
            }
        }
    }

    protected static void bindContext(Binder binder, Controller controller, ControllerContext context) {
        GenericBeanFactory gbf;
        String bean;
        Class targetClass = null;
        Object target = context.getTarget();
        if (target != null && GenericBeanFactory.class.isAssignableFrom(targetClass = target.getClass()) && (bean = (gbf = (GenericBeanFactory)target).getBean()) != null && controller instanceof KernelController) {
            try {
                ClassLoader classLoader = Configurator.getClassLoader((ClassLoaderMetaData)gbf.getClassLoader());
                KernelController kernelController = (KernelController)controller;
                KernelConfigurator configurator = kernelController.getKernel().getConfigurator();
                ClassInfo info = configurator.getClassInfo(bean, classLoader);
                targetClass = info.getType();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        if (targetClass != null) {
            GuiceIntegration.bindBean(binder, controller, context.getName().toString(), targetClass);
            Set aliases = context.getAliases();
            if (aliases != null && !aliases.isEmpty()) {
                for (Object alias : aliases) {
                    GuiceIntegration.bindBean(binder, controller, alias.toString(), targetClass);
                }
            }
        }
    }

    static <T> void bindBean(Binder binder, Controller controller, String name, Class<T> type) {
        MicrocontainerProvider<T> provider = new MicrocontainerProvider<T>(type, name);
        provider.initialize(controller);
        binder.bind(type).annotatedWith((Annotation)Names.named((String)name)).toProvider(provider);
    }

    public static ControllerContext registerModules(Controller controller, Module ... modules) {
        return GuiceIntegration.registerModules(DEFAULT_GUICE_PLUGIN_PREFIX + GUICE_PLUGIN_COUNTER.incrementAndGet(), controller, modules);
    }

    public static ControllerContext registerModules(String name, Controller controller, Module ... modules) {
        try {
            if (!(controller instanceof KernelController)) {
                throw new IllegalArgumentException("Controller is not an instance of KernelController");
            }
            AbstractBeanMetaData guicePlugin = new AbstractBeanMetaData(name, GuiceKernelRegistryEntryPlugin.class.getName());
            AbstractConstructorMetaData constructor = new AbstractConstructorMetaData();
            AbstractArrayMetaData arrayMetaData = new AbstractArrayMetaData();
            for (Module module : modules) {
                arrayMetaData.add((MetaDataVisitorNode)new AbstractValueMetaData((Object)module));
            }
            constructor.setParameters(Collections.singletonList(new AbstractParameterMetaData((ValueMetaData)arrayMetaData)));
            guicePlugin.setConstructor((ConstructorMetaData)constructor);
            return ((KernelController)controller).install((BeanMetaData)guicePlugin);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static Injector registerInjector(String name, Controller controller, GuiceObject ... guiceObjects) {
        try {
            if (!(controller instanceof KernelController)) {
                throw new IllegalArgumentException("Controller is not an instance of KernelController");
            }
            AbstractBeanMetaData injectorBean = new AbstractBeanMetaData(name, GuiceInjectorFactory.class.getName());
            AbstractConstructorMetaData constructor = new AbstractConstructorMetaData();
            constructor.setFactoryClass(GuiceInjectorFactory.class.getName());
            constructor.setFactoryMethod("createInjector");
            ArrayList<AbstractParameterMetaData> parameters = new ArrayList<AbstractParameterMetaData>();
            parameters.add(new AbstractParameterMetaData((ValueMetaData)new AbstractDependencyValueMetaData((Object)"jboss.kernel:service=Kernel")));
            AbstractArrayMetaData array = new AbstractArrayMetaData();
            for (GuiceObject guiceObject : guiceObjects) {
                array.add((MetaDataVisitorNode)new AbstractValueMetaData((Object)guiceObject));
            }
            parameters.add(new AbstractParameterMetaData((ValueMetaData)array));
            constructor.setParameters(parameters);
            injectorBean.setConstructor((ConstructorMetaData)constructor);
            return (Injector)((KernelController)controller).install((BeanMetaData)injectorBean).getTarget();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

