/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.microcontainer.jmx;

import javax.management.ObjectName;
import org.jboss.aop.microcontainer.aspects.jmx.JMX;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.metadata.spi.MetaData;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.system.ServiceController;

public abstract class AbstractServiceControllerLifecycleCallback {
    private ServiceController serviceController;
    protected static final ObjectName MBEAN_REGISTRY = ObjectNameFactory.create((String)"JMImplementation:type=MBeanRegistry");

    public ServiceController getServiceController() {
        return this.serviceController;
    }

    public void setServiceController(ServiceController serviceController) {
        this.serviceController = serviceController;
    }

    public void create() throws Exception {
        if (this.serviceController == null) {
            throw new IllegalStateException("No service controller configured");
        }
    }

    public abstract void install(ControllerContext var1) throws Exception;

    public abstract void uninstall(ControllerContext var1) throws Exception;

    protected JMX readJmxAnnotation(ControllerContext context) throws Exception {
        MetaData metaData = context.getScopeInfo().getMetaData();
        if (metaData != null) {
            return (JMX)metaData.getAnnotation(JMX.class);
        }
        return null;
    }

    protected ObjectName createObjectName(ControllerContext context, JMX jmx) throws Exception {
        String jmxName;
        ObjectName objectName = null;
        if (jmx != null && (jmxName = jmx.name()) != null && jmxName.length() > 0) {
            objectName = new ObjectName(jmxName);
        }
        if (objectName == null) {
            String name = (String)context.getName();
            objectName = name.contains(":") ? new ObjectName(name) : new ObjectName("jboss.pojo:name='" + name + "'");
        }
        return objectName;
    }

    protected ObjectName determineObjectName(ControllerContext context) throws Exception {
        JMX jmx = this.readJmxAnnotation(context);
        return this.createObjectName(context, jmx);
    }
}

