/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.annotations.test;

import java.util.List;
import junit.framework.Test;
import org.jboss.kernel.plugins.annotations.BeanAnnotationAdapter;
import org.jboss.kernel.plugins.annotations.MetaDataAnnotationPlugin;
import org.jboss.test.kernel.annotations.support.TestOrderPlugin;
import org.jboss.test.kernel.annotations.support.TestOrderPluginBean;
import org.jboss.test.kernel.annotations.support.TestOrderedPluginAnnotationAdapter;
import org.jboss.test.kernel.annotations.test.AbstractBeanAnnotationAdapterTest;

public class OrderedAnnotationPluginsTestCase
extends AbstractBeanAnnotationAdapterTest {
    public OrderedAnnotationPluginsTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        return OrderedAnnotationPluginsTestCase.suite(OrderedAnnotationPluginsTestCase.class);
    }

    protected BeanAnnotationAdapter getBeanAnnotationAdapterClass() {
        return TestOrderedPluginAnnotationAdapter.INSTANCE;
    }

    public void testOrdered() throws Throwable {
        this.testOrder(10);
    }

    public void testRemovingAndAddingPlugin() throws Throwable {
        TestOrderedPluginAnnotationAdapter.INSTANCE.removeAnnotationPlugin((MetaDataAnnotationPlugin)TestOrderedPluginAnnotationAdapter.PLUGIN_NINE);
        this.testOrder(9);
        TestOrderedPluginAnnotationAdapter.INSTANCE.addAnnotationPlugin((MetaDataAnnotationPlugin)TestOrderedPluginAnnotationAdapter.PLUGIN_NINE);
        this.testOrder(10);
    }

    private void testOrder(int max) throws Throwable {
        TestOrderPlugin.clear();
        this.runAnnotationsOnTarget(new TestOrderPluginBean());
        List<Integer> applied = TestOrderPlugin.getApplied();
        OrderedAnnotationPluginsTestCase.assertEquals((int)max, (int)applied.size());
        for (int i = 0; i < max; ++i) {
            OrderedAnnotationPluginsTestCase.assertEquals((Object)i, (Object)applied.get(i));
        }
        List<Integer> cleaned = TestOrderPlugin.getCleaned();
        OrderedAnnotationPluginsTestCase.assertEquals((int)max, (int)cleaned.size());
        for (int i = 0; i < max; ++i) {
            OrderedAnnotationPluginsTestCase.assertEquals((Object)i, (Object)cleaned.get(i));
        }
    }
}

