/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.annotations.test.constructor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractAnnotationMetaData;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractConstructorMetaData;
import org.jboss.beans.metadata.plugins.AbstractParameterMetaData;
import org.jboss.beans.metadata.spi.AnnotationMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ConstructorMetaData;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.metadata.KernelMetaDataRepository;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.signature.ConstructorParametersSignature;
import org.jboss.metadata.spi.signature.ConstructorSignature;
import org.jboss.metadata.spi.signature.Signature;
import org.jboss.test.kernel.annotations.support.AnnotatedConstructorBean;
import org.jboss.test.kernel.annotations.support.ConstructorA;
import org.jboss.test.kernel.annotations.support.ConstructorB;
import org.jboss.test.kernel.junit.MicrocontainerTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedConstructorTestCase
extends MicrocontainerTest {
    public AnnotatedConstructorTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        return AnnotatedConstructorTestCase.suite(AnnotatedConstructorTestCase.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnnotatedConstructorNoParametersNoAnnotations() throws Throwable {
        AbstractBeanMetaData bmd = new AbstractBeanMetaData("Bean", AnnotatedConstructorBean.class.getName());
        KernelControllerContext context = null;
        try {
            context = this.deploy((BeanMetaData)bmd);
            AnnotatedConstructorBean bean = (AnnotatedConstructorBean)this.assertBean("Bean", AnnotatedConstructorBean.class);
            Constructor constructor = AnnotatedConstructorBean.class.getConstructor(new Class[0]);
            AnnotatedConstructorTestCase.assertEquals((long)0L, (long)bean.i);
            AnnotatedConstructorTestCase.assertEquals((long)0L, (long)bean.j);
            this.assertConstructorAnnotations(context, constructor, new Class[0]);
        }
        finally {
            this.undeploy(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnnotatedConstructorNoParameters() throws Throwable {
        AbstractBeanMetaData bmd = new AbstractBeanMetaData("Bean", AnnotatedConstructorBean.class.getName());
        AbstractConstructorMetaData cmd = new AbstractConstructorMetaData();
        cmd.setAnnotations(this.createAnnotationMetaDataSet(ConstructorA.class, ConstructorB.class));
        bmd.setConstructor((ConstructorMetaData)cmd);
        KernelControllerContext context = null;
        try {
            context = this.deploy((BeanMetaData)bmd);
            AnnotatedConstructorBean bean = (AnnotatedConstructorBean)this.assertBean("Bean", AnnotatedConstructorBean.class);
            Constructor constructor = AnnotatedConstructorBean.class.getConstructor(new Class[0]);
            AnnotatedConstructorTestCase.assertEquals((long)0L, (long)bean.i);
            AnnotatedConstructorTestCase.assertEquals((long)0L, (long)bean.j);
            this.assertConstructorAnnotations(context, constructor, ConstructorA.class, ConstructorB.class);
        }
        finally {
            this.undeploy(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnnotatedConstructorOneParameterNoAnnotations() throws Throwable {
        AbstractBeanMetaData bmd = new AbstractBeanMetaData("Bean", AnnotatedConstructorBean.class.getName());
        AbstractConstructorMetaData cmd = new AbstractConstructorMetaData();
        AbstractParameterMetaData pmd = new AbstractParameterMetaData("int", (Object)1);
        ArrayList<AbstractParameterMetaData> params = new ArrayList<AbstractParameterMetaData>();
        params.add(pmd);
        cmd.setParameters(params);
        bmd.setConstructor((ConstructorMetaData)cmd);
        KernelControllerContext context = null;
        try {
            context = this.deploy((BeanMetaData)bmd);
            AnnotatedConstructorBean bean = (AnnotatedConstructorBean)this.assertBean("Bean", AnnotatedConstructorBean.class);
            Constructor constructor = AnnotatedConstructorBean.class.getConstructor(Integer.TYPE);
            AnnotatedConstructorTestCase.assertEquals((long)1L, (long)bean.i);
            AnnotatedConstructorTestCase.assertEquals((long)0L, (long)bean.j);
            this.assertConstructorAnnotations(context, constructor, new Class[0]);
            this.assertConstructorParameterAnnotations(context, constructor, 0, new Class[0]);
        }
        finally {
            this.undeploy(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnnotatedConstructorOneParameterAnnotationsOnConstructor() throws Throwable {
        AbstractBeanMetaData bmd = new AbstractBeanMetaData("Bean", AnnotatedConstructorBean.class.getName());
        AbstractConstructorMetaData cmd = new AbstractConstructorMetaData();
        cmd.setAnnotations(this.createAnnotationMetaDataSet(ConstructorA.class));
        AbstractParameterMetaData pmd = new AbstractParameterMetaData("int", (Object)1);
        ArrayList<AbstractParameterMetaData> params = new ArrayList<AbstractParameterMetaData>();
        params.add(pmd);
        cmd.setParameters(params);
        bmd.setConstructor((ConstructorMetaData)cmd);
        KernelControllerContext context = null;
        try {
            context = this.deploy((BeanMetaData)bmd);
            AnnotatedConstructorBean bean = (AnnotatedConstructorBean)this.assertBean("Bean", AnnotatedConstructorBean.class);
            Constructor constructor = AnnotatedConstructorBean.class.getConstructor(Integer.TYPE);
            AnnotatedConstructorTestCase.assertEquals((long)1L, (long)bean.i);
            AnnotatedConstructorTestCase.assertEquals((long)0L, (long)bean.j);
            this.assertConstructorAnnotations(context, constructor, ConstructorA.class);
            this.assertConstructorParameterAnnotations(context, constructor, 0, new Class[0]);
        }
        finally {
            this.undeploy(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnnotatedConstructorOneParameterAnnotationsOnConstructorAndParameter() throws Throwable {
        AbstractBeanMetaData bmd = new AbstractBeanMetaData("Bean", AnnotatedConstructorBean.class.getName());
        AbstractConstructorMetaData cmd = new AbstractConstructorMetaData();
        cmd.setAnnotations(this.createAnnotationMetaDataSet(ConstructorA.class));
        AbstractParameterMetaData pmd = new AbstractParameterMetaData("int", (Object)1);
        pmd.setAnnotations(this.createAnnotationMetaDataSet(ConstructorB.class));
        ArrayList<AbstractParameterMetaData> params = new ArrayList<AbstractParameterMetaData>();
        params.add(pmd);
        cmd.setParameters(params);
        bmd.setConstructor((ConstructorMetaData)cmd);
        KernelControllerContext context = null;
        try {
            context = this.deploy((BeanMetaData)bmd);
            AnnotatedConstructorBean bean = (AnnotatedConstructorBean)this.assertBean("Bean", AnnotatedConstructorBean.class);
            Constructor constructor = AnnotatedConstructorBean.class.getConstructor(Integer.TYPE);
            AnnotatedConstructorTestCase.assertEquals((long)1L, (long)bean.i);
            AnnotatedConstructorTestCase.assertEquals((long)0L, (long)bean.j);
            this.assertConstructorAnnotations(context, constructor, ConstructorA.class);
            this.assertConstructorParameterAnnotations(context, constructor, 0, ConstructorB.class);
        }
        finally {
            this.undeploy(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnnotatedConstructorOneParameterAnnotationsOnParameter() throws Throwable {
        AbstractBeanMetaData bmd = new AbstractBeanMetaData("Bean", AnnotatedConstructorBean.class.getName());
        AbstractConstructorMetaData cmd = new AbstractConstructorMetaData();
        AbstractParameterMetaData pmd = new AbstractParameterMetaData("int", (Object)1);
        pmd.setAnnotations(this.createAnnotationMetaDataSet(ConstructorA.class));
        ArrayList<AbstractParameterMetaData> params = new ArrayList<AbstractParameterMetaData>();
        params.add(pmd);
        cmd.setParameters(params);
        bmd.setConstructor((ConstructorMetaData)cmd);
        KernelControllerContext context = null;
        try {
            context = this.deploy((BeanMetaData)bmd);
            AnnotatedConstructorBean bean = (AnnotatedConstructorBean)this.assertBean("Bean", AnnotatedConstructorBean.class);
            Constructor constructor = AnnotatedConstructorBean.class.getConstructor(Integer.TYPE);
            AnnotatedConstructorTestCase.assertEquals((long)1L, (long)bean.i);
            AnnotatedConstructorTestCase.assertEquals((long)0L, (long)bean.j);
            this.assertConstructorAnnotations(context, constructor, new Class[0]);
            this.assertConstructorParameterAnnotations(context, constructor, 0, ConstructorA.class);
        }
        finally {
            this.undeploy(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnnotatedConstructorTwoConstructorAnnotations() throws Throwable {
        AbstractBeanMetaData bmd = new AbstractBeanMetaData("Bean", AnnotatedConstructorBean.class.getName());
        AbstractConstructorMetaData cmd = new AbstractConstructorMetaData();
        cmd.setAnnotations(this.createAnnotationMetaDataSet(ConstructorA.class));
        AbstractParameterMetaData pmd0 = new AbstractParameterMetaData("long", (Object)1);
        AbstractParameterMetaData pmd1 = new AbstractParameterMetaData("long", (Object)2);
        ArrayList<AbstractParameterMetaData> params = new ArrayList<AbstractParameterMetaData>();
        params.add(pmd0);
        params.add(pmd1);
        cmd.setParameters(params);
        bmd.setConstructor((ConstructorMetaData)cmd);
        KernelControllerContext context = null;
        try {
            context = this.deploy((BeanMetaData)bmd);
            AnnotatedConstructorBean bean = (AnnotatedConstructorBean)this.assertBean("Bean", AnnotatedConstructorBean.class);
            Constructor constructor = AnnotatedConstructorBean.class.getConstructor(Long.TYPE, Long.TYPE);
            AnnotatedConstructorTestCase.assertEquals((long)1L, (long)bean.i);
            AnnotatedConstructorTestCase.assertEquals((long)2L, (long)bean.j);
            this.assertConstructorAnnotations(context, constructor, ConstructorA.class);
            this.assertConstructorParameterAnnotations(context, constructor, 0, new Class[0]);
            this.assertConstructorParameterAnnotations(context, constructor, 1, new Class[0]);
        }
        finally {
            this.undeploy(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnnotatedConstructorTwoConstructorAndParameterOneAnnotations() throws Throwable {
        AbstractBeanMetaData bmd = new AbstractBeanMetaData("Bean", AnnotatedConstructorBean.class.getName());
        AbstractConstructorMetaData cmd = new AbstractConstructorMetaData();
        cmd.setAnnotations(this.createAnnotationMetaDataSet(ConstructorA.class));
        AbstractParameterMetaData pmd0 = new AbstractParameterMetaData("long", (Object)1);
        pmd0.setAnnotations(this.createAnnotationMetaDataSet(ConstructorB.class));
        AbstractParameterMetaData pmd1 = new AbstractParameterMetaData("long", (Object)2);
        ArrayList<AbstractParameterMetaData> params = new ArrayList<AbstractParameterMetaData>();
        params.add(pmd0);
        params.add(pmd1);
        cmd.setParameters(params);
        bmd.setConstructor((ConstructorMetaData)cmd);
        KernelControllerContext context = null;
        try {
            context = this.deploy((BeanMetaData)bmd);
            AnnotatedConstructorBean bean = (AnnotatedConstructorBean)this.assertBean("Bean", AnnotatedConstructorBean.class);
            Constructor constructor = AnnotatedConstructorBean.class.getConstructor(Long.TYPE, Long.TYPE);
            AnnotatedConstructorTestCase.assertEquals((long)1L, (long)bean.i);
            AnnotatedConstructorTestCase.assertEquals((long)2L, (long)bean.j);
            this.assertConstructorAnnotations(context, constructor, ConstructorA.class);
            this.assertConstructorParameterAnnotations(context, constructor, 0, ConstructorB.class);
            this.assertConstructorParameterAnnotations(context, constructor, 1, new Class[0]);
        }
        finally {
            this.undeploy(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnnotatedConstructorTwoConstructorAndParameterTwoAnnotations() throws Throwable {
        AbstractBeanMetaData bmd = new AbstractBeanMetaData("Bean", AnnotatedConstructorBean.class.getName());
        AbstractConstructorMetaData cmd = new AbstractConstructorMetaData();
        cmd.setAnnotations(this.createAnnotationMetaDataSet(ConstructorA.class));
        AbstractParameterMetaData pmd0 = new AbstractParameterMetaData("long", (Object)1);
        AbstractParameterMetaData pmd1 = new AbstractParameterMetaData("long", (Object)2);
        pmd1.setAnnotations(this.createAnnotationMetaDataSet(ConstructorB.class));
        ArrayList<AbstractParameterMetaData> params = new ArrayList<AbstractParameterMetaData>();
        params.add(pmd0);
        params.add(pmd1);
        cmd.setParameters(params);
        bmd.setConstructor((ConstructorMetaData)cmd);
        KernelControllerContext context = null;
        try {
            context = this.deploy((BeanMetaData)bmd);
            AnnotatedConstructorBean bean = (AnnotatedConstructorBean)this.assertBean("Bean", AnnotatedConstructorBean.class);
            Constructor constructor = AnnotatedConstructorBean.class.getConstructor(Long.TYPE, Long.TYPE);
            AnnotatedConstructorTestCase.assertEquals((long)1L, (long)bean.i);
            AnnotatedConstructorTestCase.assertEquals((long)2L, (long)bean.j);
            this.assertConstructorAnnotations(context, constructor, ConstructorA.class);
            this.assertConstructorParameterAnnotations(context, constructor, 0, new Class[0]);
            this.assertConstructorParameterAnnotations(context, constructor, 1, ConstructorB.class);
        }
        finally {
            this.undeploy(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnnotatedConstructorTwoConstructorAndParameterOneTwoAnnotations() throws Throwable {
        AbstractBeanMetaData bmd = new AbstractBeanMetaData("Bean", AnnotatedConstructorBean.class.getName());
        AbstractConstructorMetaData cmd = new AbstractConstructorMetaData();
        cmd.setAnnotations(this.createAnnotationMetaDataSet(ConstructorA.class));
        AbstractParameterMetaData pmd0 = new AbstractParameterMetaData("long", (Object)1);
        pmd0.setAnnotations(this.createAnnotationMetaDataSet(ConstructorA.class, ConstructorB.class));
        AbstractParameterMetaData pmd1 = new AbstractParameterMetaData("long", (Object)2);
        pmd1.setAnnotations(this.createAnnotationMetaDataSet(ConstructorB.class));
        ArrayList<AbstractParameterMetaData> params = new ArrayList<AbstractParameterMetaData>();
        params.add(pmd0);
        params.add(pmd1);
        cmd.setParameters(params);
        bmd.setConstructor((ConstructorMetaData)cmd);
        KernelControllerContext context = null;
        try {
            context = this.deploy((BeanMetaData)bmd);
            AnnotatedConstructorBean bean = (AnnotatedConstructorBean)this.assertBean("Bean", AnnotatedConstructorBean.class);
            Constructor constructor = AnnotatedConstructorBean.class.getConstructor(Long.TYPE, Long.TYPE);
            AnnotatedConstructorTestCase.assertEquals((long)1L, (long)bean.i);
            AnnotatedConstructorTestCase.assertEquals((long)2L, (long)bean.j);
            this.assertConstructorAnnotations(context, constructor, ConstructorA.class);
            this.assertConstructorParameterAnnotations(context, constructor, 0, ConstructorA.class, ConstructorB.class);
            this.assertConstructorParameterAnnotations(context, constructor, 1, ConstructorB.class);
        }
        finally {
            this.undeploy(context);
        }
    }

    private void assertConstructorAnnotations(KernelControllerContext context, Constructor<?> constructor, Class<? extends Annotation> ... expectedAnnotations) {
        Annotation[] annotations = this.getComponentMetaData(context, (Signature)new ConstructorSignature(constructor));
        this.assertAnnnotations(annotations, expectedAnnotations);
    }

    private void assertConstructorParameterAnnotations(KernelControllerContext context, Constructor<?> constructor, int parameterIndex, Class<? extends Annotation> ... expectedAnnotations) {
        Annotation[] annotations = this.getComponentMetaData(context, (Signature)new ConstructorParametersSignature(constructor, parameterIndex));
        this.assertAnnnotations(annotations, expectedAnnotations);
    }

    private void assertAnnnotations(Annotation[] annotations, Class<? extends Annotation>[] expectedAnnotations) {
        AnnotatedConstructorTestCase.assertEquals((int)expectedAnnotations.length, (int)annotations.length);
        for (Class<? extends Annotation> expectedAnnotation : expectedAnnotations) {
            boolean found = false;
            for (Annotation annotation : annotations) {
                if (annotation.annotationType() != expectedAnnotation) continue;
                found = true;
                break;
            }
            AnnotatedConstructorTestCase.assertTrue((String)("Did not find annotation " + expectedAnnotation), (boolean)found);
        }
    }

    private Annotation[] getComponentMetaData(KernelControllerContext context, Signature signature) {
        KernelMetaDataRepository repository = context.getKernel().getMetaDataRepository();
        MetaData metaData = repository.getMetaData((ControllerContext)context);
        MetaData component = metaData.getComponentMetaData(signature);
        return component.getAnnotations();
    }

    private Set<AnnotationMetaData> createAnnotationMetaDataSet(Class<? extends Annotation> ... classes) {
        if (classes == null || classes.length == 0) {
            return null;
        }
        HashSet<AnnotationMetaData> annotations = new HashSet<AnnotationMetaData>();
        for (Class<? extends Annotation> clazz : classes) {
            annotations.add((AnnotationMetaData)new AbstractAnnotationMetaData("@" + clazz.getName()));
        }
        return annotations;
    }
}

