/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.annotations.test.method;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractAnnotationMetaData;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractInstallMetaData;
import org.jboss.beans.metadata.plugins.AbstractParameterMetaData;
import org.jboss.beans.metadata.spi.AnnotationMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.metadata.KernelMetaDataRepository;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.signature.DeclaredMethodSignature;
import org.jboss.metadata.spi.signature.MethodParametersSignature;
import org.jboss.metadata.spi.signature.Signature;
import org.jboss.test.kernel.annotations.support.AnnotatedMethodBean;
import org.jboss.test.kernel.annotations.support.ConstructorB;
import org.jboss.test.kernel.annotations.support.MethodA;
import org.jboss.test.kernel.annotations.support.MethodB;
import org.jboss.test.kernel.junit.MicrocontainerTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedMethodTestCase
extends MicrocontainerTest {
    private static final String METHOD_NAME = "method";

    public AnnotatedMethodTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        return AnnotatedMethodTestCase.suite(AnnotatedMethodTestCase.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnnotatedMethodNoParametersNoAnnotations() throws Throwable {
        AbstractBeanMetaData bmd = new AbstractBeanMetaData("Bean", AnnotatedMethodBean.class.getName());
        AbstractInstallMetaData imd = new AbstractInstallMetaData();
        imd.setMethodName(METHOD_NAME);
        KernelControllerContext context = null;
        try {
            context = this.deploy((BeanMetaData)bmd);
            AnnotatedMethodBean bean = (AnnotatedMethodBean)this.assertBean("Bean", AnnotatedMethodBean.class);
            AnnotatedMethodTestCase.assertEquals((long)0L, (long)bean.i);
            AnnotatedMethodTestCase.assertEquals((long)0L, (long)bean.j);
            Method method = AnnotatedMethodBean.class.getMethod(METHOD_NAME, new Class[0]);
            this.assertMethodAnnotations(context, method, new Class[0]);
        }
        finally {
            this.undeploy(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnnotatedMethodNoParameters() throws Throwable {
        AbstractBeanMetaData bmd = new AbstractBeanMetaData("Bean", AnnotatedMethodBean.class.getName());
        AbstractInstallMetaData imd = new AbstractInstallMetaData();
        imd.setMethodName(METHOD_NAME);
        imd.setAnnotations(this.createAnnotationMetaDataSet(MethodA.class, ConstructorB.class));
        this.addInstallMetaData(bmd, imd);
        KernelControllerContext context = null;
        try {
            context = this.deploy((BeanMetaData)bmd);
            AnnotatedMethodBean bean = (AnnotatedMethodBean)this.assertBean("Bean", AnnotatedMethodBean.class);
            Method method = AnnotatedMethodBean.class.getMethod(METHOD_NAME, new Class[0]);
            AnnotatedMethodTestCase.assertEquals((long)0L, (long)bean.i);
            AnnotatedMethodTestCase.assertEquals((long)0L, (long)bean.j);
            this.assertMethodAnnotations(context, method, MethodA.class, ConstructorB.class);
        }
        finally {
            this.undeploy(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnnotatedMethodOneParameterNoAnnotations() throws Throwable {
        AbstractBeanMetaData bmd = new AbstractBeanMetaData("Bean", AnnotatedMethodBean.class.getName());
        AbstractInstallMetaData imd = new AbstractInstallMetaData();
        imd.setMethodName(METHOD_NAME);
        AbstractParameterMetaData pmd = new AbstractParameterMetaData("int", (Object)1);
        ArrayList<AbstractParameterMetaData> params = new ArrayList<AbstractParameterMetaData>();
        params.add(pmd);
        imd.setParameters(params);
        this.addInstallMetaData(bmd, imd);
        KernelControllerContext context = null;
        try {
            context = this.deploy((BeanMetaData)bmd);
            AnnotatedMethodBean bean = (AnnotatedMethodBean)this.assertBean("Bean", AnnotatedMethodBean.class);
            Method method = AnnotatedMethodBean.class.getMethod(METHOD_NAME, Integer.TYPE);
            AnnotatedMethodTestCase.assertEquals((long)1L, (long)bean.i);
            AnnotatedMethodTestCase.assertEquals((long)0L, (long)bean.j);
            this.assertMethodAnnotations(context, method, new Class[0]);
            this.assertMethodParameterAnnotations(context, method, 0, new Class[0]);
        }
        finally {
            this.undeploy(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnnotatedMethodOneParameterAnnotationsOnMethod() throws Throwable {
        AbstractBeanMetaData bmd = new AbstractBeanMetaData("Bean", AnnotatedMethodBean.class.getName());
        AbstractInstallMetaData imd = new AbstractInstallMetaData();
        imd.setMethodName(METHOD_NAME);
        imd.setAnnotations(this.createAnnotationMetaDataSet(MethodA.class));
        AbstractParameterMetaData pmd = new AbstractParameterMetaData("int", (Object)1);
        ArrayList<AbstractParameterMetaData> params = new ArrayList<AbstractParameterMetaData>();
        params.add(pmd);
        imd.setParameters(params);
        this.addInstallMetaData(bmd, imd);
        KernelControllerContext context = null;
        try {
            context = this.deploy((BeanMetaData)bmd);
            AnnotatedMethodBean bean = (AnnotatedMethodBean)this.assertBean("Bean", AnnotatedMethodBean.class);
            Method method = AnnotatedMethodBean.class.getMethod(METHOD_NAME, Integer.TYPE);
            AnnotatedMethodTestCase.assertEquals((long)1L, (long)bean.i);
            AnnotatedMethodTestCase.assertEquals((long)0L, (long)bean.j);
            this.assertMethodAnnotations(context, method, MethodA.class);
            this.assertMethodParameterAnnotations(context, method, 0, new Class[0]);
        }
        finally {
            this.undeploy(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnnotatedMethodOneParameterAnnotationsOnConstructorAndParameter() throws Throwable {
        AbstractBeanMetaData bmd = new AbstractBeanMetaData("Bean", AnnotatedMethodBean.class.getName());
        AbstractInstallMetaData imd = new AbstractInstallMetaData();
        imd.setMethodName(METHOD_NAME);
        imd.setAnnotations(this.createAnnotationMetaDataSet(MethodA.class));
        AbstractParameterMetaData pmd = new AbstractParameterMetaData("int", (Object)1);
        pmd.setAnnotations(this.createAnnotationMetaDataSet(MethodB.class));
        ArrayList<AbstractParameterMetaData> params = new ArrayList<AbstractParameterMetaData>();
        params.add(pmd);
        imd.setParameters(params);
        this.addInstallMetaData(bmd, imd);
        KernelControllerContext context = null;
        try {
            context = this.deploy((BeanMetaData)bmd);
            AnnotatedMethodBean bean = (AnnotatedMethodBean)this.assertBean("Bean", AnnotatedMethodBean.class);
            Method method = AnnotatedMethodBean.class.getMethod(METHOD_NAME, Integer.TYPE);
            AnnotatedMethodTestCase.assertEquals((long)1L, (long)bean.i);
            AnnotatedMethodTestCase.assertEquals((long)0L, (long)bean.j);
            this.assertMethodAnnotations(context, method, MethodA.class);
            this.assertMethodParameterAnnotations(context, method, 0, MethodB.class);
        }
        finally {
            this.undeploy(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnnotatedMethodOneParameterAnnotationsOnParameter() throws Throwable {
        AbstractBeanMetaData bmd = new AbstractBeanMetaData("Bean", AnnotatedMethodBean.class.getName());
        AbstractInstallMetaData imd = new AbstractInstallMetaData();
        imd.setMethodName(METHOD_NAME);
        AbstractParameterMetaData pmd = new AbstractParameterMetaData("int", (Object)1);
        pmd.setAnnotations(this.createAnnotationMetaDataSet(MethodA.class));
        ArrayList<AbstractParameterMetaData> params = new ArrayList<AbstractParameterMetaData>();
        params.add(pmd);
        imd.setParameters(params);
        this.addInstallMetaData(bmd, imd);
        KernelControllerContext context = null;
        try {
            context = this.deploy((BeanMetaData)bmd);
            AnnotatedMethodBean bean = (AnnotatedMethodBean)this.assertBean("Bean", AnnotatedMethodBean.class);
            Method method = AnnotatedMethodBean.class.getMethod(METHOD_NAME, Integer.TYPE);
            AnnotatedMethodTestCase.assertEquals((long)1L, (long)bean.i);
            AnnotatedMethodTestCase.assertEquals((long)0L, (long)bean.j);
            this.assertMethodAnnotations(context, method, new Class[0]);
            this.assertMethodParameterAnnotations(context, method, 0, MethodA.class);
        }
        finally {
            this.undeploy(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnnotatedMethodTwoConstructorAnnotations() throws Throwable {
        AbstractBeanMetaData bmd = new AbstractBeanMetaData("Bean", AnnotatedMethodBean.class.getName());
        AbstractInstallMetaData imd = new AbstractInstallMetaData();
        imd.setMethodName(METHOD_NAME);
        imd.setAnnotations(this.createAnnotationMetaDataSet(MethodA.class));
        AbstractParameterMetaData pmd0 = new AbstractParameterMetaData("long", (Object)1);
        AbstractParameterMetaData pmd1 = new AbstractParameterMetaData("long", (Object)2);
        ArrayList<AbstractParameterMetaData> params = new ArrayList<AbstractParameterMetaData>();
        params.add(pmd0);
        params.add(pmd1);
        imd.setParameters(params);
        this.addInstallMetaData(bmd, imd);
        KernelControllerContext context = null;
        try {
            context = this.deploy((BeanMetaData)bmd);
            AnnotatedMethodBean bean = (AnnotatedMethodBean)this.assertBean("Bean", AnnotatedMethodBean.class);
            Method method = AnnotatedMethodBean.class.getMethod(METHOD_NAME, Long.TYPE, Long.TYPE);
            AnnotatedMethodTestCase.assertEquals((long)1L, (long)bean.i);
            AnnotatedMethodTestCase.assertEquals((long)2L, (long)bean.j);
            this.assertMethodAnnotations(context, method, MethodA.class);
            this.assertMethodParameterAnnotations(context, method, 0, new Class[0]);
            this.assertMethodParameterAnnotations(context, method, 1, new Class[0]);
        }
        finally {
            this.undeploy(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnnotatedMethodTwoMethodAndParameterOneAnnotations() throws Throwable {
        AbstractBeanMetaData bmd = new AbstractBeanMetaData("Bean", AnnotatedMethodBean.class.getName());
        AbstractInstallMetaData imd = new AbstractInstallMetaData();
        imd.setMethodName(METHOD_NAME);
        imd.setAnnotations(this.createAnnotationMetaDataSet(MethodA.class));
        AbstractParameterMetaData pmd0 = new AbstractParameterMetaData("long", (Object)1);
        pmd0.setAnnotations(this.createAnnotationMetaDataSet(MethodB.class));
        AbstractParameterMetaData pmd1 = new AbstractParameterMetaData("long", (Object)2);
        ArrayList<AbstractParameterMetaData> params = new ArrayList<AbstractParameterMetaData>();
        params.add(pmd0);
        params.add(pmd1);
        imd.setParameters(params);
        this.addInstallMetaData(bmd, imd);
        KernelControllerContext context = null;
        try {
            context = this.deploy((BeanMetaData)bmd);
            AnnotatedMethodBean bean = (AnnotatedMethodBean)this.assertBean("Bean", AnnotatedMethodBean.class);
            Method method = AnnotatedMethodBean.class.getMethod(METHOD_NAME, Long.TYPE, Long.TYPE);
            AnnotatedMethodTestCase.assertEquals((long)1L, (long)bean.i);
            AnnotatedMethodTestCase.assertEquals((long)2L, (long)bean.j);
            this.assertMethodAnnotations(context, method, MethodA.class);
            this.assertMethodParameterAnnotations(context, method, 0, MethodB.class);
            this.assertMethodParameterAnnotations(context, method, 1, new Class[0]);
        }
        finally {
            this.undeploy(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnnotatedMethodTwoMethodAndParameterTwoAnnotations() throws Throwable {
        AbstractBeanMetaData bmd = new AbstractBeanMetaData("Bean", AnnotatedMethodBean.class.getName());
        AbstractInstallMetaData imd = new AbstractInstallMetaData();
        imd.setMethodName(METHOD_NAME);
        imd.setAnnotations(this.createAnnotationMetaDataSet(MethodA.class));
        AbstractParameterMetaData pmd0 = new AbstractParameterMetaData("long", (Object)1);
        AbstractParameterMetaData pmd1 = new AbstractParameterMetaData("long", (Object)2);
        pmd1.setAnnotations(this.createAnnotationMetaDataSet(MethodB.class));
        ArrayList<AbstractParameterMetaData> params = new ArrayList<AbstractParameterMetaData>();
        params.add(pmd0);
        params.add(pmd1);
        imd.setParameters(params);
        this.addInstallMetaData(bmd, imd);
        KernelControllerContext context = null;
        try {
            context = this.deploy((BeanMetaData)bmd);
            AnnotatedMethodBean bean = (AnnotatedMethodBean)this.assertBean("Bean", AnnotatedMethodBean.class);
            Method method = AnnotatedMethodBean.class.getMethod(METHOD_NAME, Long.TYPE, Long.TYPE);
            AnnotatedMethodTestCase.assertEquals((long)1L, (long)bean.i);
            AnnotatedMethodTestCase.assertEquals((long)2L, (long)bean.j);
            this.assertMethodAnnotations(context, method, MethodA.class);
            this.assertMethodParameterAnnotations(context, method, 0, new Class[0]);
            this.assertMethodParameterAnnotations(context, method, 1, MethodB.class);
        }
        finally {
            this.undeploy(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnnotatedMethodTwoMethodAndParameterOneTwoAnnotations() throws Throwable {
        AbstractBeanMetaData bmd = new AbstractBeanMetaData("Bean", AnnotatedMethodBean.class.getName());
        AbstractInstallMetaData imd = new AbstractInstallMetaData();
        imd.setMethodName(METHOD_NAME);
        imd.setAnnotations(this.createAnnotationMetaDataSet(MethodA.class));
        AbstractParameterMetaData pmd0 = new AbstractParameterMetaData("long", (Object)1);
        pmd0.setAnnotations(this.createAnnotationMetaDataSet(MethodA.class, MethodB.class));
        AbstractParameterMetaData pmd1 = new AbstractParameterMetaData("long", (Object)2);
        pmd1.setAnnotations(this.createAnnotationMetaDataSet(MethodB.class));
        ArrayList<AbstractParameterMetaData> params = new ArrayList<AbstractParameterMetaData>();
        params.add(pmd0);
        params.add(pmd1);
        imd.setParameters(params);
        this.addInstallMetaData(bmd, imd);
        KernelControllerContext context = null;
        try {
            context = this.deploy((BeanMetaData)bmd);
            AnnotatedMethodBean bean = (AnnotatedMethodBean)this.assertBean("Bean", AnnotatedMethodBean.class);
            Method method = AnnotatedMethodBean.class.getMethod(METHOD_NAME, Long.TYPE, Long.TYPE);
            AnnotatedMethodTestCase.assertEquals((long)1L, (long)bean.i);
            AnnotatedMethodTestCase.assertEquals((long)2L, (long)bean.j);
            this.assertMethodAnnotations(context, method, MethodA.class);
            this.assertMethodParameterAnnotations(context, method, 0, MethodA.class, MethodB.class);
            this.assertMethodParameterAnnotations(context, method, 1, MethodB.class);
        }
        finally {
            this.undeploy(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOverloadedInstallMethods() throws Throwable {
        AbstractBeanMetaData bmd = new AbstractBeanMetaData("Bean", AnnotatedMethodBean.class.getName());
        AbstractInstallMetaData imd = new AbstractInstallMetaData();
        imd.setMethodName(METHOD_NAME);
        imd.setAnnotations(this.createAnnotationMetaDataSet(MethodA.class));
        AbstractParameterMetaData pmd0 = new AbstractParameterMetaData("long", (Object)1);
        pmd0.setAnnotations(this.createAnnotationMetaDataSet(MethodA.class, MethodB.class));
        AbstractParameterMetaData pmd1 = new AbstractParameterMetaData("long", (Object)2);
        pmd1.setAnnotations(this.createAnnotationMetaDataSet(MethodB.class));
        ArrayList<AbstractParameterMetaData> params = new ArrayList<AbstractParameterMetaData>();
        params.add(pmd0);
        params.add(pmd1);
        imd.setParameters(params);
        ArrayList<AbstractInstallMetaData> installs = new ArrayList<AbstractInstallMetaData>();
        installs.add(imd);
        imd = new AbstractInstallMetaData();
        imd.setMethodName(METHOD_NAME);
        imd.setAnnotations(this.createAnnotationMetaDataSet(MethodB.class));
        pmd0 = new AbstractParameterMetaData("int", (Object)2);
        pmd0.setAnnotations(this.createAnnotationMetaDataSet(MethodA.class));
        params = new ArrayList();
        params.add(pmd0);
        imd.setParameters(params);
        installs.add(imd);
        bmd.setInstalls(installs);
        KernelControllerContext context = null;
        try {
            context = this.deploy((BeanMetaData)bmd);
            AnnotatedMethodBean bean = (AnnotatedMethodBean)this.assertBean("Bean", AnnotatedMethodBean.class);
            AnnotatedMethodTestCase.assertEquals((long)3L, (long)bean.i);
            AnnotatedMethodTestCase.assertEquals((long)2L, (long)bean.j);
            Method method = AnnotatedMethodBean.class.getMethod(METHOD_NAME, Long.TYPE, Long.TYPE);
            this.assertMethodAnnotations(context, method, MethodA.class);
            this.assertMethodParameterAnnotations(context, method, 0, MethodA.class, MethodB.class);
            this.assertMethodParameterAnnotations(context, method, 1, MethodB.class);
            method = AnnotatedMethodBean.class.getMethod(METHOD_NAME, Integer.TYPE);
            this.assertMethodAnnotations(context, method, MethodB.class);
            this.assertMethodParameterAnnotations(context, method, 0, MethodA.class);
        }
        finally {
            this.undeploy(context);
        }
    }

    private void assertMethodAnnotations(KernelControllerContext context, Method method, Class<? extends Annotation> ... expectedAnnotations) {
        Annotation[] annotations = this.getComponentMetaData(context, (Signature)new DeclaredMethodSignature(method));
        this.assertAnnnotations(annotations, expectedAnnotations);
    }

    private void assertMethodParameterAnnotations(KernelControllerContext context, Method method, int parameterIndex, Class<? extends Annotation> ... expectedAnnotations) {
        Annotation[] annotations = this.getComponentMetaData(context, (Signature)new MethodParametersSignature(method, parameterIndex));
        this.assertAnnnotations(annotations, expectedAnnotations);
    }

    private void assertAnnnotations(Annotation[] annotations, Class<? extends Annotation>[] expectedAnnotations) {
        AnnotatedMethodTestCase.assertEquals((int)expectedAnnotations.length, (int)annotations.length);
        for (Class<? extends Annotation> expectedAnnotation : expectedAnnotations) {
            boolean found = false;
            for (Annotation annotation : annotations) {
                if (annotation.annotationType() != expectedAnnotation) continue;
                found = true;
                break;
            }
            AnnotatedMethodTestCase.assertTrue((String)("Did not find annotation " + expectedAnnotation), (boolean)found);
        }
    }

    private Annotation[] getComponentMetaData(KernelControllerContext context, Signature signature) {
        KernelMetaDataRepository repository = context.getKernel().getMetaDataRepository();
        MetaData metaData = repository.getMetaData((ControllerContext)context);
        MetaData component = metaData.getComponentMetaData(signature);
        return component.getAnnotations();
    }

    private Set<AnnotationMetaData> createAnnotationMetaDataSet(Class<? extends Annotation> ... classes) {
        if (classes == null || classes.length == 0) {
            return null;
        }
        HashSet<AnnotationMetaData> annotations = new HashSet<AnnotationMetaData>();
        for (Class<? extends Annotation> clazz : classes) {
            annotations.add((AnnotationMetaData)new AbstractAnnotationMetaData("@" + clazz.getName()));
        }
        return annotations;
    }

    private void addInstallMetaData(AbstractBeanMetaData bmd, AbstractInstallMetaData imd) {
        ArrayList<AbstractInstallMetaData> installs = new ArrayList<AbstractInstallMetaData>();
        installs.add(imd);
        bmd.setInstalls(installs);
    }
}

