/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.asynchronous.test;

import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jboss.test.AbstractTestDelegate;
import org.jboss.test.kernel.asynchronous.support.Helper;
import org.jboss.test.kernel.asynchronous.support.Point;
import org.jboss.test.kernel.asynchronous.test.AsynchronousTestDelegate;
import org.jboss.test.kernel.junit.MicrocontainerTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsynchronousTest
extends MicrocontainerTest {
    static Executor executor;

    public AsynchronousTest(String name, int threads) {
        super(name);
        executor = Executors.newFixedThreadPool(threads);
    }

    public AsynchronousTest(String name, Executor executor) {
        super(name);
        AsynchronousTest.executor = executor;
    }

    public static AbstractTestDelegate getDelegate(Class<?> clazz) throws Exception {
        return new AsynchronousTestDelegate(clazz, executor);
    }

    protected Point assertGetPoint(int index) {
        List<Point> points = Helper.getPoints();
        AsynchronousTest.assertTrue((index < points.size() ? 1 : 0) != 0);
        Point point = points.get(index);
        AsynchronousTest.assertNotNull((Object)point);
        return point;
    }

    protected Point checkPoint(int index, String name, Boolean mainThread) {
        Point point = this.assertGetPoint(index);
        AsynchronousTest.assertEquals((String)name, (String)point.getName());
        String mainThreadName = Thread.currentThread().getName();
        if (mainThread != null) {
            if (mainThread.booleanValue()) {
                AsynchronousTest.assertEquals((String)mainThreadName, (String)point.getThreadName());
            } else {
                AsynchronousTest.assertFalse((boolean)mainThreadName.equals(point.getThreadName()));
            }
        }
        return point;
    }

    protected AsynchronousTestDelegate getAsynchronousDelegate() {
        return (AsynchronousTestDelegate)this.getDelegate();
    }
}

