/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.asynchronous.test;

import java.util.concurrent.Executor;
import org.jboss.dependency.plugins.AbstractController;
import org.jboss.kernel.plugins.deployment.xml.BasicXMLDeployer;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.test.kernel.junit.MicrocontainerTestDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsynchronousTestDelegate
extends MicrocontainerTestDelegate {
    Executor executor;

    public AsynchronousTestDelegate(Class<?> clazz, Executor executor) throws Exception {
        super(clazz);
        this.executor = executor;
    }

    protected void setExecutor(Executor executor) {
        KernelController controller = this.kernel.getController();
        if (!(controller instanceof AbstractController)) {
            throw new IllegalStateException("Controller is not instance of AbstractController");
        }
        ((AbstractController)controller).setExecutor(executor);
    }

    protected void deploy() throws Exception {
        this.setExecutor(this.executor);
        super.deploy();
    }

    protected void deployTestXml() throws Exception {
        this.deploy(this.getTestResource(this.getTestResourceName()));
    }

    protected void undeployTestXml() {
        this.undeploy(this.getTestResource(this.getTestResourceName()));
    }

    private String getTestResourceName() {
        String testName = this.clazz.getName();
        return testName.replace('.', '/') + "NotAutomatic.xml";
    }

    protected BasicXMLDeployer createDeployer() {
        return new BasicXMLDeployer(this.kernel, null);
    }
}

