/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.controller.test;

import junit.framework.Test;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.registry.KernelRegistryEntry;
import org.jboss.test.kernel.controller.test.AbstractControllerTest;

public class StateAfterInstalledTestCase
extends AbstractControllerTest {
    public static Test suite() {
        return StateAfterInstalledTestCase.suite(StateAfterInstalledTestCase.class);
    }

    public StateAfterInstalledTestCase(String name) throws Throwable {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStateAfterInstall() throws Throwable {
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)"Test", (String)Object.class.getName());
        ControllerState lastState = ControllerState.newState((String)"Last State");
        KernelControllerContext context = this.deploy(builder.getBeanMetaData());
        KernelController controller = null;
        try {
            this.assertBean("Test", ControllerState.INSTALLED, Object.class);
            controller = (KernelController)context.getController();
            controller.addState(lastState, null);
            StateAfterInstalledTestCase.assertTrue((boolean)controller.getStates().isAfterState(lastState, ControllerState.INSTALLED));
            StateAfterInstalledTestCase.assertEquals((Object)context, (Object)controller.getInstalledContext((Object)"Test"));
            StateAfterInstalledTestCase.assertTrue((boolean)controller.getContextsByState(ControllerState.INSTALLED).contains(context));
            StateAfterInstalledTestCase.assertEquals((Object)context, (Object)controller.getContext((Object)"Test", ControllerState.INSTALLED));
            StateAfterInstalledTestCase.assertEquals((Object)context, (Object)controller.getContext((Object)"Test", ControllerState.START));
            StateAfterInstalledTestCase.assertEquals((Object)context, (Object)controller.getContext((Object)"Test", ControllerState.CREATE));
            StateAfterInstalledTestCase.assertEquals((Object)context, (Object)controller.getContext((Object)"Test", ControllerState.CONFIGURED));
            StateAfterInstalledTestCase.assertEquals((Object)context, (Object)controller.getContext((Object)"Test", ControllerState.INSTANTIATED));
            StateAfterInstalledTestCase.assertEquals((Object)context, (Object)controller.getContext((Object)"Test", ControllerState.NOT_INSTALLED));
            StateAfterInstalledTestCase.assertEquals((Object)context, (Object)controller.getContext((Object)"Test", ControllerState.CREATE));
            this.assertEmpty(controller.getNotInstalled());
            controller.change((ControllerContext)context, lastState);
            StateAfterInstalledTestCase.assertEquals((Object)context, (Object)controller.getInstalledContext((Object)"Test"));
            StateAfterInstalledTestCase.assertEquals((Object)context, (Object)controller.getContext((Object)"Test", lastState));
            StateAfterInstalledTestCase.assertEquals((Object)context, (Object)controller.getContext((Object)"Test", ControllerState.INSTALLED));
            StateAfterInstalledTestCase.assertEquals((Object)context, (Object)controller.getContext((Object)"Test", ControllerState.START));
            StateAfterInstalledTestCase.assertEquals((Object)context, (Object)controller.getContext((Object)"Test", ControllerState.CREATE));
            StateAfterInstalledTestCase.assertEquals((Object)context, (Object)controller.getContext((Object)"Test", ControllerState.CONFIGURED));
            StateAfterInstalledTestCase.assertEquals((Object)context, (Object)controller.getContext((Object)"Test", ControllerState.INSTANTIATED));
            StateAfterInstalledTestCase.assertEquals((Object)context, (Object)controller.getContext((Object)"Test", ControllerState.NOT_INSTALLED));
            StateAfterInstalledTestCase.assertEquals((Object)context, (Object)controller.getContext((Object)"Test", ControllerState.CREATE));
            StateAfterInstalledTestCase.assertFalse((boolean)controller.getContextsByState(ControllerState.INSTALLED).contains(context));
            StateAfterInstalledTestCase.assertTrue((boolean)controller.getContextsByState(lastState).contains(context));
            this.assertEmpty(controller.getNotInstalled());
        }
        finally {
            context.getController().uninstall((Object)"Test");
        }
        controller.getKernel().getRegistry().registerEntry((Object)"Test2", (KernelRegistryEntry)context);
        try {
            StateAfterInstalledTestCase.assertEquals((Object)context, (Object)controller.getInstalledContext((Object)"Test2"));
            StateAfterInstalledTestCase.assertEquals((Object)context, (Object)controller.getContext((Object)"Test2", lastState));
            StateAfterInstalledTestCase.assertEquals((Object)context, (Object)controller.getContext((Object)"Test2", ControllerState.INSTALLED));
            StateAfterInstalledTestCase.assertNull((Object)controller.getContext((Object)"Test2", ControllerState.START));
            StateAfterInstalledTestCase.assertNull((Object)controller.getContext((Object)"Test2", ControllerState.CREATE));
            StateAfterInstalledTestCase.assertNull((Object)controller.getContext((Object)"Test2", ControllerState.CONFIGURED));
            StateAfterInstalledTestCase.assertNull((Object)controller.getContext((Object)"Test2", ControllerState.INSTANTIATED));
            StateAfterInstalledTestCase.assertNull((Object)controller.getContext((Object)"Test2", ControllerState.NOT_INSTALLED));
            StateAfterInstalledTestCase.assertNull((Object)controller.getContext((Object)"Test2", ControllerState.CREATE));
            StateAfterInstalledTestCase.assertFalse((boolean)controller.getContextsByState(ControllerState.INSTALLED).contains(context));
            StateAfterInstalledTestCase.assertFalse((boolean)controller.getContextsByState(lastState).contains(context));
        }
        finally {
            controller.getKernel().getRegistry().unregisterEntry((Object)"Test2");
        }
    }
}

