/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.dependency.test;

import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractDependencyValueMetaData;
import org.jboss.beans.metadata.plugins.AbstractPropertyMetaData;
import org.jboss.beans.metadata.plugins.factory.GenericBeanFactory;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.factory.GenericBeanFactoryMetaData;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.test.kernel.dependency.support.SimpleBean;
import org.jboss.test.kernel.dependency.support.SimpleBeanImpl;
import org.jboss.test.kernel.dependency.support.SimpleBeanWithDependency;
import org.jboss.test.kernel.dependency.support.SimpleBeanWithDependencyImpl;
import org.jboss.test.kernel.dependency.test.OldAbstractKernelDependencyTest;

public class GenericBeanFactoryOnDemandDependencyTestCase
extends OldAbstractKernelDependencyTest {
    public static Test suite() {
        return GenericBeanFactoryOnDemandDependencyTestCase.suite(GenericBeanFactoryOnDemandDependencyTestCase.class);
    }

    public GenericBeanFactoryOnDemandDependencyTestCase(String name) throws Throwable {
        super(name);
    }

    public GenericBeanFactoryOnDemandDependencyTestCase(String name, boolean xmltest) throws Throwable {
        super(name, xmltest);
    }

    public void testGenericBeanFactoryOnDemandDependencyOnDemandFirst() throws Throwable {
        this.onDemandDependencyOnDemandFirst();
        ControllerContext context1 = this.assertInstall(0, "Name1", ControllerState.DESCRIBED);
        ControllerContext context2 = this.assertInstall(1, "Name2");
        this.assertContext("Name1");
        GenericBeanFactory factory1 = (GenericBeanFactory)context1.getTarget();
        SimpleBean bean1 = (SimpleBean)factory1.createBean();
        GenericBeanFactoryOnDemandDependencyTestCase.assertNotNull((Object)bean1);
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        GenericBeanFactory factory2 = (GenericBeanFactory)context2.getTarget();
        SimpleBeanWithDependency bean2 = (SimpleBeanWithDependency)factory2.createBean();
        GenericBeanFactoryOnDemandDependencyTestCase.assertNotNull((Object)bean2);
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((String)"String2", (String)bean2.getString());
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((Object)factory1, (Object)bean2.getFactory());
    }

    public void onDemandDependencyOnDemandFirst() throws Throwable {
        this.buildMetaData();
    }

    public void testGenericBeanFactoryOnDemandDependencyOnDemandSecond() throws Throwable {
        this.onDemandDependencyOnDemandSecond();
        ControllerContext context2 = this.assertInstall(1, "Name2", ControllerState.INSTANTIATED);
        ControllerContext context1 = this.assertInstall(0, "Name1");
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)context2.getState());
        GenericBeanFactory factory1 = (GenericBeanFactory)context1.getTarget();
        SimpleBean bean1 = (SimpleBean)factory1.createBean();
        GenericBeanFactoryOnDemandDependencyTestCase.assertNotNull((Object)bean1);
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        GenericBeanFactory factory2 = (GenericBeanFactory)context2.getTarget();
        SimpleBeanWithDependency bean2 = (SimpleBeanWithDependency)factory2.createBean();
        GenericBeanFactoryOnDemandDependencyTestCase.assertNotNull((Object)bean2);
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((String)"String2", (String)bean2.getString());
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((Object)factory1, (Object)bean2.getFactory());
    }

    public void onDemandDependencyOnDemandSecond() throws Throwable {
        this.buildMetaData();
    }

    public void testGenericBeanFactoryOnDemandDependencyReinstall() throws Throwable {
        this.onDemandDependencyReinstall();
        ControllerContext context1 = this.assertInstall(0, "Name1", ControllerState.DESCRIBED);
        ControllerContext context2 = this.assertInstall(1, "Name2");
        ControllerContext context3 = this.assertInstall(2, "Name3");
        this.assertContext("Name1");
        GenericBeanFactory factory1 = (GenericBeanFactory)context1.getTarget();
        SimpleBean bean1 = (SimpleBean)factory1.createBean();
        GenericBeanFactoryOnDemandDependencyTestCase.assertNotNull((Object)bean1);
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        GenericBeanFactory factory2 = (GenericBeanFactory)context2.getTarget();
        SimpleBeanWithDependency bean2 = (SimpleBeanWithDependency)factory2.createBean();
        GenericBeanFactoryOnDemandDependencyTestCase.assertNotNull((Object)bean2);
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((String)"String2", (String)bean2.getString());
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((Object)factory1, (Object)bean2.getFactory());
        GenericBeanFactory factory3 = (GenericBeanFactory)context3.getTarget();
        SimpleBeanWithDependency bean3 = (SimpleBeanWithDependency)factory3.createBean();
        GenericBeanFactoryOnDemandDependencyTestCase.assertNotNull((Object)bean3);
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((String)"String3", (String)bean3.getString());
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((Object)factory1, (Object)bean3.getFactory());
        this.assertUninstall("Name1");
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((Object)ControllerState.ERROR, (Object)context1.getState());
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((Object)ControllerState.INSTANTIATED, (Object)context2.getState());
        this.assertNotInstalled("Name2");
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((Object)ControllerState.INSTANTIATED, (Object)context3.getState());
        this.assertNotInstalled("Name3");
        context2 = this.assertContext("Name2", ControllerState.INSTANTIATED);
        context3 = this.assertContext("Name3", ControllerState.INSTANTIATED);
        context1 = this.assertInstall(0, "Name1");
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)context2.getState());
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)context3.getState());
        factory1 = (GenericBeanFactory)context1.getTarget();
        bean1 = (SimpleBean)factory1.createBean();
        GenericBeanFactoryOnDemandDependencyTestCase.assertNotNull((Object)bean1);
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        factory2 = (GenericBeanFactory)context2.getTarget();
        bean2 = (SimpleBeanWithDependency)factory2.createBean();
        GenericBeanFactoryOnDemandDependencyTestCase.assertNotNull((Object)bean2);
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((String)"String2", (String)bean2.getString());
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((Object)factory1, (Object)bean2.getFactory());
        factory3 = (GenericBeanFactory)context3.getTarget();
        bean3 = (SimpleBeanWithDependency)factory3.createBean();
        GenericBeanFactoryOnDemandDependencyTestCase.assertNotNull((Object)bean3);
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((String)"String3", (String)bean3.getString());
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((Object)factory1, (Object)bean3.getFactory());
        this.assertUninstall("Name2");
        context1 = this.assertContext("Name1");
        factory1 = (GenericBeanFactory)context1.getTarget();
        bean1 = (SimpleBean)factory1.createBean();
        GenericBeanFactoryOnDemandDependencyTestCase.assertNotNull((Object)bean1);
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        context3 = this.assertContext("Name3");
        factory3 = (GenericBeanFactory)context3.getTarget();
        bean3 = (SimpleBeanWithDependency)factory3.createBean();
        GenericBeanFactoryOnDemandDependencyTestCase.assertNotNull((Object)bean3);
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((String)"String3", (String)bean3.getString());
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((Object)factory1, (Object)bean3.getFactory());
        context2 = this.assertInstall(1, "Name2");
        factory1 = (GenericBeanFactory)context1.getTarget();
        bean1 = (SimpleBean)factory1.createBean();
        GenericBeanFactoryOnDemandDependencyTestCase.assertNotNull((Object)bean1);
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        factory2 = (GenericBeanFactory)context2.getTarget();
        bean2 = (SimpleBeanWithDependency)factory2.createBean();
        GenericBeanFactoryOnDemandDependencyTestCase.assertNotNull((Object)bean2);
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((String)"String2", (String)bean2.getString());
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((Object)factory1, (Object)bean2.getFactory());
        factory3 = (GenericBeanFactory)context3.getTarget();
        bean3 = (SimpleBeanWithDependency)factory3.createBean();
        GenericBeanFactoryOnDemandDependencyTestCase.assertNotNull((Object)bean3);
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((String)"String3", (String)bean3.getString());
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((Object)factory1, (Object)bean3.getFactory());
        this.assertUninstall("Name2");
        factory1 = (GenericBeanFactory)context1.getTarget();
        bean1 = (SimpleBean)factory1.createBean();
        GenericBeanFactoryOnDemandDependencyTestCase.assertNotNull((Object)bean1);
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        context3 = this.assertContext("Name3");
        bean3 = (SimpleBeanWithDependency)factory3.createBean();
        GenericBeanFactoryOnDemandDependencyTestCase.assertNotNull((Object)bean3);
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((String)"String3", (String)bean3.getString());
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((Object)factory1, (Object)bean3.getFactory());
        this.assertUninstall("Name3");
        context1 = this.assertContext("Name1", ControllerState.DESCRIBED);
        GenericBeanFactoryOnDemandDependencyTestCase.assertNull((Object)context1.getTarget());
        context2 = this.assertInstall(1, "Name2");
        factory1 = (GenericBeanFactory)context1.getTarget();
        bean1 = (SimpleBean)factory1.createBean();
        GenericBeanFactoryOnDemandDependencyTestCase.assertNotNull((Object)bean1);
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        factory2 = (GenericBeanFactory)context2.getTarget();
        bean2 = (SimpleBeanWithDependency)factory2.createBean();
        GenericBeanFactoryOnDemandDependencyTestCase.assertNotNull((Object)bean2);
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((String)"String2", (String)bean2.getString());
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((Object)factory1, (Object)bean2.getFactory());
        context3 = this.assertInstall(2, "Name3");
        factory3 = (GenericBeanFactory)context3.getTarget();
        bean3 = (SimpleBeanWithDependency)factory3.createBean();
        GenericBeanFactoryOnDemandDependencyTestCase.assertNotNull((Object)bean3);
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((String)"String3", (String)bean3.getString());
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((Object)factory1, (Object)bean3.getFactory());
    }

    public void onDemandDependencyReinstall() throws Throwable {
        this.buildMetaData();
    }

    protected void buildMetaData() {
        GenericBeanFactoryMetaData metaData1 = new GenericBeanFactoryMetaData("Name1", SimpleBeanImpl.class.getName());
        metaData1.setMode(ControllerMode.ON_DEMAND);
        this.addBeanProperty(metaData1, (PropertyMetaData)new AbstractPropertyMetaData("string", "String1"));
        GenericBeanFactoryMetaData metaData2 = new GenericBeanFactoryMetaData("Name2", SimpleBeanWithDependencyImpl.class.getName());
        this.addBeanProperty(metaData2, (PropertyMetaData)new AbstractPropertyMetaData("string", "String2"));
        this.addBeanProperty(metaData2, (PropertyMetaData)new AbstractPropertyMetaData("factory", (ValueMetaData)new AbstractDependencyValueMetaData((Object)"Name1")));
        GenericBeanFactoryMetaData metaData3 = new GenericBeanFactoryMetaData("Name3", SimpleBeanWithDependencyImpl.class.getName());
        this.addBeanProperty(metaData3, (PropertyMetaData)new AbstractPropertyMetaData("string", "String3"));
        this.addBeanProperty(metaData3, (PropertyMetaData)new AbstractPropertyMetaData("factory", (ValueMetaData)new AbstractDependencyValueMetaData((Object)"Name1")));
        this.setBeanMetaDatas(new BeanMetaData[]{this.getBeanMetaData(metaData1), this.getBeanMetaData(metaData2), this.getBeanMetaData(metaData3)});
    }
}

