/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.deployment.test;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Test;
import org.jboss.test.kernel.deployment.support.BeanWithCollectionProperties;
import org.jboss.test.kernel.junit.MicrocontainerTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreinstantiatedCollectionTestCase
extends MicrocontainerTest {
    public PreinstantiatedCollectionTestCase(String name) throws Throwable {
        super(name, true);
    }

    public static Test suite() {
        return PreinstantiatedCollectionTestCase.suite(PreinstantiatedCollectionTestCase.class);
    }

    public void testGetInstance() throws Throwable {
        BeanWithCollectionProperties bean = (BeanWithCollectionProperties)this.assertBean("Bean", BeanWithCollectionProperties.class);
        Collection<String> collection = bean.getCollection();
        this.assertDefaultCollection(collection);
        Collection<String> preinstantiatedCollection = bean.getPreinstantiatedCollection();
        this.assertPreinstantiateCollection(preinstantiatedCollection);
        List<String> list = bean.getList();
        this.assertDefaultCollection(list);
        List<String> preinstantiatedList = bean.getPreinstantiatedList();
        this.assertPreinstantiateCollection(preinstantiatedList);
        Set<String> set = bean.getSet();
        this.assertDefaultCollection(set);
        Set<String> preinstantiatedSet = bean.getPreinstantiatedSet();
        this.assertPreinstantiateCollection(preinstantiatedSet);
        String[] array = bean.getArray();
        PreinstantiatedCollectionTestCase.assertNotNull((Object)array);
        this.assertDefaultCollection(Arrays.asList(array));
        String[] preinstantiatedArray = bean.getPreinstantiatedArray();
        PreinstantiatedCollectionTestCase.assertNotNull((Object)preinstantiatedArray);
        this.assertPreinstantiateCollection(Arrays.asList(preinstantiatedArray));
        Map<String, String> map = bean.getMap();
        this.assertDefaultMap(map);
        Map<String, String> preInstantiatedMap = bean.getPreinstantiatedMap();
        this.assertPreinstantiateMap(preInstantiatedMap);
    }

    private void assertDefaultCollection(Collection<String> collection) {
        this.assertCollection(collection, "Pre", "One", "Two");
    }

    private void assertPreinstantiateCollection(Collection<String> collection) {
        this.assertCollection(collection, "One", "Two");
    }

    private void assertCollection(Collection<String> collection, String ... values) {
        PreinstantiatedCollectionTestCase.assertNotNull(collection);
        PreinstantiatedCollectionTestCase.assertEquals((int)values.length, (int)collection.size());
        for (String s : values) {
            PreinstantiatedCollectionTestCase.assertTrue((boolean)collection.contains(s));
        }
    }

    private void assertDefaultMap(Map<String, String> map) {
        this.assertMap(map, "Pre", "One", "Two");
    }

    private void assertPreinstantiateMap(Map<String, String> map) {
        this.assertMap(map, "One", "Two");
    }

    private void assertMap(Map<String, String> map, String ... values) {
        PreinstantiatedCollectionTestCase.assertNotNull(map);
        for (String s : values) {
            PreinstantiatedCollectionTestCase.assertEquals((String)s, (String)map.get(s));
        }
    }
}

