/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.deployment.xml.test;

import java.util.List;
import java.util.Set;
import junit.framework.Test;
import org.jboss.annotation.factory.AnnotationCreator;
import org.jboss.beans.metadata.api.model.QualifierContent;
import org.jboss.beans.metadata.api.model.QualifierPoint;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractBeanQualifierMetaData;
import org.jboss.beans.metadata.plugins.AbstractInjectionValueMetaData;
import org.jboss.beans.metadata.plugins.AbstractQualifierMetaData;
import org.jboss.beans.metadata.spi.ConstructorMetaData;
import org.jboss.beans.metadata.spi.InstallMetaData;
import org.jboss.beans.metadata.spi.ParameterMetaData;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.beans.metadata.spi.RelatedClassMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.kernel.plugins.dependency.QualifiersMdrUtil;
import org.jboss.kernel.spi.qualifier.QualifierMatchers;
import org.jboss.kernel.spi.qualifier.QualifierParser;
import org.jboss.test.kernel.deployment.xml.test.AbstractXMLTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QualifierTestCase
extends AbstractXMLTest {
    public static Test suite() {
        return QualifierTestCase.suite(QualifierTestCase.class);
    }

    public QualifierTestCase(String name) {
        super(name);
    }

    protected QualifierTestCase(String name, boolean useClone) {
        super(name, useClone);
    }

    public void testBeanQualifierWithEnabled() throws Exception {
        RelatedClassMetaData related = this.getRelated("QualifierBeanWithEnabled.xml");
        QualifierTestCase.assertEquals((String)QualifiersMdrUtil.SUPPLIED_QUALIFIER_KEY, (String)related.getClassName());
        this.assertInstanceOf(related, AbstractQualifierMetaData.class);
        QualifierTestCase.assertEquals((Object)QualifierContent.STRING, (Object)((AbstractQualifierMetaData)related).getContent());
        Set enabled = related.getEnabled();
        QualifierTestCase.assertNotNull((Object)enabled);
        QualifierTestCase.assertEquals((int)1, (int)enabled.size());
        QualifierTestCase.assertEquals((Object)"aop", enabled.iterator().next());
    }

    public void testBeanStringQualifier() throws Exception {
        RelatedClassMetaData related = this.getRelated("QualifierBeanString.xml");
        QualifierTestCase.assertEquals((String)QualifiersMdrUtil.SUPPLIED_QUALIFIER_KEY, (String)related.getClassName());
        this.assertInstanceOf(related, AbstractQualifierMetaData.class);
        QualifierTestCase.assertEquals((Object)QualifierContent.STRING, (Object)((AbstractQualifierMetaData)related).getContent());
        Set enabled = related.getEnabled();
        QualifierTestCase.assertNotNull((Object)enabled);
        QualifierTestCase.assertEquals((int)1, (int)enabled.size());
        QualifierTestCase.assertEquals((Object)"aop", enabled.iterator().next());
    }

    public void testBeanAnnotationQualifier() throws Exception {
        RelatedClassMetaData related = this.getRelated("QualifierBeanAnnotation.xml");
        QualifierTestCase.assertEquals((String)QualifiersMdrUtil.SUPPLIED_QUALIFIER_KEY, (String)related.getClassName());
        this.assertInstanceOf(related, AbstractQualifierMetaData.class);
        QualifierTestCase.assertEquals((Object)QualifierContent.ANNOTATION, (Object)((AbstractQualifierMetaData)related).getContent());
        Set enabled = related.getEnabled();
        QualifierTestCase.assertNotNull((Object)enabled);
        QualifierTestCase.assertEquals((int)1, (int)enabled.size());
        QualifierTestCase.assertEquals((Object)AnnotationCreator.createAnnotation((String)"@java.lang.Override", Override.class), enabled.iterator().next());
        this.assertInstanceOf(related, AbstractQualifierMetaData.class);
    }

    public void testBeanQualifierWithEnableds() throws Exception {
        RelatedClassMetaData related = this.getRelated("QualifierBeanWithEnableds.xml");
        QualifierTestCase.assertEquals((String)QualifiersMdrUtil.SUPPLIED_QUALIFIER_KEY, (String)related.getClassName());
        Set enabled = related.getEnabled();
        QualifierTestCase.assertNotNull((Object)enabled);
        QualifierTestCase.assertEquals((int)2, (int)enabled.size());
        QualifierTestCase.assertTrue((boolean)enabled.contains("123"));
        QualifierTestCase.assertTrue((boolean)enabled.contains("abc"));
        System.out.println(enabled);
    }

    public void testBeanQualifierWithClassNameFails() throws Exception {
        try {
            this.getRelated("QualifierBeanWithNameFails.xml");
            QualifierTestCase.fail((String)"Should not have accepted the 'name' attribute");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testBeanQualifierWithRequiredType() throws Exception {
        RelatedClassMetaData related = this.getRelated("QualifierBeanWithRequiredType.xml");
        QualifierTestCase.assertEquals((String)QualifiersMdrUtil.REQUIRED_QUALIFIER_KEY, (String)related.getClassName());
        Set enabled = related.getEnabled();
        QualifierTestCase.assertNotNull((Object)enabled);
        QualifierTestCase.assertEquals((int)1, (int)enabled.size());
        QualifierTestCase.assertEquals((Object)"aop", enabled.iterator().next());
    }

    public void testBeanQualifierWithOptionalType() throws Exception {
        RelatedClassMetaData related = this.getRelated("QualifierBeanWithOptionalType.xml");
        QualifierTestCase.assertEquals((String)QualifiersMdrUtil.OPTIONAL_QUALIFIER_KEY, (String)related.getClassName());
        Set enabled = related.getEnabled();
        QualifierTestCase.assertNotNull((Object)enabled);
        QualifierTestCase.assertEquals((int)1, (int)enabled.size());
        QualifierTestCase.assertEquals((Object)"aop", enabled.iterator().next());
    }

    public void testBeanQualifierWithSuppliedType() throws Exception {
        RelatedClassMetaData related = this.getRelated("QualifierBeanWithSuppliedType.xml");
        QualifierTestCase.assertEquals((String)QualifiersMdrUtil.SUPPLIED_QUALIFIER_KEY, (String)related.getClassName());
        Set enabled = related.getEnabled();
        QualifierTestCase.assertNotNull((Object)enabled);
        QualifierTestCase.assertEquals((int)1, (int)enabled.size());
        QualifierTestCase.assertEquals((Object)"aop", enabled.iterator().next());
    }

    public void testBeanQualifierWithWrongTypeFails() throws Exception {
        try {
            this.getRelated("QualifierBeanWithWrongTypeFails.xml");
            QualifierTestCase.fail((String)"Should not have accepted the 'name' attribute");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testBeanQualifierWithSinglePoint() throws Exception {
        RelatedClassMetaData related = this.getRelated("QualifierBeanWithSinglePoint.xml");
        QualifierTestCase.assertEquals((String)QualifiersMdrUtil.REQUIRED_QUALIFIER_KEY, (String)related.getClassName());
        this.assertInstanceOf(related, AbstractQualifierMetaData.class);
        QualifierTestCase.assertEquals((Object)QualifierContent.STRING, (Object)((AbstractQualifierMetaData)related).getContent());
        Set enabled = related.getEnabled();
        QualifierTestCase.assertNotNull((Object)enabled);
        QualifierTestCase.assertEquals((int)1, (int)enabled.size());
        QualifierTestCase.assertEquals((Object)"123", enabled.iterator().next());
        this.assertInstanceOf(related, AbstractBeanQualifierMetaData.class);
        QualifierTestCase.assertNotNull((Object)((AbstractBeanQualifierMetaData)related).getPoints());
        QualifierTestCase.assertEquals((int)1, (int)((AbstractBeanQualifierMetaData)related).getPoints().size());
        QualifierTestCase.assertTrue((boolean)((AbstractBeanQualifierMetaData)related).getPoints().contains(QualifierPoint.METHOD));
    }

    public void testBeanQualifierWithPoints() throws Exception {
        RelatedClassMetaData related = this.getRelated("QualifierBeanWithPoints.xml");
        QualifierTestCase.assertEquals((String)QualifiersMdrUtil.REQUIRED_QUALIFIER_KEY, (String)related.getClassName());
        this.assertInstanceOf(related, AbstractQualifierMetaData.class);
        QualifierTestCase.assertEquals((Object)QualifierContent.STRING, (Object)((AbstractQualifierMetaData)related).getContent());
        Set enabled = related.getEnabled();
        QualifierTestCase.assertNotNull((Object)enabled);
        QualifierTestCase.assertEquals((int)1, (int)enabled.size());
        QualifierTestCase.assertEquals((Object)"123", enabled.iterator().next());
        this.assertInstanceOf(related, AbstractBeanQualifierMetaData.class);
        QualifierTestCase.assertNotNull((Object)((AbstractBeanQualifierMetaData)related).getPoints());
        QualifierTestCase.assertEquals((int)2, (int)((AbstractBeanQualifierMetaData)related).getPoints().size());
        QualifierTestCase.assertTrue((boolean)((AbstractBeanQualifierMetaData)related).getPoints().contains(QualifierPoint.CONSTRUCTOR));
        QualifierTestCase.assertTrue((boolean)((AbstractBeanQualifierMetaData)related).getPoints().contains(QualifierPoint.PROPERTY));
    }

    public void testInjectPropertyQualifierWithEnableds() throws Exception {
        AbstractBeanMetaData bean = this.unmarshalBean("QualifierPropertyInjectWithEnableds.xml");
        boolean found = false;
        for (PropertyMetaData property : bean.getProperties()) {
            found = true;
            if (!property.getName().equals("test")) continue;
            ValueMetaData valueMetaData = property.getValue();
            this.assertInstanceOf(valueMetaData, AbstractInjectionValueMetaData.class);
            RelatedClassMetaData related = this.checkRelated(((AbstractInjectionValueMetaData)valueMetaData).getQualifiers());
            QualifierTestCase.assertEquals((String)QualifiersMdrUtil.REQUIRED_QUALIFIER_KEY, (String)related.getClassName());
            this.assertInstanceOf(related, AbstractQualifierMetaData.class);
            QualifierTestCase.assertEquals((Object)QualifierContent.STRING, (Object)((AbstractQualifierMetaData)related).getContent());
            Set enabled = related.getEnabled();
            QualifierTestCase.assertNotNull((Object)enabled);
            QualifierTestCase.assertEquals((int)2, (int)enabled.size());
        }
        QualifierTestCase.assertTrue((boolean)found);
    }

    public void testInjectPropertyAnnotationQualifier() throws Exception {
        AbstractBeanMetaData bean = this.unmarshalBean("QualifierPropertyInjectAnnotation.xml");
        boolean found = false;
        for (PropertyMetaData property : bean.getProperties()) {
            found = true;
            if (!property.getName().equals("test")) continue;
            ValueMetaData valueMetaData = property.getValue();
            this.assertInstanceOf(valueMetaData, AbstractInjectionValueMetaData.class);
            RelatedClassMetaData related = this.checkRelated(((AbstractInjectionValueMetaData)valueMetaData).getQualifiers());
            QualifierTestCase.assertEquals((String)QualifiersMdrUtil.REQUIRED_QUALIFIER_KEY, (String)related.getClassName());
            this.assertInstanceOf(related, AbstractQualifierMetaData.class);
            QualifierTestCase.assertEquals((Object)QualifierContent.ANNOTATION, (Object)((AbstractQualifierMetaData)related).getContent());
            Set enabled = related.getEnabled();
            QualifierTestCase.assertNotNull((Object)enabled);
            QualifierTestCase.assertEquals((int)1, (int)enabled.size());
            QualifierTestCase.assertEquals((Object)AnnotationCreator.createAnnotation((String)"@java.lang.Override", Override.class), enabled.iterator().next());
        }
        QualifierTestCase.assertTrue((boolean)found);
    }

    public void testInjectConstructorParameterWithEnabled() throws Exception {
        AbstractBeanMetaData bean = this.unmarshalBean("QualifierConstructorParameterInjectWithEnabled.xml");
        ConstructorMetaData cmd = bean.getConstructor();
        QualifierTestCase.assertNotNull((Object)cmd);
        List params = cmd.getParameters();
        QualifierTestCase.assertNotNull((Object)params);
        QualifierTestCase.assertEquals((int)1, (int)params.size());
        ValueMetaData valueMetaData = ((ParameterMetaData)params.get(0)).getValue();
        this.assertInstanceOf(valueMetaData, AbstractInjectionValueMetaData.class);
        RelatedClassMetaData related = this.checkRelated(((AbstractInjectionValueMetaData)valueMetaData).getQualifiers());
        QualifierTestCase.assertEquals((String)QualifiersMdrUtil.REQUIRED_QUALIFIER_KEY, (String)related.getClassName());
        this.assertInstanceOf(related, AbstractQualifierMetaData.class);
        QualifierTestCase.assertEquals((Object)QualifierContent.STRING, (Object)((AbstractQualifierMetaData)related).getContent());
        Set enabled = related.getEnabled();
        QualifierTestCase.assertNotNull((Object)enabled);
        QualifierTestCase.assertEquals((int)1, (int)enabled.size());
        QualifierTestCase.assertEquals((Object)"aop", enabled.iterator().next());
    }

    public void testInjectMethodParameterWithEnabled() throws Exception {
        AbstractBeanMetaData bean = this.unmarshalBean("QualifierMethodParameterInjectWithEnabled.xml");
        List installs = bean.getInstalls();
        QualifierTestCase.assertEquals((int)1, (int)installs.size());
        List params = ((InstallMetaData)installs.get(0)).getParameters();
        QualifierTestCase.assertNotNull((Object)params);
        QualifierTestCase.assertEquals((int)1, (int)params.size());
        ValueMetaData valueMetaData = ((ParameterMetaData)params.get(0)).getValue();
        this.assertInstanceOf(valueMetaData, AbstractInjectionValueMetaData.class);
        RelatedClassMetaData related = this.checkRelated(((AbstractInjectionValueMetaData)valueMetaData).getQualifiers());
        QualifierTestCase.assertEquals((String)QualifiersMdrUtil.REQUIRED_QUALIFIER_KEY, (String)related.getClassName());
        this.assertInstanceOf(related, AbstractQualifierMetaData.class);
        QualifierTestCase.assertEquals((Object)QualifierContent.STRING, (Object)((AbstractQualifierMetaData)related).getContent());
        Set enabled = related.getEnabled();
        QualifierTestCase.assertNotNull((Object)enabled);
        QualifierTestCase.assertEquals((int)1, (int)enabled.size());
        QualifierTestCase.assertEquals((Object)"aop", enabled.iterator().next());
    }

    public void testInjectPropertyQualifierWithClassNameFails() throws Exception {
        try {
            this.unmarshalBean("QualifierPropertyInjectWithNameFail.xml");
            QualifierTestCase.fail((String)"Should not have accepted the 'name' attribute");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testBeanNonStandardContent() throws Exception {
        this.checkBeanNonStandardContent(true);
        QualifierMatchers.getInstance().addParser((QualifierParser)RubbishQualifierParser.INSTANCE);
        this.checkBeanNonStandardContent(false);
        QualifierMatchers.getInstance().removeParser(RubbishQualifierParser.INSTANCE.getHandledContent());
        this.checkBeanNonStandardContent(true);
    }

    private void checkBeanNonStandardContent(boolean expectFailure) throws Exception {
        Set enabled;
        block4: {
            RelatedClassMetaData related = this.getRelated("QualifierBeanNonStandardContent.xml");
            QualifierTestCase.assertEquals((String)QualifiersMdrUtil.SUPPLIED_QUALIFIER_KEY, (String)related.getClassName());
            this.assertInstanceOf(related, AbstractQualifierMetaData.class);
            QualifierTestCase.assertSame((Object)QualifierContent.getContent((String)"Rubbish"), (Object)((AbstractQualifierMetaData)related).getContent());
            enabled = null;
            try {
                enabled = related.getEnabled();
                if (expectFailure) {
                    QualifierTestCase.fail((String)"Expected failure");
                }
            }
            catch (Exception possible) {
                if (expectFailure) break block4;
                QualifierTestCase.fail((String)"Expected success");
            }
        }
        if (expectFailure) {
            return;
        }
        QualifierTestCase.assertNotNull((Object)enabled);
        QualifierTestCase.assertEquals((int)1, (int)enabled.size());
        QualifierTestCase.assertEquals((Object)"!@\u0141123", enabled.iterator().next());
    }

    public void testInjectNonStandardContent() throws Exception {
        this.checkInjectNonStandardContent(true);
        QualifierMatchers.getInstance().addParser((QualifierParser)RubbishQualifierParser.INSTANCE);
        this.checkInjectNonStandardContent(false);
        QualifierMatchers.getInstance().removeParser(RubbishQualifierParser.INSTANCE.getHandledContent());
        this.checkInjectNonStandardContent(true);
    }

    private void checkInjectNonStandardContent(boolean expectFailure) throws Exception {
        Set enabled;
        block4: {
            AbstractBeanMetaData bean = this.unmarshalBean("QualifierInjectNonStandardContent.xml");
            List installs = bean.getInstalls();
            QualifierTestCase.assertEquals((int)1, (int)installs.size());
            List params = ((InstallMetaData)installs.get(0)).getParameters();
            QualifierTestCase.assertNotNull((Object)params);
            QualifierTestCase.assertEquals((int)1, (int)params.size());
            ValueMetaData valueMetaData = ((ParameterMetaData)params.get(0)).getValue();
            this.assertInstanceOf(valueMetaData, AbstractInjectionValueMetaData.class);
            RelatedClassMetaData related = this.checkRelated(((AbstractInjectionValueMetaData)valueMetaData).getQualifiers());
            QualifierTestCase.assertEquals((String)QualifiersMdrUtil.REQUIRED_QUALIFIER_KEY, (String)related.getClassName());
            this.assertInstanceOf(related, AbstractQualifierMetaData.class);
            QualifierTestCase.assertSame((Object)QualifierContent.getContent((String)"Rubbish"), (Object)((AbstractQualifierMetaData)related).getContent());
            enabled = null;
            try {
                enabled = related.getEnabled();
                if (expectFailure) {
                    QualifierTestCase.fail((String)"Expected failure");
                }
            }
            catch (Exception e) {
                if (expectFailure) break block4;
                QualifierTestCase.fail((String)"Expected success");
            }
        }
        if (expectFailure) {
            return;
        }
        QualifierTestCase.assertNotNull((Object)enabled);
        QualifierTestCase.assertEquals((int)1, (int)enabled.size());
        QualifierTestCase.assertEquals((Object)"abc!@\u0141", enabled.iterator().next());
    }

    protected RelatedClassMetaData getRelated(String name) throws Exception {
        AbstractBeanMetaData bean = this.unmarshalBean(name);
        return this.checkRelated(bean.getRelated());
    }

    protected RelatedClassMetaData checkRelated(Set<RelatedClassMetaData> related) {
        QualifierTestCase.assertNotNull(related);
        QualifierTestCase.assertEquals((int)1, (int)related.size());
        RelatedClassMetaData rcmd = related.iterator().next();
        QualifierTestCase.assertNotNull((Object)rcmd);
        return rcmd;
    }

    private static class RubbishQualifierParser
    implements QualifierParser {
        static RubbishQualifierParser INSTANCE = new RubbishQualifierParser();

        private RubbishQualifierParser() {
        }

        public QualifierContent getHandledContent() {
            return QualifierContent.getContent((String)"Rubbish");
        }

        public Object parseSupplied(ClassLoader cl, Object rawQualifier) {
            return (String)rawQualifier + "123";
        }

        public Object parseWanted(ClassLoader cl, Object object) {
            return "abc" + (String)object;
        }
    }
}

