/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.qualifiers.test;

import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Test;
import org.jboss.annotation.factory.AnnotationCreator;
import org.jboss.beans.metadata.api.model.AutowireType;
import org.jboss.beans.metadata.api.model.QualifierContent;
import org.jboss.beans.metadata.api.model.QualifierPoint;
import org.jboss.beans.metadata.api.model.QualifierType;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractBeanQualifierMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.kernel.plugins.dependency.QualifiersMdrUtil;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.qualifier.QualifierMatcher;
import org.jboss.kernel.spi.qualifier.QualifierMatchers;
import org.jboss.kernel.spi.qualifier.QualifierParser;
import org.jboss.metadata.plugins.loader.memory.MemoryMetaDataLoader;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.scope.ScopeKey;
import org.jboss.test.kernel.junit.MicrocontainerTest;
import org.jboss.test.kernel.qualifiers.support.Bean;
import org.jboss.test.kernel.qualifiers.support.TargetBean;
import org.jboss.test.kernel.qualifiers.support.TestMatcherAndParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanQualifiersTestCase
extends MicrocontainerTest {
    public BeanQualifiersTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        return BeanQualifiersTestCase.suite(BeanQualifiersTestCase.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testContextsMDRHasQualifiers() throws Throwable {
        BeanMetaDataBuilder bean1Builder = BeanMetaDataBuilder.createBuilder((String)"bean1", (String)Bean.class.getName());
        KernelControllerContext bean1Context = this.deploy(bean1Builder.getBeanMetaData());
        BeanMetaDataBuilder bean2Builder = BeanMetaDataBuilder.createBuilder((String)"bean2", (String)Bean.class.getName());
        bean2Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"supplied1", "supplied2"});
        bean2Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{this.getAnnotation(Override.class)});
        bean2Builder.addQualifiers(QualifierType.REQUIRED, new Object[]{"required1"});
        bean2Builder.addQualifiers(QualifierType.REQUIRED, new Object[]{this.getAnnotation(Documented.class)});
        bean2Builder.addQualifiers(QualifierType.OPTIONAL, new Object[]{"optional1", "optional2", "optional3"});
        bean2Builder.addQualifiers(QualifierType.OPTIONAL, new Object[]{this.getAnnotation(Deprecated.class)});
        KernelControllerContext bean2Context = this.deploy(bean2Builder.getBeanMetaData());
        try {
            this.assertBean("bean1", Bean.class);
            this.assertBean("bean2", Bean.class);
            Set set = QualifiersMdrUtil.mergeSuppliedQualifiersFromMdr((ControllerContext)bean1Context);
            BeanQualifiersTestCase.assertNull((Object)set);
            set = QualifiersMdrUtil.mergeRequiredQualifiersFromMdr((ControllerContext)bean1Context, (QualifierPoint)QualifierPoint.PROPERTY);
            BeanQualifiersTestCase.assertNull((Object)set);
            set = QualifiersMdrUtil.mergeOptionalQualifiersFromMdr((ControllerContext)bean1Context, (QualifierPoint)QualifierPoint.METHOD);
            BeanQualifiersTestCase.assertNull((Object)set);
            set = QualifiersMdrUtil.mergeSuppliedQualifiersFromMdr((ControllerContext)bean2Context);
            BeanQualifiersTestCase.assertNotNull((Object)set);
            BeanQualifiersTestCase.assertEquals((int)3, (int)set.size());
            BeanQualifiersTestCase.assertTrue((boolean)set.contains("supplied1"));
            BeanQualifiersTestCase.assertTrue((boolean)set.contains("supplied2"));
            BeanQualifiersTestCase.assertTrue((boolean)set.contains(this.getAnnotation(Override.class)));
            set = QualifiersMdrUtil.mergeRequiredQualifiersFromMdr((ControllerContext)bean2Context, (QualifierPoint)QualifierPoint.CONSTRUCTOR);
            BeanQualifiersTestCase.assertNotNull((Object)set);
            BeanQualifiersTestCase.assertEquals((int)2, (int)set.size());
            BeanQualifiersTestCase.assertTrue((boolean)set.contains("required1"));
            BeanQualifiersTestCase.assertTrue((boolean)set.contains(this.getAnnotation(Documented.class)));
            set = QualifiersMdrUtil.mergeOptionalQualifiersFromMdr((ControllerContext)bean2Context, (QualifierPoint)QualifierPoint.PROPERTY);
            BeanQualifiersTestCase.assertNotNull((Object)set);
            BeanQualifiersTestCase.assertEquals((int)4, (int)set.size());
            BeanQualifiersTestCase.assertTrue((boolean)set.contains("optional1"));
            BeanQualifiersTestCase.assertTrue((boolean)set.contains("optional2"));
            BeanQualifiersTestCase.assertTrue((boolean)set.contains("optional3"));
            BeanQualifiersTestCase.assertTrue((boolean)set.contains(this.getAnnotation(Deprecated.class)));
        }
        finally {
            this.undeploy(bean1Context);
            this.undeploy(bean2Context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testContextsMDRHasQualifiersUsingAnnotationContentType() throws Throwable {
        BeanMetaDataBuilder bean1Builder = BeanMetaDataBuilder.createBuilder((String)"bean1", (String)Bean.class.getName());
        KernelControllerContext bean1Context = this.deploy(bean1Builder.getBeanMetaData());
        BeanMetaDataBuilder bean2Builder = BeanMetaDataBuilder.createBuilder((String)"bean2", (String)Bean.class.getName());
        AbstractBeanQualifierMetaData beanQualifier = new AbstractBeanQualifierMetaData();
        beanQualifier.setType(QualifierType.SUPPLIED);
        beanQualifier.setContent(QualifierContent.ANNOTATION);
        HashSet<String> enableds = new HashSet<String>();
        enableds.add("@" + Override.class.getName());
        beanQualifier.setEnabled(enableds);
        HashSet<AbstractBeanQualifierMetaData> qualifiers = new HashSet<AbstractBeanQualifierMetaData>();
        qualifiers.add(beanQualifier);
        ((AbstractBeanMetaData)bean2Builder.getBeanMetaData()).setRelated(qualifiers);
        KernelControllerContext bean2Context = this.deploy(bean2Builder.getBeanMetaData());
        try {
            this.assertBean("bean1", Bean.class);
            this.assertBean("bean2", Bean.class);
            Set set = QualifiersMdrUtil.mergeSuppliedQualifiersFromMdr((ControllerContext)bean1Context);
            BeanQualifiersTestCase.assertNull((Object)set);
            set = QualifiersMdrUtil.mergeSuppliedQualifiersFromMdr((ControllerContext)bean2Context);
            BeanQualifiersTestCase.assertNotNull((Object)set);
            BeanQualifiersTestCase.assertEquals((int)1, (int)set.size());
            BeanQualifiersTestCase.assertTrue((boolean)set.contains(this.getAnnotation(Override.class)));
        }
        finally {
            this.undeploy(bean1Context);
            this.undeploy(bean2Context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testContextsMDRHasQualifiersFromAllLevels() throws Throwable {
        MemoryMetaDataLoader loader = new MemoryMetaDataLoader(ScopeKey.DEFAULT_SCOPE);
        QualifiersMdrUtil.addQualifiersToMdrRetrieval((MetaDataRetrieval)loader, (QualifierType)QualifierType.SUPPLIED, null, (Object[])new Object[]{"supplied1", this.getAnnotation(Override.class)});
        QualifiersMdrUtil.addQualifiersToMdrRetrieval((MetaDataRetrieval)loader, (QualifierType)QualifierType.REQUIRED, null, (Object[])new Object[]{"wanted1", this.getAnnotation(Documented.class)});
        QualifiersMdrUtil.addQualifiersToMdrRetrieval((MetaDataRetrieval)loader, (QualifierType)QualifierType.OPTIONAL, null, (Object[])new Object[]{"optional1", this.getAnnotation(Deprecated.class)});
        this.getMetaDataRepository().getMetaDataRepository().addMetaDataRetrieval((MetaDataRetrieval)loader);
        BeanMetaDataBuilder bean1Builder = BeanMetaDataBuilder.createBuilder((String)"bean1", (String)Bean.class.getName());
        KernelControllerContext bean1Context = this.deploy(bean1Builder.getBeanMetaData());
        BeanMetaDataBuilder bean2Builder = BeanMetaDataBuilder.createBuilder((String)"bean2", (String)Bean.class.getName());
        bean2Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"supplied2"});
        bean2Builder.addQualifiers(QualifierType.REQUIRED, new Object[]{"wanted2"});
        bean2Builder.addQualifiers(QualifierType.OPTIONAL, new Object[]{"optional2"});
        KernelControllerContext bean2Context = this.deploy(bean2Builder.getBeanMetaData());
        try {
            this.assertBean("bean1", Bean.class);
            this.assertBean("bean2", Bean.class);
            Set set = QualifiersMdrUtil.mergeSuppliedQualifiersFromMdr((ControllerContext)bean1Context);
            BeanQualifiersTestCase.assertNotNull((Object)set);
            BeanQualifiersTestCase.assertEquals((int)2, (int)set.size());
            BeanQualifiersTestCase.assertTrue((boolean)set.contains("supplied1"));
            BeanQualifiersTestCase.assertTrue((boolean)set.contains(this.getAnnotation(Override.class)));
            set = QualifiersMdrUtil.mergeRequiredQualifiersFromMdr((ControllerContext)bean1Context, (QualifierPoint)QualifierPoint.PROPERTY);
            BeanQualifiersTestCase.assertNotNull((Object)set);
            BeanQualifiersTestCase.assertEquals((int)2, (int)set.size());
            BeanQualifiersTestCase.assertTrue((boolean)set.contains("wanted1"));
            BeanQualifiersTestCase.assertTrue((boolean)set.contains(this.getAnnotation(Documented.class)));
            set = QualifiersMdrUtil.mergeOptionalQualifiersFromMdr((ControllerContext)bean1Context, (QualifierPoint)QualifierPoint.PROPERTY);
            BeanQualifiersTestCase.assertNotNull((Object)set);
            BeanQualifiersTestCase.assertEquals((int)2, (int)set.size());
            BeanQualifiersTestCase.assertTrue((boolean)set.contains("optional1"));
            BeanQualifiersTestCase.assertTrue((boolean)set.contains(this.getAnnotation(Deprecated.class)));
            set = QualifiersMdrUtil.mergeSuppliedQualifiersFromMdr((ControllerContext)bean2Context);
            BeanQualifiersTestCase.assertNotNull((Object)set);
            BeanQualifiersTestCase.assertEquals((int)3, (int)set.size());
            BeanQualifiersTestCase.assertTrue((boolean)set.contains("supplied1"));
            BeanQualifiersTestCase.assertTrue((boolean)set.contains("supplied2"));
            BeanQualifiersTestCase.assertTrue((boolean)set.contains(this.getAnnotation(Override.class)));
            set = QualifiersMdrUtil.mergeRequiredQualifiersFromMdr((ControllerContext)bean2Context, (QualifierPoint)QualifierPoint.PROPERTY);
            BeanQualifiersTestCase.assertNotNull((Object)set);
            BeanQualifiersTestCase.assertEquals((int)3, (int)set.size());
            BeanQualifiersTestCase.assertTrue((boolean)set.contains("wanted1"));
            BeanQualifiersTestCase.assertTrue((boolean)set.contains("wanted2"));
            BeanQualifiersTestCase.assertTrue((boolean)set.contains(this.getAnnotation(Documented.class)));
            set = QualifiersMdrUtil.mergeOptionalQualifiersFromMdr((ControllerContext)bean2Context, (QualifierPoint)QualifierPoint.PROPERTY);
            BeanQualifiersTestCase.assertNotNull((Object)set);
            BeanQualifiersTestCase.assertEquals((int)3, (int)set.size());
            BeanQualifiersTestCase.assertTrue((boolean)set.contains("optional1"));
            BeanQualifiersTestCase.assertTrue((boolean)set.contains("optional2"));
            BeanQualifiersTestCase.assertTrue((boolean)set.contains(this.getAnnotation(Deprecated.class)));
        }
        finally {
            this.undeploy(bean1Context);
            this.undeploy(bean2Context);
            this.getMetaDataRepository().getMetaDataRepository().removeMetaDataRetrieval(ScopeKey.DEFAULT_SCOPE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMdrQualifierPoints() throws Exception {
        BeanMetaDataBuilder bean1Builder = BeanMetaDataBuilder.createBuilder((String)"bean1", (String)Bean.class.getName());
        bean1Builder.addQualifiers(QualifierType.REQUIRED, Arrays.asList(QualifierPoint.CONSTRUCTOR), new Object[]{"rc"});
        bean1Builder.addQualifiers(QualifierType.REQUIRED, Arrays.asList(QualifierPoint.METHOD), new Object[]{"rm"});
        bean1Builder.addQualifiers(QualifierType.REQUIRED, Arrays.asList(QualifierPoint.PROPERTY), new Object[]{"rp"});
        bean1Builder.addQualifiers(QualifierType.REQUIRED, Arrays.asList(QualifierPoint.PROPERTY, QualifierPoint.METHOD, QualifierPoint.CONSTRUCTOR), new Object[]{"rcmp"});
        bean1Builder.addQualifiers(QualifierType.REQUIRED, new Object[]{"ra"});
        bean1Builder.addQualifiers(QualifierType.OPTIONAL, Arrays.asList(QualifierPoint.CONSTRUCTOR), new Object[]{"oc"});
        bean1Builder.addQualifiers(QualifierType.OPTIONAL, Arrays.asList(QualifierPoint.METHOD), new Object[]{"om"});
        bean1Builder.addQualifiers(QualifierType.OPTIONAL, Arrays.asList(QualifierPoint.PROPERTY), new Object[]{"op"});
        bean1Builder.addQualifiers(QualifierType.OPTIONAL, Arrays.asList(QualifierPoint.PROPERTY, QualifierPoint.METHOD, QualifierPoint.CONSTRUCTOR), new Object[]{"ocmp"});
        bean1Builder.addQualifiers(QualifierType.OPTIONAL, new Object[]{"oa"});
        KernelControllerContext bean1Context = this.deploy(bean1Builder.getBeanMetaData());
        try {
            this.assertBean("bean1", Bean.class);
            Set set = QualifiersMdrUtil.mergeRequiredQualifiersFromMdr((ControllerContext)bean1Context, (QualifierPoint)QualifierPoint.CONSTRUCTOR);
            BeanQualifiersTestCase.assertNotNull((Object)set);
            BeanQualifiersTestCase.assertTrue((boolean)set.contains("rc"));
            BeanQualifiersTestCase.assertTrue((boolean)set.contains("rcmp"));
            BeanQualifiersTestCase.assertTrue((boolean)set.contains("ra"));
            BeanQualifiersTestCase.assertEquals((int)3, (int)set.size());
            set = QualifiersMdrUtil.mergeRequiredQualifiersFromMdr((ControllerContext)bean1Context, (QualifierPoint)QualifierPoint.METHOD);
            BeanQualifiersTestCase.assertNotNull((Object)set);
            BeanQualifiersTestCase.assertTrue((boolean)set.contains("rm"));
            BeanQualifiersTestCase.assertTrue((boolean)set.contains("rcmp"));
            BeanQualifiersTestCase.assertTrue((boolean)set.contains("ra"));
            BeanQualifiersTestCase.assertEquals((int)3, (int)set.size());
            set = QualifiersMdrUtil.mergeRequiredQualifiersFromMdr((ControllerContext)bean1Context, (QualifierPoint)QualifierPoint.PROPERTY);
            BeanQualifiersTestCase.assertNotNull((Object)set);
            BeanQualifiersTestCase.assertTrue((boolean)set.contains("rp"));
            BeanQualifiersTestCase.assertTrue((boolean)set.contains("rcmp"));
            BeanQualifiersTestCase.assertTrue((boolean)set.contains("ra"));
            BeanQualifiersTestCase.assertEquals((int)3, (int)set.size());
            set = QualifiersMdrUtil.mergeOptionalQualifiersFromMdr((ControllerContext)bean1Context, (QualifierPoint)QualifierPoint.CONSTRUCTOR);
            BeanQualifiersTestCase.assertNotNull((Object)set);
            BeanQualifiersTestCase.assertTrue((boolean)set.contains("oc"));
            BeanQualifiersTestCase.assertTrue((boolean)set.contains("ocmp"));
            BeanQualifiersTestCase.assertTrue((boolean)set.contains("oa"));
            BeanQualifiersTestCase.assertEquals((int)3, (int)set.size());
            set = QualifiersMdrUtil.mergeOptionalQualifiersFromMdr((ControllerContext)bean1Context, (QualifierPoint)QualifierPoint.METHOD);
            BeanQualifiersTestCase.assertNotNull((Object)set);
            BeanQualifiersTestCase.assertTrue((boolean)set.contains("om"));
            BeanQualifiersTestCase.assertTrue((boolean)set.contains("ocmp"));
            BeanQualifiersTestCase.assertTrue((boolean)set.contains("oa"));
            BeanQualifiersTestCase.assertEquals((int)3, (int)set.size());
            set = QualifiersMdrUtil.mergeOptionalQualifiersFromMdr((ControllerContext)bean1Context, (QualifierPoint)QualifierPoint.PROPERTY);
            BeanQualifiersTestCase.assertNotNull((Object)set);
            BeanQualifiersTestCase.assertTrue((boolean)set.contains("op"));
            BeanQualifiersTestCase.assertTrue((boolean)set.contains("ocmp"));
            BeanQualifiersTestCase.assertTrue((boolean)set.contains("oa"));
            BeanQualifiersTestCase.assertEquals((int)3, (int)set.size());
        }
        finally {
            this.undeploy(bean1Context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMdrQualifierPointsFromHigherLevel() throws Exception {
        MemoryMetaDataLoader loader = new MemoryMetaDataLoader(ScopeKey.DEFAULT_SCOPE);
        QualifiersMdrUtil.addQualifiersToMdrRetrieval((MetaDataRetrieval)loader, (QualifierType)QualifierType.REQUIRED, (QualifierPoint)QualifierPoint.CONSTRUCTOR, (Object[])new Object[]{"rc"});
        QualifiersMdrUtil.addQualifiersToMdrRetrieval((MetaDataRetrieval)loader, (QualifierType)QualifierType.REQUIRED, (QualifierPoint)QualifierPoint.METHOD, (Object[])new Object[]{"rm"});
        QualifiersMdrUtil.addQualifiersToMdrRetrieval((MetaDataRetrieval)loader, (QualifierType)QualifierType.REQUIRED, (QualifierPoint)QualifierPoint.PROPERTY, (Object[])new Object[]{"rp"});
        QualifiersMdrUtil.addQualifiersToMdrRetrieval((MetaDataRetrieval)loader, (QualifierType)QualifierType.REQUIRED, null, (Object[])new Object[]{"ra"});
        QualifiersMdrUtil.addQualifiersToMdrRetrieval((MetaDataRetrieval)loader, (QualifierType)QualifierType.OPTIONAL, (QualifierPoint)QualifierPoint.CONSTRUCTOR, (Object[])new Object[]{"oc"});
        QualifiersMdrUtil.addQualifiersToMdrRetrieval((MetaDataRetrieval)loader, (QualifierType)QualifierType.OPTIONAL, (QualifierPoint)QualifierPoint.METHOD, (Object[])new Object[]{"om"});
        QualifiersMdrUtil.addQualifiersToMdrRetrieval((MetaDataRetrieval)loader, (QualifierType)QualifierType.OPTIONAL, (QualifierPoint)QualifierPoint.PROPERTY, (Object[])new Object[]{"op"});
        QualifiersMdrUtil.addQualifiersToMdrRetrieval((MetaDataRetrieval)loader, (QualifierType)QualifierType.OPTIONAL, null, (Object[])new Object[]{"oa"});
        this.getMetaDataRepository().getMetaDataRepository().addMetaDataRetrieval((MetaDataRetrieval)loader);
        BeanMetaDataBuilder bean1Builder = BeanMetaDataBuilder.createBuilder((String)"bean1", (String)Bean.class.getName());
        KernelControllerContext bean1Context = this.deploy(bean1Builder.getBeanMetaData());
        try {
            this.assertBean("bean1", Bean.class);
            Set set = QualifiersMdrUtil.mergeRequiredQualifiersFromMdr((ControllerContext)bean1Context, (QualifierPoint)QualifierPoint.CONSTRUCTOR);
            BeanQualifiersTestCase.assertNotNull((Object)set);
            BeanQualifiersTestCase.assertTrue((boolean)set.contains("rc"));
            BeanQualifiersTestCase.assertTrue((boolean)set.contains("ra"));
            BeanQualifiersTestCase.assertEquals((int)2, (int)set.size());
            set = QualifiersMdrUtil.mergeRequiredQualifiersFromMdr((ControllerContext)bean1Context, (QualifierPoint)QualifierPoint.METHOD);
            BeanQualifiersTestCase.assertNotNull((Object)set);
            BeanQualifiersTestCase.assertTrue((boolean)set.contains("rm"));
            BeanQualifiersTestCase.assertTrue((boolean)set.contains("ra"));
            BeanQualifiersTestCase.assertEquals((int)2, (int)set.size());
            set = QualifiersMdrUtil.mergeRequiredQualifiersFromMdr((ControllerContext)bean1Context, (QualifierPoint)QualifierPoint.PROPERTY);
            BeanQualifiersTestCase.assertNotNull((Object)set);
            BeanQualifiersTestCase.assertTrue((boolean)set.contains("rp"));
            BeanQualifiersTestCase.assertTrue((boolean)set.contains("ra"));
            BeanQualifiersTestCase.assertEquals((int)2, (int)set.size());
            set = QualifiersMdrUtil.mergeOptionalQualifiersFromMdr((ControllerContext)bean1Context, (QualifierPoint)QualifierPoint.CONSTRUCTOR);
            BeanQualifiersTestCase.assertNotNull((Object)set);
            BeanQualifiersTestCase.assertTrue((boolean)set.contains("oc"));
            BeanQualifiersTestCase.assertTrue((boolean)set.contains("oa"));
            BeanQualifiersTestCase.assertEquals((int)2, (int)set.size());
            set = QualifiersMdrUtil.mergeOptionalQualifiersFromMdr((ControllerContext)bean1Context, (QualifierPoint)QualifierPoint.METHOD);
            BeanQualifiersTestCase.assertNotNull((Object)set);
            BeanQualifiersTestCase.assertTrue((boolean)set.contains("om"));
            BeanQualifiersTestCase.assertTrue((boolean)set.contains("oa"));
            BeanQualifiersTestCase.assertEquals((int)2, (int)set.size());
            set = QualifiersMdrUtil.mergeOptionalQualifiersFromMdr((ControllerContext)bean1Context, (QualifierPoint)QualifierPoint.PROPERTY);
            BeanQualifiersTestCase.assertNotNull((Object)set);
            BeanQualifiersTestCase.assertTrue((boolean)set.contains("op"));
            BeanQualifiersTestCase.assertTrue((boolean)set.contains("oa"));
            BeanQualifiersTestCase.assertEquals((int)2, (int)set.size());
        }
        finally {
            this.undeploy(bean1Context);
            this.getMetaDataRepository().getMetaDataRepository().removeMetaDataRetrieval(ScopeKey.DEFAULT_SCOPE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimpleQualifier() throws Throwable {
        BeanMetaDataBuilder bean1Builder = BeanMetaDataBuilder.createBuilder((String)"bean1", (String)Bean.class.getName());
        bean1Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test"});
        KernelControllerContext bean1Context = this.deploy(bean1Builder.getBeanMetaData());
        BeanMetaDataBuilder bean2Builder = BeanMetaDataBuilder.createBuilder((String)"bean2", (String)Bean.class.getName());
        KernelControllerContext bean2Context = this.deploy(bean2Builder.getBeanMetaData());
        BeanMetaDataBuilder targetBuilder = BeanMetaDataBuilder.createBuilder((String)"target", (String)TargetBean.class.getName());
        targetBuilder.setAutowireType(AutowireType.BY_CLASS);
        targetBuilder.addQualifiers(QualifierType.REQUIRED, new Object[]{"test"});
        KernelControllerContext targetContext = this.deploy(targetBuilder.getBeanMetaData());
        try {
            Bean bean1 = (Bean)this.assertBean("bean1", Bean.class);
            this.assertBean("bean2", Bean.class);
            TargetBean target = (TargetBean)this.assertBean("target", TargetBean.class);
            BeanQualifiersTestCase.assertNotNull((Object)target.getBean());
            BeanQualifiersTestCase.assertSame((Object)bean1, (Object)target.getBean());
        }
        finally {
            this.undeploy(bean1Context);
            this.undeploy(bean2Context);
            this.undeploy(targetContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnnotationQualifier() throws Throwable {
        BeanMetaDataBuilder bean1Builder = BeanMetaDataBuilder.createBuilder((String)"bean1", (String)Bean.class.getName());
        bean1Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{this.getAnnotation(Override.class)});
        KernelControllerContext bean1Context = this.deploy(bean1Builder.getBeanMetaData());
        BeanMetaDataBuilder bean2Builder = BeanMetaDataBuilder.createBuilder((String)"bean2", (String)Bean.class.getName());
        KernelControllerContext bean2Context = this.deploy(bean2Builder.getBeanMetaData());
        BeanMetaDataBuilder targetBuilder = BeanMetaDataBuilder.createBuilder((String)"target", (String)TargetBean.class.getName());
        targetBuilder.setAutowireType(AutowireType.BY_CLASS);
        targetBuilder.addQualifiers(QualifierType.REQUIRED, new Object[]{this.getAnnotation(Override.class)});
        KernelControllerContext targetContext = this.deploy(targetBuilder.getBeanMetaData());
        try {
            Bean bean1 = (Bean)this.assertBean("bean1", Bean.class);
            this.assertBean("bean2", Bean.class);
            TargetBean target = (TargetBean)this.assertBean("target", TargetBean.class);
            BeanQualifiersTestCase.assertNotNull((Object)target.getBean());
            BeanQualifiersTestCase.assertSame((Object)bean1, (Object)target.getBean());
        }
        finally {
            this.undeploy(bean1Context);
            this.undeploy(bean2Context);
            this.undeploy(targetContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAmbiguousQualifiers() throws Throwable {
        BeanMetaDataBuilder bean1Builder = BeanMetaDataBuilder.createBuilder((String)"bean1", (String)Bean.class.getName());
        bean1Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test"});
        KernelControllerContext bean1Context = this.deploy(bean1Builder.getBeanMetaData());
        BeanMetaDataBuilder bean2Builder = BeanMetaDataBuilder.createBuilder((String)"bean2", (String)Bean.class.getName());
        bean2Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test"});
        KernelControllerContext bean2Context = this.deploy(bean2Builder.getBeanMetaData());
        BeanMetaDataBuilder targetBuilder = BeanMetaDataBuilder.createBuilder((String)"target", (String)TargetBean.class.getName());
        targetBuilder.setAutowireType(AutowireType.BY_CLASS);
        targetBuilder.addQualifiers(QualifierType.REQUIRED, new Object[]{"test"});
        KernelControllerContext targetContext = this.deploy(targetBuilder.getBeanMetaData());
        try {
            this.assertBean("bean1", Bean.class);
            this.assertBean("bean2", Bean.class);
            this.assertNoBean("target");
        }
        finally {
            this.undeploy(bean1Context);
            this.undeploy(bean2Context);
            this.undeploy(targetContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAmbiguousAnnotationQualifiers() throws Throwable {
        BeanMetaDataBuilder bean1Builder = BeanMetaDataBuilder.createBuilder((String)"bean1", (String)Bean.class.getName());
        bean1Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{this.getAnnotation(Override.class)});
        KernelControllerContext bean1Context = this.deploy(bean1Builder.getBeanMetaData());
        BeanMetaDataBuilder bean2Builder = BeanMetaDataBuilder.createBuilder((String)"bean2", (String)Bean.class.getName());
        bean2Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{this.getAnnotation(Override.class)});
        KernelControllerContext bean2Context = this.deploy(bean2Builder.getBeanMetaData());
        BeanMetaDataBuilder targetBuilder = BeanMetaDataBuilder.createBuilder((String)"target", (String)TargetBean.class.getName());
        targetBuilder.setAutowireType(AutowireType.BY_CLASS);
        targetBuilder.addQualifiers(QualifierType.REQUIRED, new Object[]{this.getAnnotation(Override.class)});
        KernelControllerContext targetContext = this.deploy(targetBuilder.getBeanMetaData());
        try {
            this.assertBean("bean1", Bean.class);
            this.assertBean("bean2", Bean.class);
            this.assertNoBean("target");
        }
        finally {
            this.undeploy(bean1Context);
            this.undeploy(bean2Context);
            this.undeploy(targetContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRequiredQualifiersNotIncludingAllBeanQualifiers() throws Throwable {
        BeanMetaDataBuilder bean1Builder = BeanMetaDataBuilder.createBuilder((String)"bean1", (String)Bean.class.getName());
        bean1Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test", "other"});
        KernelControllerContext bean1Context = this.deploy(bean1Builder.getBeanMetaData());
        BeanMetaDataBuilder bean2Builder = BeanMetaDataBuilder.createBuilder((String)"bean2", (String)Bean.class.getName());
        bean2Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"other"});
        KernelControllerContext bean2Context = this.deploy(bean2Builder.getBeanMetaData());
        BeanMetaDataBuilder targetBuilder = BeanMetaDataBuilder.createBuilder((String)"target", (String)TargetBean.class.getName());
        targetBuilder.setAutowireType(AutowireType.BY_CLASS);
        targetBuilder.addQualifiers(QualifierType.REQUIRED, new Object[]{"test"});
        KernelControllerContext targetContext = this.deploy(targetBuilder.getBeanMetaData());
        try {
            Bean bean1 = (Bean)this.assertBean("bean1", Bean.class);
            this.assertBean("bean2", Bean.class);
            TargetBean target = (TargetBean)this.assertBean("target", TargetBean.class);
            BeanQualifiersTestCase.assertNotNull((Object)target.getBean());
            BeanQualifiersTestCase.assertEquals((Object)bean1, (Object)target.getBean());
        }
        finally {
            this.undeploy(bean1Context);
            this.undeploy(bean2Context);
            this.undeploy(targetContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOptionalQualifiersOnly() throws Throwable {
        BeanMetaDataBuilder bean1Builder = BeanMetaDataBuilder.createBuilder((String)"bean1", (String)Bean.class.getName());
        KernelControllerContext bean1Context = this.deploy(bean1Builder.getBeanMetaData());
        BeanMetaDataBuilder bean2Builder = BeanMetaDataBuilder.createBuilder((String)"bean2", (String)Bean.class.getName());
        bean2Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test"});
        KernelControllerContext bean2Context = this.deploy(bean2Builder.getBeanMetaData());
        BeanMetaDataBuilder targetBuilder = BeanMetaDataBuilder.createBuilder((String)"target", (String)TargetBean.class.getName());
        targetBuilder.setAutowireType(AutowireType.BY_CLASS);
        targetBuilder.addQualifiers(QualifierType.OPTIONAL, new Object[]{"test"});
        KernelControllerContext targetContext = this.deploy(targetBuilder.getBeanMetaData());
        try {
            this.assertBean("bean1", Bean.class);
            Bean bean2 = (Bean)this.assertBean("bean2", Bean.class);
            TargetBean target = (TargetBean)this.assertBean("target", TargetBean.class);
            BeanQualifiersTestCase.assertNotNull((Object)target.getBean());
            BeanQualifiersTestCase.assertSame((Object)bean2, (Object)target.getBean());
        }
        finally {
            this.undeploy(bean1Context);
            this.undeploy(bean2Context);
            this.undeploy(targetContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNoopOptionalQualifiers() throws Throwable {
        BeanMetaDataBuilder bean1Builder = BeanMetaDataBuilder.createBuilder((String)"bean1", (String)Bean.class.getName());
        KernelControllerContext bean1Context = this.deploy(bean1Builder.getBeanMetaData());
        BeanMetaDataBuilder targetBuilder = BeanMetaDataBuilder.createBuilder((String)"target", (String)TargetBean.class.getName());
        targetBuilder.setAutowireType(AutowireType.BY_CLASS);
        targetBuilder.addQualifiers(QualifierType.OPTIONAL, new Object[]{"test", "mock"});
        KernelControllerContext targetContext = this.deploy(targetBuilder.getBeanMetaData());
        try {
            Bean bean1 = (Bean)this.assertBean("bean1", Bean.class);
            TargetBean target = (TargetBean)this.assertBean("target", TargetBean.class);
            BeanQualifiersTestCase.assertNotNull((Object)target.getBean());
            BeanQualifiersTestCase.assertSame((Object)bean1, (Object)target.getBean());
        }
        finally {
            this.undeploy(bean1Context);
            this.undeploy(targetContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNoopOptionalQualifiersAndAmbiguity() throws Throwable {
        BeanMetaDataBuilder bean1Builder = BeanMetaDataBuilder.createBuilder((String)"bean1", (String)Bean.class.getName());
        KernelControllerContext bean1Context = this.deploy(bean1Builder.getBeanMetaData());
        BeanMetaDataBuilder bean2Builder = BeanMetaDataBuilder.createBuilder((String)"bean2", (String)Bean.class.getName());
        KernelControllerContext bean2Context = this.deploy(bean2Builder.getBeanMetaData());
        BeanMetaDataBuilder targetBuilder = BeanMetaDataBuilder.createBuilder((String)"target", (String)TargetBean.class.getName());
        targetBuilder.setAutowireType(AutowireType.BY_CLASS);
        targetBuilder.addQualifiers(QualifierType.OPTIONAL, new Object[]{"test", "mock"});
        KernelControllerContext targetContext = this.deploy(targetBuilder.getBeanMetaData());
        try {
            this.assertBean("bean1", Bean.class);
            this.assertBean("bean2", Bean.class);
            this.assertNoBean("target");
        }
        finally {
            this.undeploy(bean1Context);
            this.undeploy(bean2Context);
            this.undeploy(targetContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMoreRequiredQualifiersThanBeanQualifiers() throws Throwable {
        BeanMetaDataBuilder bean1Builder = BeanMetaDataBuilder.createBuilder((String)"bean1", (String)Bean.class.getName());
        bean1Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test"});
        KernelControllerContext bean1Context = this.deploy(bean1Builder.getBeanMetaData());
        BeanMetaDataBuilder bean2Builder = BeanMetaDataBuilder.createBuilder((String)"bean2", (String)Bean.class.getName());
        bean2Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"other"});
        KernelControllerContext bean2Context = this.deploy(bean2Builder.getBeanMetaData());
        BeanMetaDataBuilder targetBuilder = BeanMetaDataBuilder.createBuilder((String)"target", (String)TargetBean.class.getName());
        targetBuilder.setAutowireType(AutowireType.BY_CLASS);
        targetBuilder.addQualifiers(QualifierType.REQUIRED, new Object[]{"test", "mock"});
        KernelControllerContext targetContext = this.deploy(targetBuilder.getBeanMetaData());
        try {
            this.assertBean("bean1", Bean.class);
            this.assertBean("bean2", Bean.class);
            this.assertNoBean("target");
        }
        finally {
            this.undeploy(bean1Context);
            this.undeploy(bean2Context);
            this.undeploy(targetContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMoreOptionalQualifiersThanBeanQualifiers() throws Throwable {
        BeanMetaDataBuilder bean1Builder = BeanMetaDataBuilder.createBuilder((String)"bean1", (String)Bean.class.getName());
        bean1Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test"});
        KernelControllerContext bean1Context = this.deploy(bean1Builder.getBeanMetaData());
        BeanMetaDataBuilder bean2Builder = BeanMetaDataBuilder.createBuilder((String)"bean2", (String)Bean.class.getName());
        bean2Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"other"});
        KernelControllerContext bean2Context = this.deploy(bean2Builder.getBeanMetaData());
        BeanMetaDataBuilder targetBuilder = BeanMetaDataBuilder.createBuilder((String)"target", (String)TargetBean.class.getName());
        targetBuilder.setAutowireType(AutowireType.BY_CLASS);
        targetBuilder.addQualifiers(QualifierType.OPTIONAL, new Object[]{"test", "mock"});
        KernelControllerContext targetContext = this.deploy(targetBuilder.getBeanMetaData());
        try {
            Bean bean1 = (Bean)this.assertBean("bean1", Bean.class);
            this.assertBean("bean2", Bean.class);
            TargetBean target = (TargetBean)this.assertBean("target", TargetBean.class);
            BeanQualifiersTestCase.assertNotNull((Object)target.getBean());
            BeanQualifiersTestCase.assertSame((Object)bean1, (Object)target.getBean());
        }
        finally {
            this.undeploy(bean1Context);
            this.undeploy(bean2Context);
            this.undeploy(targetContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRequiredQualifierNotMatchedOptionalMatched() throws Throwable {
        BeanMetaDataBuilder bean1Builder = BeanMetaDataBuilder.createBuilder((String)"bean1", (String)Bean.class.getName());
        bean1Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test"});
        KernelControllerContext bean1Context = this.deploy(bean1Builder.getBeanMetaData());
        BeanMetaDataBuilder bean2Builder = BeanMetaDataBuilder.createBuilder((String)"bean2", (String)Bean.class.getName());
        bean2Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"other"});
        KernelControllerContext bean2Context = this.deploy(bean2Builder.getBeanMetaData());
        BeanMetaDataBuilder targetBuilder = BeanMetaDataBuilder.createBuilder((String)"target", (String)TargetBean.class.getName());
        targetBuilder.setAutowireType(AutowireType.BY_CLASS);
        targetBuilder.addQualifiers(QualifierType.REQUIRED, new Object[]{"mock"});
        targetBuilder.addQualifiers(QualifierType.OPTIONAL, new Object[]{"test"});
        KernelControllerContext targetContext = this.deploy(targetBuilder.getBeanMetaData());
        try {
            this.assertBean("bean1", Bean.class);
            this.assertBean("bean2", Bean.class);
            this.assertNoBean("target");
        }
        finally {
            this.undeploy(bean1Context);
            this.undeploy(bean2Context);
            this.undeploy(targetContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRequiredQualifierMatchedOptionalNotMatched() throws Throwable {
        BeanMetaDataBuilder bean1Builder = BeanMetaDataBuilder.createBuilder((String)"bean1", (String)Bean.class.getName());
        bean1Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test"});
        KernelControllerContext bean1Context = this.deploy(bean1Builder.getBeanMetaData());
        BeanMetaDataBuilder bean2Builder = BeanMetaDataBuilder.createBuilder((String)"bean2", (String)Bean.class.getName());
        bean2Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"other"});
        KernelControllerContext bean2Context = this.deploy(bean2Builder.getBeanMetaData());
        BeanMetaDataBuilder targetBuilder = BeanMetaDataBuilder.createBuilder((String)"target", (String)TargetBean.class.getName());
        targetBuilder.setAutowireType(AutowireType.BY_CLASS);
        targetBuilder.addQualifiers(QualifierType.REQUIRED, new Object[]{"test"});
        targetBuilder.addQualifiers(QualifierType.OPTIONAL, new Object[]{"mock"});
        KernelControllerContext targetContext = this.deploy(targetBuilder.getBeanMetaData());
        try {
            Bean bean1 = (Bean)this.assertBean("bean1", Bean.class);
            this.assertBean("bean2", Bean.class);
            TargetBean target = (TargetBean)this.assertBean("target", TargetBean.class);
            BeanQualifiersTestCase.assertNotNull((Object)target.getBean());
            BeanQualifiersTestCase.assertSame((Object)bean1, (Object)target.getBean());
        }
        finally {
            this.undeploy(bean1Context);
            this.undeploy(bean2Context);
            this.undeploy(targetContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMoreOptionalQualifiersThanBeanQualifiersMostSelected() throws Throwable {
        BeanMetaDataBuilder bean1Builder = BeanMetaDataBuilder.createBuilder((String)"bean1", (String)Bean.class.getName());
        bean1Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test", "other", "another"});
        KernelControllerContext bean1Context = this.deploy(bean1Builder.getBeanMetaData());
        BeanMetaDataBuilder bean2Builder = BeanMetaDataBuilder.createBuilder((String)"bean2", (String)Bean.class.getName());
        bean2Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test", "another"});
        KernelControllerContext bean2Context = this.deploy(bean2Builder.getBeanMetaData());
        BeanMetaDataBuilder targetBuilder = BeanMetaDataBuilder.createBuilder((String)"target", (String)TargetBean.class.getName());
        targetBuilder.setAutowireType(AutowireType.BY_CLASS);
        targetBuilder.addQualifiers(QualifierType.REQUIRED, new Object[]{"test"});
        targetBuilder.addQualifiers(QualifierType.OPTIONAL, new Object[]{"other", "another", "mock"});
        KernelControllerContext targetContext = this.deploy(targetBuilder.getBeanMetaData());
        try {
            Bean bean1 = (Bean)this.assertBean("bean1", Bean.class);
            this.assertBean("bean2", Bean.class);
            TargetBean target = (TargetBean)this.assertBean("target", TargetBean.class);
            BeanQualifiersTestCase.assertNotNull((Object)target.getBean());
            BeanQualifiersTestCase.assertSame((Object)bean1, (Object)target.getBean());
        }
        finally {
            this.undeploy(bean1Context);
            this.undeploy(bean2Context);
            this.undeploy(targetContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMoreOptionalQualifiersThanBeanQualifiersMostSelected2() throws Throwable {
        BeanMetaDataBuilder bean1Builder = BeanMetaDataBuilder.createBuilder((String)"bean1", (String)Bean.class.getName());
        bean1Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test"});
        KernelControllerContext bean1Context = this.deploy(bean1Builder.getBeanMetaData());
        BeanMetaDataBuilder bean2Builder = BeanMetaDataBuilder.createBuilder((String)"bean2", (String)Bean.class.getName());
        bean2Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test", "other", "another"});
        KernelControllerContext bean2Context = this.deploy(bean2Builder.getBeanMetaData());
        BeanMetaDataBuilder targetBuilder = BeanMetaDataBuilder.createBuilder((String)"target", (String)TargetBean.class.getName());
        targetBuilder.setAutowireType(AutowireType.BY_CLASS);
        targetBuilder.addQualifiers(QualifierType.REQUIRED, new Object[]{"test"});
        targetBuilder.addQualifiers(QualifierType.OPTIONAL, new Object[]{"other", "another", "mock"});
        KernelControllerContext targetContext = this.deploy(targetBuilder.getBeanMetaData());
        try {
            this.assertBean("bean1", Bean.class);
            Bean bean2 = (Bean)this.assertBean("bean2", Bean.class);
            TargetBean target = (TargetBean)this.assertBean("target", TargetBean.class);
            BeanQualifiersTestCase.assertNotNull((Object)target.getBean());
            BeanQualifiersTestCase.assertSame((Object)bean2, (Object)target.getBean());
        }
        finally {
            this.undeploy(bean1Context);
            this.undeploy(bean2Context);
            this.undeploy(targetContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMoreOptionalQualifiersThanBeanQualifiersAmbiguity() throws Throwable {
        BeanMetaDataBuilder bean1Builder = BeanMetaDataBuilder.createBuilder((String)"bean1", (String)Bean.class.getName());
        bean1Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test"});
        KernelControllerContext bean1Context = this.deploy(bean1Builder.getBeanMetaData());
        BeanMetaDataBuilder bean2Builder = BeanMetaDataBuilder.createBuilder((String)"bean2", (String)Bean.class.getName());
        bean2Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"other"});
        KernelControllerContext bean2Context = this.deploy(bean2Builder.getBeanMetaData());
        BeanMetaDataBuilder targetBuilder = BeanMetaDataBuilder.createBuilder((String)"target", (String)TargetBean.class.getName());
        targetBuilder.setAutowireType(AutowireType.BY_CLASS);
        bean1Builder.addQualifiers(QualifierType.OPTIONAL, new Object[]{"test", "other"});
        KernelControllerContext targetContext = this.deploy(targetBuilder.getBeanMetaData());
        try {
            this.assertBean("bean1", Bean.class);
            this.assertBean("bean2", Bean.class);
            this.assertNoBean("target");
        }
        finally {
            this.undeploy(bean1Context);
            this.undeploy(bean2Context);
            this.undeploy(targetContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSuppliedQualifiersFromHigherLevel() throws Throwable {
        MemoryMetaDataLoader loader = new MemoryMetaDataLoader(ScopeKey.DEFAULT_SCOPE);
        QualifiersMdrUtil.addQualifiersToMdrRetrieval((MetaDataRetrieval)loader, (QualifierType)QualifierType.SUPPLIED, null, (Object[])new Object[]{"test"});
        this.getMetaDataRepository().getMetaDataRepository().addMetaDataRetrieval((MetaDataRetrieval)loader);
        BeanMetaDataBuilder bean1Builder = BeanMetaDataBuilder.createBuilder((String)"bean1", (String)Bean.class.getName());
        KernelControllerContext bean1Context = this.deploy(bean1Builder.getBeanMetaData());
        BeanMetaDataBuilder targetBuilder = BeanMetaDataBuilder.createBuilder((String)"target", (String)TargetBean.class.getName());
        targetBuilder.setAutowireType(AutowireType.BY_CLASS);
        targetBuilder.addQualifiers(QualifierType.REQUIRED, new Object[]{"test"});
        KernelControllerContext targetContext = this.deploy(targetBuilder.getBeanMetaData());
        try {
            Bean bean1 = (Bean)this.assertBean("bean1", Bean.class);
            TargetBean target = (TargetBean)this.assertBean("target", TargetBean.class);
            BeanQualifiersTestCase.assertNotNull((Object)target.getBean());
            BeanQualifiersTestCase.assertSame((Object)bean1, (Object)target.getBean());
        }
        finally {
            this.undeploy(bean1Context);
            this.undeploy(targetContext);
            this.getMetaDataRepository().getMetaDataRepository().removeMetaDataRetrieval(ScopeKey.DEFAULT_SCOPE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSuppliedQualifiersFromHigherLevelAndInstance() throws Throwable {
        MemoryMetaDataLoader loader = new MemoryMetaDataLoader(ScopeKey.DEFAULT_SCOPE);
        QualifiersMdrUtil.addQualifiersToMdrRetrieval((MetaDataRetrieval)loader, (QualifierType)QualifierType.SUPPLIED, null, (Object[])new Object[]{"test"});
        this.getMetaDataRepository().getMetaDataRepository().addMetaDataRetrieval((MetaDataRetrieval)loader);
        BeanMetaDataBuilder bean1Builder = BeanMetaDataBuilder.createBuilder((String)"bean1", (String)Bean.class.getName());
        bean1Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"other"});
        KernelControllerContext bean1Context = this.deploy(bean1Builder.getBeanMetaData());
        BeanMetaDataBuilder bean2Builder = BeanMetaDataBuilder.createBuilder((String)"bean2", (String)Bean.class.getName());
        bean2Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"else"});
        KernelControllerContext bean2Context = this.deploy(bean2Builder.getBeanMetaData());
        BeanMetaDataBuilder targetBuilder = BeanMetaDataBuilder.createBuilder((String)"target", (String)TargetBean.class.getName());
        targetBuilder.setAutowireType(AutowireType.BY_CLASS);
        targetBuilder.addQualifiers(QualifierType.REQUIRED, new Object[]{"test", "other"});
        KernelControllerContext targetContext = this.deploy(targetBuilder.getBeanMetaData());
        try {
            Bean bean1 = (Bean)this.assertBean("bean1", Bean.class);
            this.assertBean("bean2", Bean.class);
            TargetBean target = (TargetBean)this.assertBean("target", TargetBean.class);
            BeanQualifiersTestCase.assertNotNull((Object)target.getBean());
            BeanQualifiersTestCase.assertSame((Object)bean1, (Object)target.getBean());
        }
        finally {
            this.undeploy(bean1Context);
            this.undeploy(bean2Context);
            this.undeploy(targetContext);
            this.getMetaDataRepository().getMetaDataRepository().removeMetaDataRetrieval(ScopeKey.DEFAULT_SCOPE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRequiredQualifiersFromHigherLevel() throws Throwable {
        MemoryMetaDataLoader loader = new MemoryMetaDataLoader(ScopeKey.DEFAULT_SCOPE);
        loader.addMetaData(QualifiersMdrUtil.REQUIRED_QUALIFIER_KEY, Collections.singleton("test"), Set.class);
        this.getMetaDataRepository().getMetaDataRepository().addMetaDataRetrieval((MetaDataRetrieval)loader);
        BeanMetaDataBuilder bean1Builder = BeanMetaDataBuilder.createBuilder((String)"bean1", (String)Bean.class.getName());
        bean1Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test"});
        KernelControllerContext bean1Context = this.deploy(bean1Builder.getBeanMetaData());
        BeanMetaDataBuilder targetBuilder = BeanMetaDataBuilder.createBuilder((String)"target", (String)TargetBean.class.getName());
        targetBuilder.setAutowireType(AutowireType.BY_CLASS);
        KernelControllerContext targetContext = this.deploy(targetBuilder.getBeanMetaData());
        try {
            Bean bean1 = (Bean)this.assertBean("bean1", Bean.class);
            TargetBean target = (TargetBean)this.assertBean("target", TargetBean.class);
            BeanQualifiersTestCase.assertNotNull((Object)target.getBean());
            BeanQualifiersTestCase.assertSame((Object)bean1, (Object)target.getBean());
        }
        finally {
            this.undeploy(bean1Context);
            this.undeploy(targetContext);
            this.getMetaDataRepository().getMetaDataRepository().removeMetaDataRetrieval(ScopeKey.DEFAULT_SCOPE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOptionalQualifiersFromHigherLevelAndRequiredOnInstance() throws Throwable {
        MemoryMetaDataLoader loader = new MemoryMetaDataLoader(ScopeKey.DEFAULT_SCOPE);
        loader.addMetaData(QualifiersMdrUtil.OPTIONAL_QUALIFIER_KEY, Collections.singleton("test"), Set.class);
        this.getMetaDataRepository().getMetaDataRepository().addMetaDataRetrieval((MetaDataRetrieval)loader);
        BeanMetaDataBuilder bean1Builder = BeanMetaDataBuilder.createBuilder((String)"bean1", (String)Bean.class.getName());
        bean1Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"other"});
        KernelControllerContext bean1Context = this.deploy(bean1Builder.getBeanMetaData());
        BeanMetaDataBuilder bean2Builder = BeanMetaDataBuilder.createBuilder((String)"bean2", (String)Bean.class.getName());
        bean2Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"else"});
        KernelControllerContext bean2Context = this.deploy(bean2Builder.getBeanMetaData());
        BeanMetaDataBuilder targetBuilder = BeanMetaDataBuilder.createBuilder((String)"target", (String)TargetBean.class.getName());
        targetBuilder.setAutowireType(AutowireType.BY_CLASS);
        targetBuilder.addQualifiers(QualifierType.REQUIRED, new Object[]{"other"});
        KernelControllerContext targetContext = this.deploy(targetBuilder.getBeanMetaData());
        try {
            Bean bean1 = (Bean)this.assertBean("bean1", Bean.class);
            this.assertBean("bean2", Bean.class);
            TargetBean target = (TargetBean)this.assertBean("target", TargetBean.class);
            BeanQualifiersTestCase.assertNotNull((Object)target.getBean());
            BeanQualifiersTestCase.assertSame((Object)bean1, (Object)target.getBean());
        }
        finally {
            this.undeploy(bean1Context);
            this.undeploy(bean2Context);
            this.undeploy(targetContext);
            this.getMetaDataRepository().getMetaDataRepository().removeMetaDataRetrieval(ScopeKey.DEFAULT_SCOPE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOptionalQualifiersFromHigherLevelResolvingInstanceAmbiguity() throws Throwable {
        MemoryMetaDataLoader loader = new MemoryMetaDataLoader(ScopeKey.DEFAULT_SCOPE);
        QualifiersMdrUtil.addQualifiersToMdrRetrieval((MetaDataRetrieval)loader, (QualifierType)QualifierType.OPTIONAL, null, (Object[])new Object[]{"test"});
        this.getMetaDataRepository().getMetaDataRepository().addMetaDataRetrieval((MetaDataRetrieval)loader);
        BeanMetaDataBuilder bean1Builder = BeanMetaDataBuilder.createBuilder((String)"bean1", (String)Bean.class.getName());
        bean1Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"other", "test"});
        KernelControllerContext bean1Context = this.deploy(bean1Builder.getBeanMetaData());
        BeanMetaDataBuilder bean2Builder = BeanMetaDataBuilder.createBuilder((String)"bean2", (String)Bean.class.getName());
        bean2Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"other"});
        KernelControllerContext bean2Context = this.deploy(bean2Builder.getBeanMetaData());
        BeanMetaDataBuilder targetBuilder = BeanMetaDataBuilder.createBuilder((String)"target", (String)TargetBean.class.getName());
        targetBuilder.setAutowireType(AutowireType.BY_CLASS);
        targetBuilder.addQualifiers(QualifierType.REQUIRED, new Object[]{"other"});
        KernelControllerContext targetContext = this.deploy(targetBuilder.getBeanMetaData());
        try {
            Bean bean1 = (Bean)this.assertBean("bean1", Bean.class);
            this.assertBean("bean2", Bean.class);
            TargetBean target = (TargetBean)this.assertBean("target", TargetBean.class);
            BeanQualifiersTestCase.assertNotNull((Object)target.getBean());
            BeanQualifiersTestCase.assertSame((Object)bean1, (Object)target.getBean());
        }
        finally {
            this.undeploy(bean1Context);
            this.undeploy(bean2Context);
            this.undeploy(targetContext);
            this.getMetaDataRepository().getMetaDataRepository().removeMetaDataRetrieval(ScopeKey.DEFAULT_SCOPE);
        }
    }

    public void testCustomMatcherAndParser() throws Throwable {
        this.testCustomMatcherAndParser(false, false);
        QualifierMatchers.getInstance().addParser((QualifierParser)TestMatcherAndParser.INSTANCE);
        this.testCustomMatcherAndParser(true, false);
        QualifierMatchers.getInstance().addMatcher((QualifierMatcher)TestMatcherAndParser.INSTANCE);
        this.testCustomMatcherAndParser(true, true);
        QualifierMatchers.getInstance().removeParser(TestMatcherAndParser.INSTANCE.getHandledContent());
        this.testCustomMatcherAndParser(false, true);
        QualifierMatchers.getInstance().removeMatcher(TestMatcherAndParser.INSTANCE.getHandledType());
        this.testCustomMatcherAndParser(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCustomMatcherAndParser(boolean hasParser, boolean hasMatcher) throws Throwable {
        BeanMetaDataBuilder bean1Builder = BeanMetaDataBuilder.createBuilder((String)"bean1", (String)Bean.class.getName());
        bean1Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test"});
        bean1Builder.addQualifiers(QualifierType.SUPPLIED, QualifierContent.getContent((String)"Test"), null, new Object[]{"Hello-xxx"});
        KernelControllerContext bean1Context = this.deploy(bean1Builder.getBeanMetaData());
        BeanMetaDataBuilder bean2Builder = BeanMetaDataBuilder.createBuilder((String)"bean2", (String)Bean.class.getName());
        bean2Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test"});
        KernelControllerContext bean2Context = this.deploy(bean2Builder.getBeanMetaData());
        BeanMetaDataBuilder bean3Builder = BeanMetaDataBuilder.createBuilder((String)"bean3", (String)Bean.class.getName());
        bean3Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test"});
        bean3Builder.addQualifiers(QualifierType.SUPPLIED, QualifierContent.getContent((String)"Test"), null, new Object[]{"Hola-xxx"});
        KernelControllerContext bean3Context = this.deploy(bean3Builder.getBeanMetaData());
        BeanMetaDataBuilder targetBuilder = BeanMetaDataBuilder.createBuilder((String)"target", (String)TargetBean.class.getName());
        targetBuilder.setAutowireType(AutowireType.BY_CLASS);
        targetBuilder.addQualifiers(QualifierType.REQUIRED, new Object[]{"test"});
        targetBuilder.addQualifiers(QualifierType.REQUIRED, QualifierContent.getContent((String)"Test"), null, new Object[]{"xxx-Hola"});
        KernelControllerContext targetContext = this.deploy(targetBuilder.getBeanMetaData());
        try {
            if (hasParser) {
                this.assertBean("bean1", Bean.class);
                this.assertBean("bean2", Bean.class);
                Bean bean3 = (Bean)this.assertBean("bean3", Bean.class);
                if (hasMatcher) {
                    TargetBean target = (TargetBean)this.assertBean("target", TargetBean.class);
                    BeanQualifiersTestCase.assertNotNull((Object)target.getBean());
                    BeanQualifiersTestCase.assertSame((Object)bean3, (Object)target.getBean());
                } else {
                    this.assertNoBean("target");
                }
            } else {
                this.assertNoBean("bean1");
                this.assertBean("bean2", Bean.class);
                this.assertNoBean("bean3");
                this.assertNoBean("target");
            }
        }
        finally {
            this.undeploy(bean1Context);
            this.undeploy(bean2Context);
            this.undeploy(bean3Context);
            this.undeploy(targetContext);
            this.getMetaDataRepository().getMetaDataRepository().removeMetaDataRetrieval(ScopeKey.DEFAULT_SCOPE);
        }
    }

    private Annotation getAnnotation(Class<? extends Annotation> clazz) throws Exception {
        return (Annotation)AnnotationCreator.createAnnotation((String)("@" + clazz.getName()), clazz);
    }
}

