/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.qualifiers.test;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import junit.framework.Test;
import org.jboss.annotation.factory.AnnotationCreator;
import org.jboss.beans.info.spi.BeanAccessMode;
import org.jboss.beans.metadata.api.model.QualifierContent;
import org.jboss.beans.metadata.api.model.QualifierPoint;
import org.jboss.beans.metadata.api.model.QualifierType;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractBeanQualifierMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.qualifier.QualifierMatcher;
import org.jboss.kernel.spi.qualifier.QualifierMatchers;
import org.jboss.kernel.spi.qualifier.QualifierParser;
import org.jboss.test.kernel.junit.MicrocontainerTest;
import org.jboss.test.kernel.qualifiers.support.Bean;
import org.jboss.test.kernel.qualifiers.support.Target;
import org.jboss.test.kernel.qualifiers.support.TargetAllBean;
import org.jboss.test.kernel.qualifiers.support.TargetAllBeanWithField;
import org.jboss.test.kernel.qualifiers.support.TargetConstructorBean;
import org.jboss.test.kernel.qualifiers.support.TargetFieldBean;
import org.jboss.test.kernel.qualifiers.support.TargetMethodBean;
import org.jboss.test.kernel.qualifiers.support.TargetPropertyBean;
import org.jboss.test.kernel.qualifiers.support.TestMatcherAndParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectionPointQualifiersTestCase
extends MicrocontainerTest {
    public InjectionPointQualifiersTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        return InjectionPointQualifiersTestCase.suite(InjectionPointQualifiersTestCase.class);
    }

    public void testSimplePropertyQualifiers() throws Throwable {
        this.testSimpleQualifiers(TargetPropertyBean.class);
    }

    public void testSimpleFieldQualifiers() throws Throwable {
        this.testSimpleQualifiers(TargetFieldBean.class);
    }

    public void testSimpleConstructorParameterQualifiers() throws Throwable {
        this.testSimpleQualifiers(TargetConstructorBean.class);
    }

    public void testSimpleInstallMethodParameterQualifiers() throws Throwable {
        this.testSimpleQualifiers(TargetMethodBean.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Target> void testSimpleQualifiers(Class<T> targetClass) throws Throwable {
        BeanMetaDataBuilder bean1Builder = BeanMetaDataBuilder.createBuilder((String)"bean1", (String)Bean.class.getName());
        bean1Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test"});
        KernelControllerContext bean1Context = this.deploy(bean1Builder.getBeanMetaData());
        BeanMetaDataBuilder bean2Builder = BeanMetaDataBuilder.createBuilder((String)"bean2", (String)Bean.class.getName());
        KernelControllerContext bean2Context = this.deploy(bean2Builder.getBeanMetaData());
        KernelControllerContext targetContext = this.deploy(this.createTargetMetaData(targetClass, "test"));
        try {
            Bean bean1 = (Bean)this.assertBean("bean1", Bean.class);
            this.assertBean("bean2", Bean.class);
            Target target = (Target)this.assertBean("target", targetClass);
            InjectionPointQualifiersTestCase.assertNotNull((Object)target.getBean());
            InjectionPointQualifiersTestCase.assertSame((Object)bean1, (Object)target.getBean());
        }
        finally {
            this.undeploy(bean1Context);
            this.undeploy(bean2Context);
            this.undeploy(targetContext);
        }
    }

    public void testAnnotationObjectPropertyQualifiers() throws Throwable {
        this.testAnnotationObjectQualifiers(TargetPropertyBean.class);
    }

    public void testAnnotationObjectFieldQualifiers() throws Throwable {
        this.testAnnotationObjectQualifiers(TargetFieldBean.class);
    }

    public void testAnnotationObjectConstructorParameterQualifiers() throws Throwable {
        this.testAnnotationObjectQualifiers(TargetConstructorBean.class);
    }

    public void testAnnotationObjectInstallMethodParameterQualifiers() throws Throwable {
        this.testAnnotationObjectQualifiers(TargetMethodBean.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Target> void testAnnotationObjectQualifiers(Class<T> targetClass) throws Throwable {
        BeanMetaDataBuilder bean1Builder = BeanMetaDataBuilder.createBuilder((String)"bean1", (String)Bean.class.getName());
        bean1Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{this.getAnnotation(Override.class)});
        KernelControllerContext bean1Context = this.deploy(bean1Builder.getBeanMetaData());
        BeanMetaDataBuilder bean2Builder = BeanMetaDataBuilder.createBuilder((String)"bean2", (String)Bean.class.getName());
        KernelControllerContext bean2Context = this.deploy(bean2Builder.getBeanMetaData());
        KernelControllerContext targetContext = this.deploy(this.createTargetMetaData(targetClass, this.getAnnotation(Override.class)));
        try {
            Bean bean1 = (Bean)this.assertBean("bean1", Bean.class);
            this.assertBean("bean2", Bean.class);
            Target target = (Target)this.assertBean("target", targetClass);
            InjectionPointQualifiersTestCase.assertNotNull((Object)target.getBean());
            InjectionPointQualifiersTestCase.assertSame((Object)bean1, (Object)target.getBean());
        }
        finally {
            this.undeploy(bean1Context);
            this.undeploy(bean2Context);
            this.undeploy(targetContext);
        }
    }

    public void testAnnotationContentPropertyQualifiers() throws Throwable {
        this.testAnnotationContentQualifiers(TargetPropertyBean.class);
    }

    public void testAnnotationContentFieldQualifiers() throws Throwable {
        this.testAnnotationContentQualifiers(TargetFieldBean.class);
    }

    public void testAnnotationContentConstructorParameterQualifiers() throws Throwable {
        this.testAnnotationContentQualifiers(TargetConstructorBean.class);
    }

    public void testAnnotationContentInstallMethodParameterQualifiers() throws Throwable {
        this.testAnnotationContentQualifiers(TargetMethodBean.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Target> void testAnnotationContentQualifiers(Class<T> targetClass) throws Throwable {
        BeanMetaDataBuilder bean1Builder = BeanMetaDataBuilder.createBuilder((String)"bean1", (String)Bean.class.getName());
        AbstractBeanQualifierMetaData beanQualifier = new AbstractBeanQualifierMetaData();
        beanQualifier.setType(QualifierType.SUPPLIED);
        beanQualifier.setContent(QualifierContent.ANNOTATION);
        HashSet<String> enableds = new HashSet<String>();
        enableds.add("@" + Override.class.getName());
        beanQualifier.setEnabled(enableds);
        HashSet<AbstractBeanQualifierMetaData> qualifiers = new HashSet<AbstractBeanQualifierMetaData>();
        qualifiers.add(beanQualifier);
        ((AbstractBeanMetaData)bean1Builder.getBeanMetaData()).setRelated(qualifiers);
        KernelControllerContext bean1Context = this.deploy(bean1Builder.getBeanMetaData());
        BeanMetaDataBuilder bean2Builder = BeanMetaDataBuilder.createBuilder((String)"bean2", (String)Bean.class.getName());
        KernelControllerContext bean2Context = this.deploy(bean2Builder.getBeanMetaData());
        KernelControllerContext targetContext = this.deploy(this.createTargetMetaData(targetClass, false, QualifierContent.ANNOTATION, new Object[]{"@" + Override.class.getName()}));
        try {
            Bean bean1 = (Bean)this.assertBean("bean1", Bean.class);
            this.assertBean("bean2", Bean.class);
            Target target = (Target)this.assertBean("target", targetClass);
            InjectionPointQualifiersTestCase.assertNotNull((Object)target.getBean());
            InjectionPointQualifiersTestCase.assertSame((Object)bean1, (Object)target.getBean());
        }
        finally {
            this.undeploy(bean1Context);
            this.undeploy(bean2Context);
            this.undeploy(targetContext);
        }
    }

    public void testNeedsAllPropertyQualifiers() throws Throwable {
        this.testNeedsAllQualifiers(TargetPropertyBean.class);
    }

    public void testNeedsAllFieldQualifiers() throws Throwable {
        this.testNeedsAllQualifiers(TargetFieldBean.class);
    }

    public void testNeedsAllConstructorQualifiers() throws Throwable {
        this.testNeedsAllQualifiers(TargetConstructorBean.class);
    }

    public void testNeedsAllMethodParameterQualifiers() throws Throwable {
        this.testNeedsAllQualifiers(TargetMethodBean.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Target> void testNeedsAllQualifiers(Class<T> targetClass) throws Throwable {
        BeanMetaDataBuilder bean1Builder = BeanMetaDataBuilder.createBuilder((String)"bean1", (String)Bean.class.getName());
        bean1Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test1", "test2"});
        KernelControllerContext bean1Context = this.deploy(bean1Builder.getBeanMetaData());
        BeanMetaDataBuilder bean2Builder = BeanMetaDataBuilder.createBuilder((String)"bean2", (String)Bean.class.getName());
        bean2Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test1", "test3", "test2"});
        KernelControllerContext bean2Context = this.deploy(bean2Builder.getBeanMetaData());
        BeanMetaDataBuilder bean3Builder = BeanMetaDataBuilder.createBuilder((String)"bean3", (String)Bean.class.getName());
        bean3Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test2", "test3"});
        KernelControllerContext bean3Context = this.deploy(bean3Builder.getBeanMetaData());
        KernelControllerContext targetContext = this.deploy(this.createTargetMetaData(targetClass, "test1", "test2", "test3"));
        try {
            this.assertBean("bean1", Bean.class);
            Bean bean2 = (Bean)this.assertBean("bean2", Bean.class);
            this.assertBean("bean3", Bean.class);
            Target target = (Target)this.assertBean("target", targetClass);
            InjectionPointQualifiersTestCase.assertNotNull((Object)target.getBean());
            InjectionPointQualifiersTestCase.assertSame((Object)bean2, (Object)target.getBean());
        }
        finally {
            this.undeploy(bean1Context);
            this.undeploy(bean2Context);
            this.undeploy(bean3Context);
            this.undeploy(targetContext);
        }
    }

    public void testNoContextHasAllPropertyQualifiers() throws Throwable {
        this.testNoContextHasAllQualifiers(TargetPropertyBean.class);
    }

    public void testNoContextHasAllFieldQualifiers() throws Throwable {
        this.testNoContextHasAllQualifiers(TargetFieldBean.class);
    }

    public void testNoContextHasAllConstructorQualifiers() throws Throwable {
        this.testNoContextHasAllQualifiers(TargetConstructorBean.class);
    }

    public void testNoContextHasAllMethodParameterQualifiers() throws Throwable {
        this.testNoContextHasAllQualifiers(TargetMethodBean.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Target> void testNoContextHasAllQualifiers(Class<T> targetClass) throws Throwable {
        BeanMetaDataBuilder bean1Builder = BeanMetaDataBuilder.createBuilder((String)"bean1", (String)Bean.class.getName());
        bean1Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test"});
        KernelControllerContext bean1Context = this.deploy(bean1Builder.getBeanMetaData());
        BeanMetaDataBuilder bean2Builder = BeanMetaDataBuilder.createBuilder((String)"bean2", (String)Bean.class.getName());
        bean2Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"other"});
        KernelControllerContext bean2Context = this.deploy(bean2Builder.getBeanMetaData());
        KernelControllerContext targetContext = this.deploy(this.createTargetMetaData(targetClass, "test", "other"));
        try {
            this.assertBean("bean1", Bean.class);
            this.assertBean("bean2", Bean.class);
            this.assertNoBean("target");
        }
        finally {
            this.undeploy(bean1Context);
            this.undeploy(bean2Context);
            this.undeploy(targetContext);
        }
    }

    public void testTwoContextsHaveAllRequiredPropertyQualifiers() throws Throwable {
        this.testTwoContextsHaveAllRequiredQualifiers(TargetPropertyBean.class, TargetType.PROPERTY);
    }

    public void testTwoContextsHaveAllRequiredFieldQualifiers() throws Throwable {
        this.testTwoContextsHaveAllRequiredQualifiers(TargetFieldBean.class, TargetType.PROPERTY);
    }

    public void testTwoContextsHaveAllRequiredConstructorQualifiers() throws Throwable {
        this.testTwoContextsHaveAllRequiredQualifiers(TargetConstructorBean.class, TargetType.CONSTRUCTOR);
    }

    public void testTwoContextsHaveAllRequiredMethodParameterQualifiers() throws Throwable {
        this.testTwoContextsHaveAllRequiredQualifiers(TargetMethodBean.class, TargetType.METHOD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Target> void testTwoContextsHaveAllRequiredQualifiers(Class<T> targetClass, TargetType type) throws Throwable {
        BeanMetaDataBuilder bean1Builder = BeanMetaDataBuilder.createBuilder((String)"bean1", (String)Bean.class.getName());
        bean1Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test1", "test2"});
        KernelControllerContext bean1Context = this.deploy(bean1Builder.getBeanMetaData());
        BeanMetaDataBuilder bean2Builder = BeanMetaDataBuilder.createBuilder((String)"bean2", (String)Bean.class.getName());
        bean2Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test1", "test2"});
        KernelControllerContext bean2Context = this.deploy(bean2Builder.getBeanMetaData());
        KernelControllerContext targetContext = this.deploy(this.createTargetMetaData(targetClass, "test1", "test2"));
        try {
            this.assertBean("bean1", Bean.class);
            this.assertBean("bean2", Bean.class);
            this.assertNoBean("target");
        }
        finally {
            this.undeploy(bean1Context);
            this.undeploy(bean2Context);
            this.undeploy(targetContext);
        }
    }

    public void testTwoContextsHaveMoreThanRequiredPropertyQualifiers() throws Throwable {
        this.testTwoContextsHaveMoreThanRequiredQualifiers(TargetPropertyBean.class);
    }

    public void testTwoContextsHaveMoreThanRequiredFieldQualifiers() throws Throwable {
        this.testTwoContextsHaveMoreThanRequiredQualifiers(TargetFieldBean.class);
    }

    public void testTwoContextsHaveMoreThanRequiredConstructorQualifiers() throws Throwable {
        this.testTwoContextsHaveMoreThanRequiredQualifiers(TargetConstructorBean.class);
    }

    public void testTwoContextsHaveMoreThanRequiredMethodParameterQualifiers() throws Throwable {
        this.testTwoContextsHaveMoreThanRequiredQualifiers(TargetMethodBean.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Target> void testTwoContextsHaveMoreThanRequiredQualifiers(Class<T> targetClass) throws Throwable {
        BeanMetaDataBuilder bean1Builder = BeanMetaDataBuilder.createBuilder((String)"bean1", (String)Bean.class.getName());
        bean1Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test1", "test2", "extra1"});
        KernelControllerContext bean1Context = this.deploy(bean1Builder.getBeanMetaData());
        BeanMetaDataBuilder bean2Builder = BeanMetaDataBuilder.createBuilder((String)"bean2", (String)Bean.class.getName());
        bean2Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test1", "test2", "extra2"});
        KernelControllerContext bean2Context = this.deploy(bean2Builder.getBeanMetaData());
        KernelControllerContext targetContext = this.deploy(this.createTargetMetaData(targetClass, "test1", "test2"));
        try {
            this.assertBean("bean1", Bean.class);
            this.assertBean("bean2", Bean.class);
            this.assertNoBean("target");
        }
        finally {
            this.undeploy(bean1Context);
            this.undeploy(bean2Context);
            this.undeploy(targetContext);
        }
    }

    public void testBeanRequiredQualifiersNotIgnoredByDefaultForProperty() throws Throwable {
        this.testBeanRequiredQualifiersNotIgnoredByDefault(TargetPropertyBean.class);
    }

    public void testBeanRequiredQualifiersNotIgnoredByDefaultForField() throws Throwable {
        this.testBeanRequiredQualifiersNotIgnoredByDefault(TargetFieldBean.class);
    }

    public void testBeanRequiredQualifiersNotIgnoredByDefaultForConstructor() throws Throwable {
        this.testBeanRequiredQualifiersNotIgnoredByDefault(TargetConstructorBean.class);
    }

    public void testBeanRequiredQualifiersNotIgnoredByDefaultForMethod() throws Throwable {
        this.testBeanRequiredQualifiersNotIgnoredByDefault(TargetMethodBean.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Target> void testBeanRequiredQualifiersNotIgnoredByDefault(Class<T> targetClass) throws Throwable {
        BeanMetaDataBuilder bean1Builder = BeanMetaDataBuilder.createBuilder((String)"bean1", (String)Bean.class.getName());
        bean1Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test", "notignored"});
        KernelControllerContext bean1Context = this.deploy(bean1Builder.getBeanMetaData());
        BeanMetaDataBuilder bean2Builder = BeanMetaDataBuilder.createBuilder((String)"bean2", (String)Bean.class.getName());
        bean2Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test"});
        KernelControllerContext bean2Context = this.deploy(bean2Builder.getBeanMetaData());
        KernelControllerContext targetContext = this.deploy(this.addRequiredQualifiersAtBeanLevel(this.createTargetMetaData(targetClass, "test"), "notignored"));
        try {
            Bean bean1 = (Bean)this.assertBean("bean1", Bean.class);
            this.assertBean("bean2", Bean.class);
            Target target = (Target)this.assertBean("target", targetClass);
            InjectionPointQualifiersTestCase.assertNotNull((Object)target.getBean());
            InjectionPointQualifiersTestCase.assertSame((Object)bean1, (Object)target.getBean());
        }
        finally {
            this.undeploy(bean1Context);
            this.undeploy(bean2Context);
            this.undeploy(targetContext);
        }
    }

    public void testBeanOptionalQualifiersNotIgnoredByDefaultForProperty() throws Throwable {
        this.testBeanOptionalQualifiersNotIgnoredByDefault(TargetPropertyBean.class);
    }

    public void testBeanOptionalQualifiersNotIgnoredByDefaultForField() throws Throwable {
        this.testBeanOptionalQualifiersNotIgnoredByDefault(TargetFieldBean.class);
    }

    public void testBeanOptionalQualifiersNotIgnoredByDefaultForConstructor() throws Throwable {
        this.testBeanOptionalQualifiersNotIgnoredByDefault(TargetConstructorBean.class);
    }

    public void testBeanOptionalQualifiersNotIgnoredByDefaultForMethod() throws Throwable {
        this.testBeanOptionalQualifiersNotIgnoredByDefault(TargetMethodBean.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Target> void testBeanOptionalQualifiersNotIgnoredByDefault(Class<T> targetClass) throws Throwable {
        BeanMetaDataBuilder bean1Builder = BeanMetaDataBuilder.createBuilder((String)"bean1", (String)Bean.class.getName());
        bean1Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test", "notignored"});
        KernelControllerContext bean1Context = this.deploy(bean1Builder.getBeanMetaData());
        BeanMetaDataBuilder bean2Builder = BeanMetaDataBuilder.createBuilder((String)"bean2", (String)Bean.class.getName());
        bean2Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test"});
        KernelControllerContext bean2Context = this.deploy(bean2Builder.getBeanMetaData());
        KernelControllerContext targetContext = this.deploy(this.addOptionalQualifiersAtBeanLevel(this.createTargetMetaData(targetClass, "test"), "notignored"));
        try {
            Bean bean1 = (Bean)this.assertBean("bean1", Bean.class);
            this.assertBean("bean2", Bean.class);
            Target target = (Target)this.assertBean("target", targetClass);
            InjectionPointQualifiersTestCase.assertNotNull((Object)target.getBean());
            InjectionPointQualifiersTestCase.assertSame((Object)bean1, (Object)target.getBean());
        }
        finally {
            this.undeploy(bean1Context);
            this.undeploy(bean2Context);
            this.undeploy(targetContext);
        }
    }

    public void testBeanRequiredQualifiersIgnoredForProperty() throws Throwable {
        this.testBeanRequiredQualifiersIgnored(TargetPropertyBean.class);
    }

    public void testBeanRequiredQualifiersIgnoredForField() throws Throwable {
        this.testBeanRequiredQualifiersIgnored(TargetFieldBean.class);
    }

    public void testBeanRequiredQualifiersIgnoredForConstructor() throws Throwable {
        this.testBeanRequiredQualifiersIgnored(TargetConstructorBean.class);
    }

    public void testBeanRequiredQualifiersIgnoredForMethod() throws Throwable {
        this.testBeanRequiredQualifiersIgnored(TargetMethodBean.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Target> void testBeanRequiredQualifiersIgnored(Class<T> targetClass) throws Throwable {
        BeanMetaDataBuilder bean1Builder = BeanMetaDataBuilder.createBuilder((String)"bean1", (String)Bean.class.getName());
        bean1Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test"});
        KernelControllerContext bean1Context = this.deploy(bean1Builder.getBeanMetaData());
        BeanMetaDataBuilder bean2Builder = BeanMetaDataBuilder.createBuilder((String)"bean2", (String)Bean.class.getName());
        bean2Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"ignored"});
        KernelControllerContext bean2Context = this.deploy(bean2Builder.getBeanMetaData());
        KernelControllerContext targetContext = this.deploy(this.addRequiredQualifiersAtBeanLevel(this.createTargetMetaData(targetClass, true, new Object[]{"test"}), "ignored"));
        try {
            Bean bean1 = (Bean)this.assertBean("bean1", Bean.class);
            this.assertBean("bean2", Bean.class);
            Target target = (Target)this.assertBean("target", targetClass);
            InjectionPointQualifiersTestCase.assertNotNull((Object)target.getBean());
            InjectionPointQualifiersTestCase.assertSame((Object)bean1, (Object)target.getBean());
        }
        finally {
            this.undeploy(bean1Context);
            this.undeploy(bean2Context);
            this.undeploy(targetContext);
        }
    }

    public void testBeanOptionalQualifiersIgnoredForField() throws Throwable {
        this.testBeanOptionalQualifiersIgnored(TargetFieldBean.class);
    }

    public void testBeanOptionalQualifiersIgnoredForProperty() throws Throwable {
        this.testBeanOptionalQualifiersIgnored(TargetPropertyBean.class);
    }

    public void testBeanOptionalQualifiersIgnoredForConstructor() throws Throwable {
        this.testBeanOptionalQualifiersIgnored(TargetConstructorBean.class);
    }

    public void testBeanOptionalQualifiersIgnoredForMethod() throws Throwable {
        this.testBeanOptionalQualifiersIgnored(TargetMethodBean.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Target> void testBeanOptionalQualifiersIgnored(Class<T> targetClass) throws Throwable {
        BeanMetaDataBuilder bean1Builder = BeanMetaDataBuilder.createBuilder((String)"bean1", (String)Bean.class.getName());
        bean1Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test", "ignored"});
        KernelControllerContext bean1Context = this.deploy(bean1Builder.getBeanMetaData());
        BeanMetaDataBuilder bean2Builder = BeanMetaDataBuilder.createBuilder((String)"bean2", (String)Bean.class.getName());
        bean2Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test"});
        KernelControllerContext bean2Context = this.deploy(bean2Builder.getBeanMetaData());
        KernelControllerContext targetContext = this.deploy(this.addOptionalQualifiersAtBeanLevel(this.createTargetMetaData(targetClass, true, new Object[]{"test"}), "ignored"));
        try {
            this.assertBean("bean1", Bean.class);
            this.assertBean("bean2", Bean.class);
            this.assertNoBean("target");
        }
        finally {
            this.undeploy(bean1Context);
            this.undeploy(bean2Context);
            this.undeploy(targetContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRequiredQualifierPoints() throws Throwable {
        BeanMetaDataBuilder bean1Builder = BeanMetaDataBuilder.createBuilder((String)"bean1", (String)Bean.class.getName());
        bean1Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test", "all", "constructor"});
        KernelControllerContext bean1Context = this.deploy(bean1Builder.getBeanMetaData());
        BeanMetaDataBuilder bean2Builder = BeanMetaDataBuilder.createBuilder((String)"bean2", (String)Bean.class.getName());
        bean2Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test", "all", "method"});
        KernelControllerContext bean2Context = this.deploy(bean2Builder.getBeanMetaData());
        BeanMetaDataBuilder bean3Builder = BeanMetaDataBuilder.createBuilder((String)"bean3", (String)Bean.class.getName());
        bean3Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test", "all", "property"});
        KernelControllerContext bean3Context = this.deploy(bean3Builder.getBeanMetaData());
        BeanMetaDataBuilder targetBuilder = BeanMetaDataBuilder.createBuilder((String)"target", (String)TargetAllBean.class.getName());
        targetBuilder.addPropertyMetaData("fieldBean", targetBuilder.addQualifiersToContextualInject(targetBuilder.createContextualInject(), new Object[]{"test"}));
        targetBuilder.addConstructorParameter(Bean.class.getName(), targetBuilder.addQualifiersToContextualInject(targetBuilder.createContextualInject(), new Object[]{"test"}));
        targetBuilder.addInstall("installBean", Bean.class.getName(), targetBuilder.addQualifiersToContextualInject(targetBuilder.createContextualInject(), new Object[]{"test"}));
        targetBuilder.addQualifiers(QualifierType.REQUIRED, new Object[]{"all"});
        targetBuilder.addQualifiers(QualifierType.REQUIRED, Arrays.asList(QualifierPoint.CONSTRUCTOR), new Object[]{"constructor"});
        targetBuilder.addQualifiers(QualifierType.REQUIRED, Arrays.asList(QualifierPoint.METHOD), new Object[]{"method"});
        targetBuilder.addQualifiers(QualifierType.REQUIRED, Arrays.asList(QualifierPoint.PROPERTY), new Object[]{"property"});
        KernelControllerContext targetContext = this.deploy(targetBuilder.getBeanMetaData());
        try {
            Bean bean1 = (Bean)this.assertBean("bean1", Bean.class);
            Bean bean2 = (Bean)this.assertBean("bean2", Bean.class);
            Bean bean3 = (Bean)this.assertBean("bean3", Bean.class);
            TargetAllBean target = (TargetAllBean)this.assertBean("target", TargetAllBean.class);
            InjectionPointQualifiersTestCase.assertNotNull((Object)target.getConstructorBean());
            InjectionPointQualifiersTestCase.assertEquals((Object)bean1, (Object)target.getConstructorBean());
            InjectionPointQualifiersTestCase.assertNotNull((Object)target.getMethodBean());
            InjectionPointQualifiersTestCase.assertEquals((Object)bean2, (Object)target.getMethodBean());
            InjectionPointQualifiersTestCase.assertNotNull((Object)target.getFieldBean());
            InjectionPointQualifiersTestCase.assertEquals((Object)bean3, (Object)target.getFieldBean());
        }
        finally {
            this.undeploy(targetContext);
            this.undeploy(bean3Context);
            this.undeploy(bean2Context);
            this.undeploy(bean1Context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRequiredQualifierPointsForField() throws Throwable {
        BeanMetaDataBuilder bean1Builder = BeanMetaDataBuilder.createBuilder((String)"bean1", (String)Bean.class.getName());
        bean1Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test", "all", "constructor"});
        KernelControllerContext bean1Context = this.deploy(bean1Builder.getBeanMetaData());
        BeanMetaDataBuilder bean2Builder = BeanMetaDataBuilder.createBuilder((String)"bean2", (String)Bean.class.getName());
        bean2Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test", "all", "method"});
        KernelControllerContext bean2Context = this.deploy(bean2Builder.getBeanMetaData());
        BeanMetaDataBuilder bean3Builder = BeanMetaDataBuilder.createBuilder((String)"bean3", (String)Bean.class.getName());
        bean3Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test", "all", "property"});
        KernelControllerContext bean3Context = this.deploy(bean3Builder.getBeanMetaData());
        BeanMetaDataBuilder targetBuilder = BeanMetaDataBuilder.createBuilder((String)"target", (String)TargetAllBeanWithField.class.getName());
        targetBuilder.setAccessMode(BeanAccessMode.ALL);
        targetBuilder.addPropertyMetaData("fieldBean", targetBuilder.addQualifiersToContextualInject(targetBuilder.createContextualInject(), new Object[]{"test"}));
        targetBuilder.addConstructorParameter(Bean.class.getName(), targetBuilder.addQualifiersToContextualInject(targetBuilder.createContextualInject(), new Object[]{"test"}));
        targetBuilder.addInstall("installBean", Bean.class.getName(), targetBuilder.addQualifiersToContextualInject(targetBuilder.createContextualInject(), new Object[]{"test"}));
        targetBuilder.addQualifiers(QualifierType.REQUIRED, new Object[]{"all"});
        targetBuilder.addQualifiers(QualifierType.REQUIRED, Arrays.asList(QualifierPoint.CONSTRUCTOR), new Object[]{"constructor"});
        targetBuilder.addQualifiers(QualifierType.REQUIRED, Arrays.asList(QualifierPoint.METHOD), new Object[]{"method"});
        targetBuilder.addQualifiers(QualifierType.REQUIRED, Arrays.asList(QualifierPoint.PROPERTY), new Object[]{"property"});
        KernelControllerContext targetContext = this.deploy(targetBuilder.getBeanMetaData());
        try {
            Bean bean1 = (Bean)this.assertBean("bean1", Bean.class);
            Bean bean2 = (Bean)this.assertBean("bean2", Bean.class);
            Bean bean3 = (Bean)this.assertBean("bean3", Bean.class);
            TargetAllBeanWithField target = (TargetAllBeanWithField)this.assertBean("target", TargetAllBeanWithField.class);
            InjectionPointQualifiersTestCase.assertNotNull((Object)target.getConstructorBean());
            InjectionPointQualifiersTestCase.assertEquals((Object)bean1, (Object)target.getConstructorBean());
            InjectionPointQualifiersTestCase.assertNotNull((Object)target.getMethodBean());
            InjectionPointQualifiersTestCase.assertEquals((Object)bean2, (Object)target.getMethodBean());
            InjectionPointQualifiersTestCase.assertNotNull((Object)target.getFieldBean());
            InjectionPointQualifiersTestCase.assertEquals((Object)bean3, (Object)target.getFieldBean());
        }
        finally {
            this.undeploy(targetContext);
            this.undeploy(bean3Context);
            this.undeploy(bean2Context);
            this.undeploy(bean1Context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOptionalQualifierPoints() throws Throwable {
        BeanMetaDataBuilder bean1Builder = BeanMetaDataBuilder.createBuilder((String)"bean1", (String)Bean.class.getName());
        bean1Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test", "all", "constructor"});
        KernelControllerContext bean1Context = this.deploy(bean1Builder.getBeanMetaData());
        BeanMetaDataBuilder bean2Builder = BeanMetaDataBuilder.createBuilder((String)"bean2", (String)Bean.class.getName());
        bean2Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test", "all", "method"});
        KernelControllerContext bean2Context = this.deploy(bean2Builder.getBeanMetaData());
        BeanMetaDataBuilder bean3Builder = BeanMetaDataBuilder.createBuilder((String)"bean3", (String)Bean.class.getName());
        bean3Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test", "all", "property"});
        KernelControllerContext bean3Context = this.deploy(bean3Builder.getBeanMetaData());
        BeanMetaDataBuilder targetBuilder = BeanMetaDataBuilder.createBuilder((String)"target", (String)TargetAllBean.class.getName());
        targetBuilder.addPropertyMetaData("fieldBean", targetBuilder.addQualifiersToContextualInject(targetBuilder.createContextualInject(), new Object[]{"test"}));
        targetBuilder.addConstructorParameter(Bean.class.getName(), targetBuilder.addQualifiersToContextualInject(targetBuilder.createContextualInject(), new Object[]{"test"}));
        targetBuilder.addInstall("installBean", Bean.class.getName(), targetBuilder.addQualifiersToContextualInject(targetBuilder.createContextualInject(), new Object[]{"test"}));
        targetBuilder.addQualifiers(QualifierType.OPTIONAL, new Object[]{"all"});
        targetBuilder.addQualifiers(QualifierType.OPTIONAL, Arrays.asList(QualifierPoint.CONSTRUCTOR), new Object[]{"constructor"});
        targetBuilder.addQualifiers(QualifierType.OPTIONAL, Arrays.asList(QualifierPoint.METHOD), new Object[]{"method"});
        targetBuilder.addQualifiers(QualifierType.OPTIONAL, Arrays.asList(QualifierPoint.PROPERTY), new Object[]{"property"});
        KernelControllerContext targetContext = this.deploy(targetBuilder.getBeanMetaData());
        try {
            Bean bean1 = (Bean)this.assertBean("bean1", Bean.class);
            Bean bean2 = (Bean)this.assertBean("bean2", Bean.class);
            Bean bean3 = (Bean)this.assertBean("bean3", Bean.class);
            TargetAllBean target = (TargetAllBean)this.assertBean("target", TargetAllBean.class);
            InjectionPointQualifiersTestCase.assertNotNull((Object)target.getConstructorBean());
            InjectionPointQualifiersTestCase.assertEquals((Object)bean1, (Object)target.getConstructorBean());
            InjectionPointQualifiersTestCase.assertNotNull((Object)target.getMethodBean());
            InjectionPointQualifiersTestCase.assertEquals((Object)bean2, (Object)target.getMethodBean());
            InjectionPointQualifiersTestCase.assertNotNull((Object)target.getFieldBean());
            InjectionPointQualifiersTestCase.assertEquals((Object)bean3, (Object)target.getFieldBean());
        }
        finally {
            this.undeploy(targetContext);
            this.undeploy(bean3Context);
            this.undeploy(bean2Context);
            this.undeploy(bean1Context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOptionalQualifierPointsForField() throws Throwable {
        BeanMetaDataBuilder bean1Builder = BeanMetaDataBuilder.createBuilder((String)"bean1", (String)Bean.class.getName());
        bean1Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test", "all", "constructor"});
        KernelControllerContext bean1Context = this.deploy(bean1Builder.getBeanMetaData());
        BeanMetaDataBuilder bean2Builder = BeanMetaDataBuilder.createBuilder((String)"bean2", (String)Bean.class.getName());
        bean2Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test", "all", "method"});
        KernelControllerContext bean2Context = this.deploy(bean2Builder.getBeanMetaData());
        BeanMetaDataBuilder bean3Builder = BeanMetaDataBuilder.createBuilder((String)"bean3", (String)Bean.class.getName());
        bean3Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test", "all", "property"});
        KernelControllerContext bean3Context = this.deploy(bean3Builder.getBeanMetaData());
        BeanMetaDataBuilder targetBuilder = BeanMetaDataBuilder.createBuilder((String)"target", (String)TargetAllBeanWithField.class.getName());
        targetBuilder.setAccessMode(BeanAccessMode.ALL);
        targetBuilder.addPropertyMetaData("fieldBean", targetBuilder.addQualifiersToContextualInject(targetBuilder.createContextualInject(), new Object[]{"test"}));
        targetBuilder.addConstructorParameter(Bean.class.getName(), targetBuilder.addQualifiersToContextualInject(targetBuilder.createContextualInject(), new Object[]{"test"}));
        targetBuilder.addInstall("installBean", Bean.class.getName(), targetBuilder.addQualifiersToContextualInject(targetBuilder.createContextualInject(), new Object[]{"test"}));
        targetBuilder.addQualifiers(QualifierType.OPTIONAL, new Object[]{"all"});
        targetBuilder.addQualifiers(QualifierType.OPTIONAL, Arrays.asList(QualifierPoint.CONSTRUCTOR), new Object[]{"constructor"});
        targetBuilder.addQualifiers(QualifierType.OPTIONAL, Arrays.asList(QualifierPoint.METHOD), new Object[]{"method"});
        targetBuilder.addQualifiers(QualifierType.OPTIONAL, Arrays.asList(QualifierPoint.PROPERTY), new Object[]{"property"});
        KernelControllerContext targetContext = this.deploy(targetBuilder.getBeanMetaData());
        try {
            Bean bean1 = (Bean)this.assertBean("bean1", Bean.class);
            Bean bean2 = (Bean)this.assertBean("bean2", Bean.class);
            Bean bean3 = (Bean)this.assertBean("bean3", Bean.class);
            TargetAllBeanWithField target = (TargetAllBeanWithField)this.assertBean("target", TargetAllBeanWithField.class);
            InjectionPointQualifiersTestCase.assertNotNull((Object)target.getConstructorBean());
            InjectionPointQualifiersTestCase.assertEquals((Object)bean1, (Object)target.getConstructorBean());
            InjectionPointQualifiersTestCase.assertNotNull((Object)target.getMethodBean());
            InjectionPointQualifiersTestCase.assertEquals((Object)bean2, (Object)target.getMethodBean());
            InjectionPointQualifiersTestCase.assertNotNull((Object)target.getFieldBean());
            InjectionPointQualifiersTestCase.assertEquals((Object)bean3, (Object)target.getFieldBean());
        }
        finally {
            this.undeploy(targetContext);
            this.undeploy(bean3Context);
            this.undeploy(bean2Context);
            this.undeploy(bean1Context);
        }
    }

    public void testCustomQualifierContent() throws Throwable {
        this.testCustomQualifierContent(false, false);
        QualifierMatchers.getInstance().addParser((QualifierParser)TestMatcherAndParser.INSTANCE);
        this.testCustomQualifierContent(true, false);
        QualifierMatchers.getInstance().addMatcher((QualifierMatcher)TestMatcherAndParser.INSTANCE);
        this.testCustomQualifierContent(true, true);
        QualifierMatchers.getInstance().removeParser(TestMatcherAndParser.INSTANCE.getHandledContent());
        this.testCustomQualifierContent(false, true);
        QualifierMatchers.getInstance().removeMatcher(TestMatcherAndParser.INSTANCE.getHandledType());
        this.testCustomQualifierContent(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCustomQualifierContent(boolean hasParser, boolean hasMatcher) throws Throwable {
        BeanMetaDataBuilder bean1Builder = BeanMetaDataBuilder.createBuilder((String)"bean1", (String)Bean.class.getName());
        bean1Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test"});
        bean1Builder.addQualifiers(QualifierType.SUPPLIED, QualifierContent.getContent((String)"Test"), null, new Object[]{"Hello-xxx"});
        KernelControllerContext bean1Context = this.deploy(bean1Builder.getBeanMetaData());
        BeanMetaDataBuilder bean2Builder = BeanMetaDataBuilder.createBuilder((String)"bean2", (String)Bean.class.getName());
        bean2Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test"});
        bean2Builder.addQualifiers(QualifierType.SUPPLIED, QualifierContent.getContent((String)"Test"), null, new Object[]{"Bonjour-xxx"});
        KernelControllerContext bean2Context = this.deploy(bean2Builder.getBeanMetaData());
        BeanMetaDataBuilder bean3Builder = BeanMetaDataBuilder.createBuilder((String)"bean3", (String)Bean.class.getName());
        bean3Builder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test"});
        bean3Builder.addQualifiers(QualifierType.SUPPLIED, QualifierContent.getContent((String)"Test"), null, new Object[]{"Hola-xxx"});
        KernelControllerContext bean3Context = this.deploy(bean3Builder.getBeanMetaData());
        BeanMetaDataBuilder targetBuilder = BeanMetaDataBuilder.createBuilder((String)"target", (String)TargetAllBean.class.getName());
        ValueMetaData inject = targetBuilder.addQualifiersToContextualInject(targetBuilder.createContextualInject(), new Object[]{"test"});
        inject = targetBuilder.addQualifiersToContextualInject(inject, QualifierContent.getContent((String)"Test"), false, new Object[]{"xxx-Hola"});
        targetBuilder.addPropertyMetaData("fieldBean", inject);
        inject = targetBuilder.addQualifiersToContextualInject(targetBuilder.createContextualInject(), new Object[]{"test"});
        inject = targetBuilder.addQualifiersToContextualInject(inject, QualifierContent.getContent((String)"Test"), false, new Object[]{"xxx-Hello"});
        targetBuilder.addConstructorParameter(Bean.class.getName(), inject);
        inject = targetBuilder.addQualifiersToContextualInject(targetBuilder.createContextualInject(), new Object[]{"test"});
        inject = targetBuilder.addQualifiersToContextualInject(inject, QualifierContent.getContent((String)"Test"), false, new Object[]{"xxx-Bonjour"});
        targetBuilder.addInstall("installBean", Bean.class.getName(), inject);
        targetBuilder.addQualifiers(QualifierType.OPTIONAL, new Object[]{"all"});
        targetBuilder.addQualifiers(QualifierType.OPTIONAL, Arrays.asList(QualifierPoint.CONSTRUCTOR), new Object[]{"constructor"});
        targetBuilder.addQualifiers(QualifierType.OPTIONAL, Arrays.asList(QualifierPoint.METHOD), new Object[]{"method"});
        targetBuilder.addQualifiers(QualifierType.OPTIONAL, Arrays.asList(QualifierPoint.PROPERTY), new Object[]{"property"});
        KernelControllerContext targetContext = this.deploy(targetBuilder.getBeanMetaData());
        try {
            if (hasParser) {
                Bean bean1 = (Bean)this.assertBean("bean1", Bean.class);
                Bean bean2 = (Bean)this.assertBean("bean2", Bean.class);
                Bean bean3 = (Bean)this.assertBean("bean3", Bean.class);
                if (hasMatcher) {
                    TargetAllBean target = (TargetAllBean)this.assertBean("target", TargetAllBean.class);
                    InjectionPointQualifiersTestCase.assertNotNull((Object)target.getConstructorBean());
                    InjectionPointQualifiersTestCase.assertEquals((Object)bean1, (Object)target.getConstructorBean());
                    InjectionPointQualifiersTestCase.assertNotNull((Object)target.getMethodBean());
                    InjectionPointQualifiersTestCase.assertEquals((Object)bean2, (Object)target.getMethodBean());
                    InjectionPointQualifiersTestCase.assertNotNull((Object)target.getFieldBean());
                    InjectionPointQualifiersTestCase.assertEquals((Object)bean3, (Object)target.getFieldBean());
                } else {
                    this.assertNoBean("target");
                }
            } else {
                this.assertNoBean("bean1");
                this.assertNoBean("bean2");
                this.assertNoBean("bean3");
                this.assertNoBean("target");
            }
        }
        finally {
            this.undeploy(targetContext);
            this.undeploy(bean3Context);
            this.undeploy(bean2Context);
            this.undeploy(bean1Context);
        }
    }

    private BeanMetaData addRequiredQualifiersAtBeanLevel(BeanMetaData bmd, Object ... qualifiers) {
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((BeanMetaData)bmd);
        builder.addQualifiers(QualifierType.REQUIRED, qualifiers);
        return builder.getBeanMetaData();
    }

    private BeanMetaData addOptionalQualifiersAtBeanLevel(BeanMetaData bmd, Object ... qualifiers) {
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((BeanMetaData)bmd);
        builder.addQualifiers(QualifierType.OPTIONAL, qualifiers);
        return builder.getBeanMetaData();
    }

    private BeanMetaData createTargetMetaData(Class<?> targetClass, Object ... qualifiers) {
        return this.createTargetMetaData(targetClass, false, qualifiers);
    }

    private BeanMetaData createTargetMetaData(Class<?> targetClass, boolean ignoreBeanQualifiers, Object ... qualifiers) {
        return this.createTargetMetaData(targetClass, ignoreBeanQualifiers, QualifierContent.STRING, qualifiers);
    }

    private BeanMetaData createTargetMetaData(Class<?> targetClass, boolean ignoreBeanQualifiers, QualifierContent content, Object ... qualifiers) {
        BeanMetaDataBuilder targetBuilder = null;
        ValueMetaData value = null;
        if (targetClass == TargetPropertyBean.class || targetClass == TargetFieldBean.class) {
            targetBuilder = BeanMetaDataBuilder.createBuilder((String)"target", (String)targetClass.getName());
            if (targetClass == TargetFieldBean.class) {
                targetBuilder.setAccessMode(BeanAccessMode.ALL);
            }
            value = targetBuilder.addQualifiersToContextualInject(targetBuilder.createContextualInject(), content, ignoreBeanQualifiers, qualifiers);
            targetBuilder.addPropertyMetaData("bean", value);
        } else if (targetClass == TargetConstructorBean.class) {
            targetBuilder = BeanMetaDataBuilder.createBuilder((String)"target", (String)targetClass.getName());
            value = targetBuilder.addQualifiersToContextualInject(targetBuilder.createContextualInject(), content, ignoreBeanQualifiers, qualifiers);
            targetBuilder.addConstructorParameter(Bean.class.getName(), value);
        } else {
            targetBuilder = BeanMetaDataBuilder.createBuilder((String)"target", (String)targetClass.getName());
            value = targetBuilder.addQualifiersToContextualInject(targetBuilder.createContextualInject(), content, ignoreBeanQualifiers, qualifiers);
            targetBuilder.addInstall("installBean", Bean.class.getName(), value);
        }
        return targetBuilder.getBeanMetaData();
    }

    private Annotation getAnnotation(Class<? extends Annotation> clazz) throws Exception {
        return (Annotation)AnnotationCreator.createAnnotation((String)("@" + clazz.getName()), clazz);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TargetType {
        PROPERTY,
        CONSTRUCTOR,
        METHOD;

    }
}

