/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.qualifiers.test;

import junit.framework.Test;
import org.jboss.beans.info.spi.BeanAccessMode;
import org.jboss.beans.metadata.api.model.QualifierType;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.test.kernel.junit.MicrocontainerTest;
import org.jboss.test.kernel.qualifiers.support.AnnotatedBeanA;
import org.jboss.test.kernel.qualifiers.support.AnnotatedBeanB;
import org.jboss.test.kernel.qualifiers.support.AnnotatedBeanC;
import org.jboss.test.kernel.qualifiers.support.AnnotatedBeanD;
import org.jboss.test.kernel.qualifiers.support.AnnotatedIgnoreTargetAllBean;
import org.jboss.test.kernel.qualifiers.support.AnnotatedTargetAllBean;
import org.jboss.test.kernel.qualifiers.support.Bean;
import org.jboss.test.kernel.qualifiers.support.TargetAllBean;
import org.jboss.test.kernel.qualifiers.support.TargetFieldBean;

public class QualifiersAnnotatedTestCase
extends MicrocontainerTest {
    public QualifiersAnnotatedTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        return QualifiersAnnotatedTestCase.suite(QualifiersAnnotatedTestCase.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnnotationInjectBeanQualifierAnnotations() throws Throwable {
        BeanMetaDataBuilder beanABuilder = BeanMetaDataBuilder.createBuilder((String)"beanA", (String)AnnotatedBeanA.class.getName());
        KernelControllerContext beanACtx = this.deploy(beanABuilder.getBeanMetaData());
        BeanMetaDataBuilder beanBBuilder = BeanMetaDataBuilder.createBuilder((String)"beanB", (String)AnnotatedBeanB.class.getName());
        KernelControllerContext beanBCtx = this.deploy(beanBBuilder.getBeanMetaData());
        BeanMetaDataBuilder beanCBuilder = BeanMetaDataBuilder.createBuilder((String)"beanC", (String)AnnotatedBeanC.class.getName());
        KernelControllerContext beanCCtx = this.deploy(beanCBuilder.getBeanMetaData());
        BeanMetaDataBuilder beanDBuilder = BeanMetaDataBuilder.createBuilder((String)"beanD", (String)AnnotatedBeanD.class.getName());
        KernelControllerContext beanDCtx = this.deploy(beanDBuilder.getBeanMetaData());
        BeanMetaDataBuilder targetBuilder = BeanMetaDataBuilder.createBuilder((String)"target", (String)AnnotatedTargetAllBean.class.getName());
        targetBuilder.setAccessMode(BeanAccessMode.ALL);
        KernelControllerContext targetCtx = this.deploy(targetBuilder.getBeanMetaData());
        try {
            Bean beanA = (Bean)this.assertBean("beanA", Bean.class);
            Bean beanB = (Bean)this.assertBean("beanB", Bean.class);
            Bean beanC = (Bean)this.assertBean("beanC", Bean.class);
            Bean beanD = (Bean)this.assertBean("beanD", Bean.class);
            AnnotatedTargetAllBean target = (AnnotatedTargetAllBean)this.assertBean("target", AnnotatedTargetAllBean.class);
            QualifiersAnnotatedTestCase.assertNotNull((Object)target.getConstructorBean());
            QualifiersAnnotatedTestCase.assertNotNull((Object)target.getPropertyBean());
            QualifiersAnnotatedTestCase.assertNotNull((Object)target.getMethodBean());
            QualifiersAnnotatedTestCase.assertNotNull((Object)target.getFieldBean());
            QualifiersAnnotatedTestCase.assertEquals((Object)beanA, (Object)target.getConstructorBean());
            QualifiersAnnotatedTestCase.assertEquals((Object)beanB, (Object)target.getPropertyBean());
            QualifiersAnnotatedTestCase.assertEquals((Object)beanC, (Object)target.getMethodBean());
            QualifiersAnnotatedTestCase.assertEquals((Object)beanD, (Object)target.getFieldBean());
        }
        finally {
            this.undeploy(targetCtx);
            this.undeploy(beanACtx);
            this.undeploy(beanBCtx);
            this.undeploy(beanCCtx);
            this.undeploy(beanDCtx);
        }
    }

    public void testXmlInjectAnnotationBeanQualifierAnnotationss() throws Throwable {
        Bean beanA = (Bean)this.assertBean("beanA", Bean.class);
        Bean beanB = (Bean)this.assertBean("beanB", Bean.class);
        Bean beanC = (Bean)this.assertBean("beanC", Bean.class);
        TargetAllBean target = (TargetAllBean)this.assertBean("target", TargetAllBean.class);
        QualifiersAnnotatedTestCase.assertNotNull((Object)target.getConstructorBean());
        QualifiersAnnotatedTestCase.assertNotNull((Object)target.getFieldBean());
        QualifiersAnnotatedTestCase.assertNotNull((Object)target.getMethodBean());
        QualifiersAnnotatedTestCase.assertEquals((Object)beanA, (Object)target.getConstructorBean());
        QualifiersAnnotatedTestCase.assertEquals((Object)beanB, (Object)target.getFieldBean());
        QualifiersAnnotatedTestCase.assertEquals((Object)beanC, (Object)target.getMethodBean());
    }

    public void testXmlInjectAnnotationBeanQualifierAnnotationsForField() throws Throwable {
        this.assertBean("beanA", Bean.class);
        Bean beanB = (Bean)this.assertBean("beanB", Bean.class);
        this.assertBean("beanC", Bean.class);
        TargetFieldBean target = (TargetFieldBean)this.assertBean("target", TargetFieldBean.class);
        QualifiersAnnotatedTestCase.assertNotNull((Object)target.getBean());
        QualifiersAnnotatedTestCase.assertEquals((Object)beanB, (Object)target.getBean());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnnotationInjectBeanQualifierAnnotationsIgnoringBeanLevelQualifiers() throws Throwable {
        BeanMetaDataBuilder beanABuilder = BeanMetaDataBuilder.createBuilder((String)"beanA", (String)AnnotatedBeanA.class.getName());
        KernelControllerContext beanACtx = this.deploy(beanABuilder.getBeanMetaData());
        BeanMetaDataBuilder beanBBuilder = BeanMetaDataBuilder.createBuilder((String)"beanB", (String)AnnotatedBeanB.class.getName());
        KernelControllerContext beanBCtx = this.deploy(beanBBuilder.getBeanMetaData());
        BeanMetaDataBuilder beanCBuilder = BeanMetaDataBuilder.createBuilder((String)"beanC", (String)AnnotatedBeanC.class.getName());
        KernelControllerContext beanCCtx = this.deploy(beanCBuilder.getBeanMetaData());
        BeanMetaDataBuilder targetBuilder = BeanMetaDataBuilder.createBuilder((String)"target", (String)AnnotatedIgnoreTargetAllBean.class.getName());
        targetBuilder.addQualifiers(QualifierType.REQUIRED, new Object[]{"ignored"});
        KernelControllerContext targetCtx = this.deploy(targetBuilder.getBeanMetaData());
        try {
            Bean beanA = (Bean)this.assertBean("beanA", Bean.class);
            Bean beanB = (Bean)this.assertBean("beanB", Bean.class);
            Bean beanC = (Bean)this.assertBean("beanC", Bean.class);
            AnnotatedIgnoreTargetAllBean target = (AnnotatedIgnoreTargetAllBean)this.assertBean("target", AnnotatedIgnoreTargetAllBean.class);
            QualifiersAnnotatedTestCase.assertNotNull((Object)target.getConstructorBean());
            QualifiersAnnotatedTestCase.assertNotNull((Object)target.getFieldBean());
            QualifiersAnnotatedTestCase.assertNotNull((Object)target.getMethodBean());
            QualifiersAnnotatedTestCase.assertEquals((Object)beanA, (Object)target.getConstructorBean());
            QualifiersAnnotatedTestCase.assertEquals((Object)beanB, (Object)target.getFieldBean());
            QualifiersAnnotatedTestCase.assertEquals((Object)beanC, (Object)target.getMethodBean());
        }
        finally {
            this.undeploy(targetCtx);
            this.undeploy(beanACtx);
            this.undeploy(beanBCtx);
            this.undeploy(beanCCtx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnnotationInjectBeanQualifierAnnotationsNotIgnoringBeanLevelQualifiers() throws Throwable {
        BeanMetaDataBuilder beanABuilder = BeanMetaDataBuilder.createBuilder((String)"beanA", (String)AnnotatedBeanA.class.getName());
        beanABuilder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test", "test1"});
        KernelControllerContext beanACtx = this.deploy(beanABuilder.getBeanMetaData());
        BeanMetaDataBuilder beanBBuilder = BeanMetaDataBuilder.createBuilder((String)"beanB", (String)AnnotatedBeanB.class.getName());
        beanBBuilder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test", "test2"});
        KernelControllerContext beanBCtx = this.deploy(beanBBuilder.getBeanMetaData());
        BeanMetaDataBuilder beanCBuilder = BeanMetaDataBuilder.createBuilder((String)"beanC", (String)AnnotatedBeanC.class.getName());
        beanCBuilder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test", "test3"});
        KernelControllerContext beanCCtx = this.deploy(beanCBuilder.getBeanMetaData());
        BeanMetaDataBuilder targetBuilder = BeanMetaDataBuilder.createBuilder((String)"target", (String)AnnotatedTargetAllBean.class.getName());
        targetBuilder.addQualifiers(QualifierType.REQUIRED, new Object[]{"test"});
        targetBuilder.addQualifiers(QualifierType.OPTIONAL, new Object[]{"test1", "test2", "test3"});
        KernelControllerContext targetCtx = this.deploy(targetBuilder.getBeanMetaData());
        try {
            Bean beanA = (Bean)this.assertBean("beanA", Bean.class);
            Bean beanB = (Bean)this.assertBean("beanB", Bean.class);
            Bean beanC = (Bean)this.assertBean("beanC", Bean.class);
            AnnotatedTargetAllBean target = (AnnotatedTargetAllBean)this.assertBean("target", AnnotatedTargetAllBean.class);
            QualifiersAnnotatedTestCase.assertNotNull((Object)target.getConstructorBean());
            QualifiersAnnotatedTestCase.assertNotNull((Object)target.getPropertyBean());
            QualifiersAnnotatedTestCase.assertNotNull((Object)target.getMethodBean());
            QualifiersAnnotatedTestCase.assertEquals((Object)beanA, (Object)target.getConstructorBean());
            QualifiersAnnotatedTestCase.assertEquals((Object)beanB, (Object)target.getPropertyBean());
            QualifiersAnnotatedTestCase.assertEquals((Object)beanC, (Object)target.getMethodBean());
        }
        finally {
            this.undeploy(targetCtx);
            this.undeploy(beanACtx);
            this.undeploy(beanBCtx);
            this.undeploy(beanCCtx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnnotationConstructorInjectBeanQualifierAnnotationsNotIgnoringBeanLevelQualifiers() throws Throwable {
        BeanMetaDataBuilder beanABuilder = BeanMetaDataBuilder.createBuilder((String)"beanA", (String)AnnotatedBeanA.class.getName());
        beanABuilder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test1"});
        KernelControllerContext beanACtx = this.deploy(beanABuilder.getBeanMetaData());
        BeanMetaDataBuilder beanBBuilder = BeanMetaDataBuilder.createBuilder((String)"beanB", (String)AnnotatedBeanB.class.getName());
        beanBBuilder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test", "test2"});
        KernelControllerContext beanBCtx = this.deploy(beanBBuilder.getBeanMetaData());
        BeanMetaDataBuilder beanCBuilder = BeanMetaDataBuilder.createBuilder((String)"beanC", (String)AnnotatedBeanC.class.getName());
        beanCBuilder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test", "test3"});
        KernelControllerContext beanCCtx = this.deploy(beanCBuilder.getBeanMetaData());
        BeanMetaDataBuilder targetBuilder = BeanMetaDataBuilder.createBuilder((String)"target", (String)AnnotatedTargetAllBean.class.getName());
        targetBuilder.addQualifiers(QualifierType.REQUIRED, new Object[]{"test"});
        targetBuilder.addQualifiers(QualifierType.OPTIONAL, new Object[]{"test1", "test2", "test3"});
        KernelControllerContext targetCtx = this.deploy(targetBuilder.getBeanMetaData());
        try {
            this.assertBean("beanA", Bean.class);
            this.assertBean("beanB", Bean.class);
            this.assertBean("beanC", Bean.class);
            this.assertNoBean("target");
        }
        finally {
            this.undeploy(targetCtx);
            this.undeploy(beanACtx);
            this.undeploy(beanBCtx);
            this.undeploy(beanCCtx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnnotationPropertyInjectBeanQualifierAnnotationsNotIgnoringBeanLevelQualifiers() throws Throwable {
        BeanMetaDataBuilder beanABuilder = BeanMetaDataBuilder.createBuilder((String)"beanA", (String)AnnotatedBeanA.class.getName());
        beanABuilder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test", "test1"});
        KernelControllerContext beanACtx = this.deploy(beanABuilder.getBeanMetaData());
        BeanMetaDataBuilder beanBBuilder = BeanMetaDataBuilder.createBuilder((String)"beanB", (String)AnnotatedBeanB.class.getName());
        beanBBuilder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test2"});
        KernelControllerContext beanBCtx = this.deploy(beanBBuilder.getBeanMetaData());
        BeanMetaDataBuilder beanCBuilder = BeanMetaDataBuilder.createBuilder((String)"beanC", (String)AnnotatedBeanC.class.getName());
        beanCBuilder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test", "test3"});
        KernelControllerContext beanCCtx = this.deploy(beanCBuilder.getBeanMetaData());
        BeanMetaDataBuilder targetBuilder = BeanMetaDataBuilder.createBuilder((String)"target", (String)AnnotatedTargetAllBean.class.getName());
        targetBuilder.addQualifiers(QualifierType.REQUIRED, new Object[]{"test"});
        targetBuilder.addQualifiers(QualifierType.OPTIONAL, new Object[]{"test1", "test2", "test3"});
        KernelControllerContext targetCtx = this.deploy(targetBuilder.getBeanMetaData());
        try {
            this.assertBean("beanA", Bean.class);
            this.assertBean("beanB", Bean.class);
            this.assertBean("beanC", Bean.class);
            this.assertNoBean("target");
        }
        finally {
            this.undeploy(targetCtx);
            this.undeploy(beanACtx);
            this.undeploy(beanBCtx);
            this.undeploy(beanCCtx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnnotationMethodInjectBeanQualifierAnnotationsNotIgnoringBeanLevelQualifiers() throws Throwable {
        BeanMetaDataBuilder beanABuilder = BeanMetaDataBuilder.createBuilder((String)"beanA", (String)AnnotatedBeanA.class.getName());
        beanABuilder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test", "test1"});
        KernelControllerContext beanACtx = this.deploy(beanABuilder.getBeanMetaData());
        BeanMetaDataBuilder beanBBuilder = BeanMetaDataBuilder.createBuilder((String)"beanB", (String)AnnotatedBeanB.class.getName());
        beanBBuilder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test", "test2"});
        KernelControllerContext beanBCtx = this.deploy(beanBBuilder.getBeanMetaData());
        BeanMetaDataBuilder beanCBuilder = BeanMetaDataBuilder.createBuilder((String)"beanC", (String)AnnotatedBeanC.class.getName());
        beanCBuilder.addQualifiers(QualifierType.SUPPLIED, new Object[]{"test3"});
        KernelControllerContext beanCCtx = this.deploy(beanCBuilder.getBeanMetaData());
        BeanMetaDataBuilder targetBuilder = BeanMetaDataBuilder.createBuilder((String)"target", (String)AnnotatedTargetAllBean.class.getName());
        targetBuilder.addQualifiers(QualifierType.REQUIRED, new Object[]{"test"});
        targetBuilder.addQualifiers(QualifierType.OPTIONAL, new Object[]{"test1", "test2", "test3"});
        KernelControllerContext targetCtx = this.deploy(targetBuilder.getBeanMetaData());
        try {
            this.assertBean("beanA", Bean.class);
            this.assertBean("beanB", Bean.class);
            this.assertBean("beanC", Bean.class);
            this.assertNoBean("target");
        }
        finally {
            this.undeploy(targetCtx);
            this.undeploy(beanACtx);
            this.undeploy(beanBCtx);
            this.undeploy(beanCCtx);
        }
    }
}

