/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.qualifiers.test;

import java.util.Dictionary;
import java.util.Hashtable;
import junit.framework.Test;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.kernel.spi.metadata.KernelMetaDataRepository;
import org.jboss.kernel.spi.qualifier.QualifierMatcher;
import org.jboss.kernel.spi.qualifier.QualifierMatchers;
import org.jboss.kernel.spi.qualifier.QualifierParser;
import org.jboss.metadata.plugins.loader.memory.MemoryMetaDataLoader;
import org.jboss.metadata.spi.loader.MutableMetaDataLoader;
import org.jboss.metadata.spi.repository.MutableMetaDataRepository;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.scope.CommonLevels;
import org.jboss.metadata.spi.scope.Scope;
import org.jboss.metadata.spi.scope.ScopeKey;
import org.jboss.test.kernel.junit.MicrocontainerTest;
import org.jboss.test.kernel.qualifiers.support.Bean;
import org.jboss.test.kernel.qualifiers.support.MockFilterMatcherAndParser;
import org.jboss.test.kernel.qualifiers.support.Target;
import org.jboss.test.kernel.qualifiers.support.TargetAllBean;
import org.jboss.test.kernel.qualifiers.support.TargetBean;
import org.jboss.test.kernel.qualifiers.support.TargetConstructorBean;
import org.jboss.test.kernel.qualifiers.support.TargetMethodBean;
import org.jboss.test.kernel.qualifiers.support.TargetPropertyBean;
import org.jboss.test.kernel.qualifiers.support.TestMatcherAndParser;

public class QualifiersXmlTestCase
extends MicrocontainerTest {
    public QualifiersXmlTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        return QualifiersXmlTestCase.suite(QualifiersXmlTestCase.class);
    }

    public void testSimpleBeanQualifiers() {
        this.assertBean("bean1", Bean.class);
        Bean bean = (Bean)this.assertBean("bean2", Bean.class);
        this.assertBean("bean3", Bean.class);
        TargetBean target = (TargetBean)this.assertBean("target", TargetBean.class);
        QualifiersXmlTestCase.assertEquals((Object)bean, (Object)target.getBean());
    }

    public void testCompositeBeanQualifiers() {
        this.assertBean("bean1", Bean.class);
        Bean bean = (Bean)this.assertBean("bean2", Bean.class);
        this.assertBean("bean3", Bean.class);
        TargetBean target = (TargetBean)this.assertBean("target", TargetBean.class);
        QualifiersXmlTestCase.assertEquals((Object)bean, (Object)target.getBean());
    }

    public void testSimpleOptionalBeanQualifiers() {
        this.assertBean("bean1", Bean.class);
        Bean bean = (Bean)this.assertBean("bean2", Bean.class);
        this.assertBean("bean3", Bean.class);
        TargetBean target = (TargetBean)this.assertBean("target", TargetBean.class);
        QualifiersXmlTestCase.assertEquals((Object)bean, (Object)target.getBean());
    }

    public void testPropertyAndSimpleBeanQualifiers() {
        this.assertBean("bean1", Bean.class);
        Bean bean = (Bean)this.assertBean("bean2", Bean.class);
        TargetPropertyBean target = (TargetPropertyBean)this.assertBean("target", TargetPropertyBean.class);
        QualifiersXmlTestCase.assertEquals((Object)bean, (Object)target.getBean());
    }

    public void testPropertyAndCompositeBeanQualifiers() {
        this.assertBean("bean1", Bean.class);
        Bean bean = (Bean)this.assertBean("bean2", Bean.class);
        TargetPropertyBean target = (TargetPropertyBean)this.assertBean("target", TargetPropertyBean.class);
        QualifiersXmlTestCase.assertEquals((Object)bean, (Object)target.getBean());
    }

    public void testSimplePropertyQualifiers() {
        this.assertBean("bean1", Bean.class);
        Bean bean = (Bean)this.assertBean("bean2", Bean.class);
        TargetPropertyBean target = (TargetPropertyBean)this.assertBean("target", TargetPropertyBean.class);
        QualifiersXmlTestCase.assertEquals((Object)bean, (Object)target.getBean());
    }

    public void testCompositePropertyQualifiers() {
        this.assertBean("bean1", Bean.class);
        Bean bean = (Bean)this.assertBean("bean2", Bean.class);
        TargetPropertyBean target = (TargetPropertyBean)this.assertBean("target", TargetPropertyBean.class);
        QualifiersXmlTestCase.assertEquals((Object)bean, (Object)target.getBean());
    }

    public void testSimpleConstructorQualifiers() {
        this.assertBean("bean1", Bean.class);
        Bean bean = (Bean)this.assertBean("bean2", Bean.class);
        TargetConstructorBean target = (TargetConstructorBean)this.assertBean("target", TargetConstructorBean.class);
        QualifiersXmlTestCase.assertEquals((Object)bean, (Object)target.getBean());
    }

    public void testCompositeConstructorQualifiers() {
        this.assertBean("bean1", Bean.class);
        Bean bean = (Bean)this.assertBean("bean2", Bean.class);
        TargetConstructorBean target = (TargetConstructorBean)this.assertBean("target", TargetConstructorBean.class);
        QualifiersXmlTestCase.assertEquals((Object)bean, (Object)target.getBean());
    }

    public void testSimpleMethodQualifiers() {
        this.assertBean("bean1", Bean.class);
        Bean bean = (Bean)this.assertBean("bean2", Bean.class);
        TargetMethodBean target = (TargetMethodBean)this.assertBean("target", TargetMethodBean.class);
        QualifiersXmlTestCase.assertEquals((Object)bean, (Object)target.getBean());
    }

    public void testCompositeMethodQualifiers() {
        this.assertBean("bean1", Bean.class);
        Bean bean = (Bean)this.assertBean("bean2", Bean.class);
        TargetMethodBean target = (TargetMethodBean)this.assertBean("target", TargetMethodBean.class);
        QualifiersXmlTestCase.assertEquals((Object)bean, (Object)target.getBean());
    }

    public void testBeanQualifiersNotIgnoredByDefault() {
        Bean bean = (Bean)this.assertBean("bean1", Bean.class);
        this.assertBean("bean2", Bean.class);
        TargetPropertyBean target = (TargetPropertyBean)this.assertBean("target", TargetPropertyBean.class);
        QualifiersXmlTestCase.assertEquals((Object)bean, (Object)target.getBean());
    }

    public void testBeanQualifiersIgnored() {
        this.assertBean("bean1", Bean.class);
        Bean bean = (Bean)this.assertBean("bean2", Bean.class);
        TargetPropertyBean target = (TargetPropertyBean)this.assertBean("target", TargetPropertyBean.class);
        QualifiersXmlTestCase.assertEquals((Object)bean, (Object)target.getBean());
    }

    public void testQualifierPoints() {
        Bean bean1 = (Bean)this.assertBean("bean1", Bean.class);
        Bean bean2 = (Bean)this.assertBean("bean2", Bean.class);
        Bean bean3 = (Bean)this.assertBean("bean3", Bean.class);
        TargetAllBean target = (TargetAllBean)this.assertBean("target", TargetAllBean.class);
        QualifiersXmlTestCase.assertNotNull((Object)target.getConstructorBean());
        QualifiersXmlTestCase.assertEquals((Object)bean1, (Object)target.getConstructorBean());
        QualifiersXmlTestCase.assertNotNull((Object)target.getMethodBean());
        QualifiersXmlTestCase.assertEquals((Object)bean2, (Object)target.getMethodBean());
        QualifiersXmlTestCase.assertNotNull((Object)target.getFieldBean());
        QualifiersXmlTestCase.assertEquals((Object)bean3, (Object)target.getFieldBean());
    }

    public void testQualifierAnnotationContent() {
        this.assertBean("bean1", Bean.class);
        Bean bean2 = (Bean)this.assertBean("bean2", Bean.class);
        this.assertBean("bean3", Bean.class);
        TargetAllBean target = (TargetAllBean)this.assertBean("target", TargetAllBean.class);
        QualifiersXmlTestCase.assertNotNull((Object)target.getConstructorBean());
        QualifiersXmlTestCase.assertEquals((Object)bean2, (Object)target.getConstructorBean());
        QualifiersXmlTestCase.assertNotNull((Object)target.getMethodBean());
        QualifiersXmlTestCase.assertEquals((Object)bean2, (Object)target.getMethodBean());
        QualifiersXmlTestCase.assertNotNull((Object)target.getFieldBean());
        QualifiersXmlTestCase.assertEquals((Object)bean2, (Object)target.getFieldBean());
    }

    public void testNonCustomBeanQualifiers() throws Throwable {
        this.testNonCustomBeanQualifiers(false, false);
        QualifierMatchers.getInstance().addParser((QualifierParser)TestMatcherAndParser.INSTANCE);
        this.testNonCustomBeanQualifiers(true, false);
        QualifierMatchers.getInstance().addMatcher((QualifierMatcher)TestMatcherAndParser.INSTANCE);
        this.testNonCustomBeanQualifiers(true, true);
        QualifierMatchers.getInstance().removeParser(TestMatcherAndParser.INSTANCE.getHandledContent());
        this.testNonCustomBeanQualifiers(false, true);
        QualifierMatchers.getInstance().removeMatcher(TestMatcherAndParser.INSTANCE.getHandledType());
        this.testNonCustomBeanQualifiers(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQualifierFilterContent() throws Throwable {
        QualifierMatchers.getInstance().addParser((QualifierParser)MockFilterMatcherAndParser.INSTANCE);
        QualifierMatchers.getInstance().addMatcher((QualifierMatcher)MockFilterMatcherAndParser.INSTANCE);
        KernelControllerContext context = this.deploy(BeanMetaDataBuilder.createBuilder((String)"foobar", (String)Bean.class.getName()).getBeanMetaData());
        try {
            Kernel kernel = context.getKernel();
            KernelMetaDataRepository repository = kernel.getMetaDataRepository();
            ScopeKey contextScopeKey = context.getScopeInfo().getMutableScope();
            Scope scope = contextScopeKey.getScope(CommonLevels.INSTANCE);
            ScopeKey key = new ScopeKey(scope);
            MutableMetaDataRepository mutable = repository.getMetaDataRepository();
            MetaDataRetrieval retrieval = mutable.getMetaDataRetrieval(key);
            if (retrieval == null) {
                retrieval = new MemoryMetaDataLoader(key);
                mutable.addMetaDataRetrieval(retrieval);
            } else if (retrieval.retrieveMetaData(Dictionary.class) != null) {
                return;
            }
            if (retrieval instanceof MutableMetaDataLoader) {
                MutableMetaDataLoader mmdl = (MutableMetaDataLoader)retrieval;
                Hashtable<String, String> dictionary = new Hashtable<String, String>();
                ((Dictionary)dictionary).put("a", "b");
                mmdl.addMetaData(dictionary, Dictionary.class);
            }
            KernelDeployment deployment = this.deploy("QualifiersXmlTestCase#testQualifierFilterContent_Not_Automatic.xml");
            try {
                this.assertBean("target", TargetAllBean.class);
            }
            finally {
                this.undeploy(deployment);
            }
        }
        finally {
            this.undeploy(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testNonCustomBeanQualifiers(boolean hasParser, boolean hasMatcher) throws Throwable {
        KernelDeployment deployment = this.deploy("QualifiersXmlTestCase#testCustomBeanQualifiers_Not_Automatic.xml");
        try {
            if (hasParser) {
                this.assertBean("bean1", Bean.class);
                this.assertBean("bean2", Bean.class);
                Bean bean3 = (Bean)this.assertBean("bean3", Bean.class);
                if (hasMatcher) {
                    TargetBean target = (TargetBean)this.assertBean("target", TargetBean.class);
                    QualifiersXmlTestCase.assertNotNull((Object)target.getBean());
                    QualifiersXmlTestCase.assertEquals((Object)bean3, (Object)target.getBean());
                } else {
                    this.assertNoBean("target");
                }
            } else {
                this.assertNoBean("bean1");
                this.assertBean("bean2", Bean.class);
                this.assertNoBean("bean3");
                this.assertNoBean("target");
            }
        }
        finally {
            this.undeploy(deployment);
        }
    }

    public void testNonCustomConstructorQualifiers() throws Throwable {
        this.testNonCustomInjectionPointQualifiers("QualifiersXmlTestCase#testCustomConstructorQualifiers_Not_Automatic.xml");
    }

    public void testNonCustomMethodQualifiers() throws Throwable {
        this.testNonCustomInjectionPointQualifiers("QualifiersXmlTestCase#testCustomMethodQualifiers_Not_Automatic.xml");
    }

    public void testNonCustomPropertyQualifiers() throws Throwable {
        this.testNonCustomInjectionPointQualifiers("QualifiersXmlTestCase#testCustomPropertyQualifiers_Not_Automatic.xml");
    }

    private void testNonCustomInjectionPointQualifiers(String xmlFile) throws Throwable {
        this.testNonCustomInjectionPointQualifiers(xmlFile, false, false);
        QualifierMatchers.getInstance().addParser((QualifierParser)TestMatcherAndParser.INSTANCE);
        this.testNonCustomInjectionPointQualifiers(xmlFile, true, false);
        QualifierMatchers.getInstance().addMatcher((QualifierMatcher)TestMatcherAndParser.INSTANCE);
        this.testNonCustomInjectionPointQualifiers(xmlFile, true, true);
        QualifierMatchers.getInstance().removeParser(TestMatcherAndParser.INSTANCE.getHandledContent());
        this.testNonCustomInjectionPointQualifiers(xmlFile, false, true);
        QualifierMatchers.getInstance().removeMatcher(TestMatcherAndParser.INSTANCE.getHandledType());
        this.testNonCustomInjectionPointQualifiers(xmlFile, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testNonCustomInjectionPointQualifiers(String xmlFile, boolean hasParser, boolean hasMatcher) throws Throwable {
        this.deploy(xmlFile);
        try {
            if (hasParser) {
                this.assertBean("bean1", Bean.class);
                Bean bean2 = (Bean)this.assertBean("bean2", Bean.class);
                if (hasMatcher) {
                    Target target = (Target)this.assertBean("target", Target.class);
                    QualifiersXmlTestCase.assertNotNull((Object)target.getBean());
                    QualifiersXmlTestCase.assertEquals((Object)bean2, (Object)target.getBean());
                } else {
                    this.assertNoBean("target");
                }
            } else {
                this.assertNoBean("bean1");
                this.assertNoBean("bean2");
                this.assertNoBean("target");
            }
        }
        finally {
            this.undeploy(xmlFile);
        }
    }
}

