/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.plugins;

import java.io.Serializable;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.beans.metadata.plugins.AbstractLifecycleMetaData;
import org.jboss.beans.metadata.plugins.CallbackCreatorUtil;
import org.jboss.beans.metadata.spi.CallbackMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitor;
import org.jboss.beans.metadata.spi.ParameterMetaData;
import org.jboss.dependency.spi.CallbackItem;
import org.jboss.dependency.spi.Cardinality;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.kernel.plugins.config.Configurator;
import org.jboss.kernel.plugins.dependency.CallbackDependencyItem;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.util.JBossStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCallbackMetaData
extends AbstractLifecycleMetaData
implements CallbackMetaData,
Serializable {
    private static final long serialVersionUID = 2L;
    protected Cardinality cardinality;
    protected String property;
    protected ControllerState dependentState = ControllerState.INSTALLED;
    protected String signature;
    protected transient PropertyInfo propertyInfo;
    protected transient MethodInfo methodInfo;

    public AbstractCallbackMetaData() {
        this.setState(ControllerState.INSTALLED);
    }

    @Override
    @XmlTransient
    public List<ParameterMetaData> getParameters() {
        return null;
    }

    @Override
    @XmlTransient
    public void setParameters(List<ParameterMetaData> parameters) {
    }

    @Override
    public String getProperty() {
        return this.property;
    }

    @XmlAttribute
    public void setProperty(String property) {
        this.property = property;
        this.flushJBossObjectCache();
    }

    @Override
    public Cardinality getCardinality() {
        return this.cardinality;
    }

    @XmlAttribute
    public void setCardinality(Cardinality cardinality) {
        this.cardinality = cardinality;
        this.flushJBossObjectCache();
    }

    @Override
    public String getSignature() {
        return this.signature;
    }

    @XmlAttribute
    public void setSignature(String signature) {
        this.signature = signature;
        this.flushJBossObjectCache();
    }

    @XmlAttribute(name="state")
    public void setDependentState(ControllerState dependentState) {
        this.dependentState = dependentState;
        this.flushJBossObjectCache();
    }

    @Override
    public ControllerState getDependentState() {
        return this.dependentState;
    }

    @XmlTransient
    public void setPropertyInfo(PropertyInfo propertyInfo) {
        this.propertyInfo = propertyInfo;
        this.property = propertyInfo.getName();
    }

    @XmlTransient
    public void setMethodInfo(MethodInfo methodInfo) {
        this.methodInfo = methodInfo;
        this.methodName = methodInfo.getName();
    }

    protected abstract void addCallback(MetaDataVisitor var1, CallbackItem<?> var2);

    @Override
    public void describeVisit(MetaDataVisitor visitor) {
        ControllerState whenRequired = this.getState();
        try {
            CallbackItem<Class<?>> callback;
            KernelControllerContext context = visitor.getControllerContext();
            if (this.property != null) {
                if (this.propertyInfo == null) {
                    ClassLoader cl = Configurator.getClassLoader(context.getBeanMetaData());
                    this.propertyInfo = Configurator.resolveProperty(this.log.isTraceEnabled(), context.getBeanInfo(), cl, this.property, this.signature);
                }
                callback = CallbackCreatorUtil.createCallback(context, this.propertyInfo, whenRequired, this.dependentState, this.cardinality);
            } else if (this.methodName != null) {
                if (this.methodInfo == null) {
                    this.methodInfo = Configurator.findMethodInfo((ClassInfo)this.getClassInfo(context), (String)this.methodName, (String[])new String[]{this.signature});
                }
                callback = CallbackCreatorUtil.createCallback(context, this.methodInfo, whenRequired, this.dependentState, this.cardinality);
            } else {
                throw new IllegalArgumentException("Illegal usage - not property or method:" + this);
            }
            this.addCallback(visitor, callback);
            if (this.cardinality != null) {
                visitor.addDependency((DependencyItem)new CallbackDependencyItem(context.getName(), (Class)callback.getIDependOn(), whenRequired, this.dependentState, this.cardinality));
            }
        }
        catch (Throwable t) {
            throw new Error(t);
        }
        super.describeVisit(visitor);
    }

    @Override
    public void toString(JBossStringBuilder buffer) {
        super.toString(buffer);
        if (this.property != null) {
            buffer.append(" property=").append(this.property);
        }
        if (this.cardinality != null) {
            buffer.append(" cardinality=").append((Object)this.cardinality);
        }
        if (this.signature != null) {
            buffer.append(" signature=").append(this.signature);
        }
        if (!ControllerState.INSTALLED.equals((Object)this.dependentState)) {
            buffer.append(" dependentState=" + this.dependentState);
        }
    }

    @Override
    public void toShortString(JBossStringBuilder buffer) {
        if (this.property != null) {
            buffer.append("property=").append(this.property);
        }
        if (this.methodName != null) {
            buffer.append("method=").append(this.methodName);
        }
    }
}

