/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.api.model;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.xml.bind.annotation.XmlType;
import org.jboss.beans.metadata.api.model.QualifierContentValueAdapter;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;
import org.jboss.xb.annotations.JBossXmlAdaptedType;

@XmlType(propOrder={})
@JBossXmlAdaptedType(valueAdapter=QualifierContentValueAdapter.class)
public class QualifierContent
extends JBossObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static QualifierContent STRING = new QualifierContent("STRING");
    public static QualifierContent ANNOTATION = new QualifierContent("ANNOTATION");
    private static ConcurrentMap<String, QualifierContent> values = new ConcurrentHashMap<String, QualifierContent>(3, 0.75f, 1);
    private String contentString;

    private QualifierContent(String contentString) {
        this.contentString = QualifierContent.checkString(contentString);
    }

    public String getContentString() {
        return this.contentString;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof QualifierContent)) {
            return false;
        }
        QualifierContent other = (QualifierContent)object;
        return this.contentString.equals(other.contentString);
    }

    public void toString(JBossStringBuilder buffer) {
        buffer.append(this.contentString);
    }

    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.contentString);
    }

    protected int getHashCode() {
        return this.contentString.hashCode();
    }

    protected Object readResolve() throws ObjectStreamException {
        return values.get(this.contentString);
    }

    private static String checkString(String contentString) {
        if (contentString == null) {
            throw new IllegalArgumentException("Null content string");
        }
        if (contentString.trim().length() == 0) {
            throw new IllegalArgumentException("Empty content string");
        }
        return contentString.trim().toUpperCase();
    }

    public static QualifierContent getContent(String contentString) {
        QualifierContent old;
        String str = QualifierContent.checkString(contentString);
        QualifierContent content = (QualifierContent)values.get(str);
        if (content == null && (old = values.putIfAbsent(str, content = new QualifierContent(str))) != null) {
            content = old;
        }
        return content;
    }

    static {
        values.put(STRING.getContentString(), STRING);
        values.put(ANNOTATION.getContentString(), ANNOTATION);
    }
}

