/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.beans.metadata.spi;

import org.jboss.dependency.spi.ControllerState;

/**
 * Metadata about a lifecycle method.
 * 
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision: 89824 $
 */
public interface LifecycleMetaData extends ParameterizedMetaData, FeatureMetaData
{
   /**
    * Get when the dependency is required. 
    * The default is {@link ControllerState#CONFIGURED}    
    *  
    * @return the state
    */
   ControllerState getState();
   
   /**
    * Set when the dependency is required. 
    * The default is {@link ControllerState#CONFIGURED}
    *  
    * @param state the state
    */
   void setState(ControllerState state);
   
   /**
    * Get the method name that should be called.
    *
    * @return the method name.
    */
   String getMethodName();

   /**
    * Set the method name that shuld be called.
    * 
    * @param methodName the method name
    */
   void setMethodName(String methodName);
   
   /**
    * Is ignored by default.
    *
    * @return should we ignore default
    */
   boolean isIgnored();
}
