/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.kernel.plugins.annotations;

import java.lang.annotation.Annotation;
import java.util.List;

import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.kernel.spi.dependency.DependencyBuilderListItem;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.metadata.spi.MetaData;
import org.jboss.reflect.spi.ClassInfo;

/**
 * Annotation plugin to handle annotations that should trigger lifecycle callbacks
 * 
 * @param <C> annotation type
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 1.1 $
 */
public class LifecycleAnnotationPlugin<C extends Annotation> extends ClassAnnotationPlugin<C>
{
   private final DependencyBuilderListItem item;
   
   public LifecycleAnnotationPlugin(Class<C> annotation, DependencyBuilderListItem item)
   {
      super(annotation);
      if (item == null)
         throw new IllegalArgumentException("Null dependency builder list item");
      this.item = item;
   }

   @Override
   protected boolean isCleanup()
   {
      return true;
   }

   @Override
   protected boolean isCleanupOnly()
   {
      return false;
   }

   @Override
   protected List<? extends MetaDataVisitorNode> internalApplyAnnotation(ClassInfo info, MetaData retrieval, C annotation, KernelControllerContext context) throws Throwable
   {
      item.addDependency(context);
      return null;
   }
   
   @Override
   protected void internalCleanAnnotation(ClassInfo info, MetaData retrieval, C annotation, KernelControllerContext context) throws Throwable
   {
      item.removeDependency(context);
   }
}
