/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.plugins;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlType;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.metadata.plugins.AbstractArrayMetaData;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractCollectionMetaData;
import org.jboss.beans.metadata.plugins.AbstractDependencyValueMetaData;
import org.jboss.beans.metadata.plugins.AbstractFeatureMetaData;
import org.jboss.beans.metadata.plugins.AbstractInjectionValueMetaData;
import org.jboss.beans.metadata.plugins.AbstractLazyMetaData;
import org.jboss.beans.metadata.plugins.AbstractListMetaData;
import org.jboss.beans.metadata.plugins.AbstractMapMetaData;
import org.jboss.beans.metadata.plugins.AbstractParameterMetaData;
import org.jboss.beans.metadata.plugins.AbstractSetMetaData;
import org.jboss.beans.metadata.plugins.AbstractValueFactoryMetaData;
import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
import org.jboss.beans.metadata.plugins.CloneUtil;
import org.jboss.beans.metadata.plugins.StringValueMetaData;
import org.jboss.beans.metadata.plugins.ValueMetaDataAware;
import org.jboss.beans.metadata.plugins.builder.MutableParameterizedMetaData;
import org.jboss.beans.metadata.spi.ConstructorMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitor;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.beans.metadata.spi.ParameterMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.joinpoint.plugins.Config;
import org.jboss.kernel.plugins.config.Configurator;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.ConstructorInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlType(name="constructorType", propOrder={"annotations", "factory", "parameters", "value"})
public class AbstractConstructorMetaData
extends AbstractFeatureMetaData
implements ConstructorMetaData,
MutableParameterizedMetaData,
ValueMetaDataAware,
Serializable {
    private static final long serialVersionUID = 2L;
    protected List<ParameterMetaData> parameters;
    protected ValueMetaData value;
    protected ValueMetaData factory;
    protected String factoryClassName;
    protected String factoryMethod;

    @Override
    @XmlElement(name="parameter", type=AbstractParameterMetaData.class)
    public void setParameters(List<ParameterMetaData> parameters) {
        this.parameters = parameters;
        this.flushJBossObjectCache();
    }

    @Override
    @XmlElements(value={@XmlElement(name="bean", type=AbstractBeanMetaData.class), @XmlElement(name="lazy", type=AbstractLazyMetaData.class), @XmlElement(name="array", type=AbstractArrayMetaData.class), @XmlElement(name="collection", type=AbstractCollectionMetaData.class), @XmlElement(name="list", type=AbstractListMetaData.class), @XmlElement(name="map", type=AbstractMapMetaData.class), @XmlElement(name="set", type=AbstractSetMetaData.class), @XmlElement(name="value", type=StringValueMetaData.class), @XmlElement(name="inject", type=AbstractInjectionValueMetaData.class), @XmlElement(name="value-factory", type=AbstractValueFactoryMetaData.class)})
    public void setValue(ValueMetaData value) {
        this.value = value;
        this.flushJBossObjectCache();
    }

    @XmlAnyElement
    @ManagementProperty(ignored=true)
    public void setValueObject(Object value) {
        if (value == null) {
            this.setValue(null);
        } else if (value instanceof ValueMetaData) {
            this.setValue((ValueMetaData)value);
        } else {
            this.setValue(new AbstractValueMetaData(value));
        }
    }

    @XmlElement(name="factory", type=AbstractDependencyValueMetaData.class)
    public void setFactory(ValueMetaData factory) {
        Object underlying;
        if (factory != null && factory instanceof AbstractDependencyValueMetaData && (underlying = factory.getUnderlyingValue()) != null && underlying instanceof ValueMetaData) {
            factory = (ValueMetaData)underlying;
        }
        this.factory = factory;
        this.flushJBossObjectCache();
    }

    @XmlAttribute(name="factoryClass")
    public void setFactoryClass(String name) {
        this.factoryClassName = name;
        this.flushJBossObjectCache();
    }

    @XmlAttribute(name="factoryMethod")
    public void setFactoryMethod(String name) {
        this.factoryMethod = name;
        this.flushJBossObjectCache();
    }

    @Override
    public List<ParameterMetaData> getParameters() {
        return this.parameters;
    }

    @Override
    public ValueMetaData getValue() {
        return this.value;
    }

    @Override
    public ValueMetaData getFactory() {
        return this.factory;
    }

    @Override
    public String getFactoryClass() {
        return this.factoryClassName;
    }

    @Override
    public String getFactoryMethod() {
        return this.factoryMethod;
    }

    @Override
    public void initialVisit(MetaDataVisitor visitor) {
        ValueMetaData factory = this.getFactory();
        if ((factory != null || this.getFactoryClass() != null) && this.getFactoryMethod() == null) {
            throw new IllegalArgumentException("Constructor needs a factoryMethod attribute when there is a factoryClass attribute or factory element.");
        }
        if (factory != null && factory.getUnderlyingValue() == null) {
            throw new IllegalArgumentException("Factory should have a bean attribute or nested element.");
        }
        if (this.parameters != null) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                this.parameters.get(i).setIndex(i);
            }
        }
        super.initialVisit(visitor);
    }

    @Override
    protected void addChildren(Set<MetaDataVisitorNode> children) {
        super.addChildren(children);
        if (this.parameters != null) {
            children.addAll(this.parameters);
        }
        if (this.value != null) {
            children.add(this.value);
        }
        if (this.factory != null) {
            children.add(this.factory);
        }
    }

    @Override
    public TypeInfo getType(MetaDataVisitor visitor, MetaDataVisitorNode previous) throws Throwable {
        if (this.factory != null || this.factoryClassName != null) {
            ClassInfo classInfo;
            KernelControllerContext context = visitor.getControllerContext();
            ClassLoader cl = Configurator.getClassLoader(context.getBeanMetaData());
            KernelConfigurator configurator = context.getKernel().getConfigurator();
            if (this.factory != null) {
                Object target = this.factory.getValue(null, cl);
                classInfo = configurator.getClassInfo(target.getClass());
            } else {
                classInfo = configurator.getClassInfo(this.factoryClassName, cl);
            }
            if (!(previous instanceof ParameterMetaData)) {
                throw new IllegalArgumentException("Previous node is not ParameterMetaData as expected: " + previous);
            }
            ParameterMetaData parameter = (ParameterMetaData)previous;
            String[] parameterTypes = Configurator.getParameterTypes(false, this.parameters);
            MethodInfo methodInfo = Config.findMethodInfo((ClassInfo)classInfo, (String)this.factoryMethod, (String[])parameterTypes, (this.factoryClassName != null ? 1 : 0) != 0, (boolean)true);
            return this.applyCollectionOrMapCheck(methodInfo.getParameterTypes()[parameter.getIndex()]);
        }
        KernelControllerContext context = visitor.getControllerContext();
        BeanInfo beanInfo = context.getBeanInfo();
        if (previous instanceof ParameterMetaData) {
            ParameterMetaData parameter = (ParameterMetaData)previous;
            String[] paramTypes = Configurator.getParameterTypes(false, this.parameters);
            ConstructorInfo ci = Config.findConstructorInfo((ClassInfo)beanInfo.getClassInfo(), (String[])paramTypes);
            return this.applyCollectionOrMapCheck(ci.getParameterTypes()[parameter.getIndex()]);
        }
        ClassInfo type = beanInfo.getClassInfo();
        this.log.debugf("Constructing bean from injection value: results in multiple beans with same class type - %1s", new Object[]{type});
        return type;
    }

    @Override
    public void toString(JBossStringBuilder buffer) {
        buffer.append("parameters=");
        JBossObject.list((JBossStringBuilder)buffer, this.parameters);
        if (this.value != null) {
            buffer.append(" value=").append((Object)this.value);
        }
        if (this.factory != null) {
            buffer.append(" factory=").append((Object)this.factory);
        }
        if (this.factoryClassName != null) {
            buffer.append(" factoryClass=").append(this.factoryClassName);
        }
        if (this.factoryMethod != null) {
            buffer.append(" factoryMethod=").append(this.factoryMethod);
        }
        super.toString(buffer);
    }

    @Override
    public AbstractConstructorMetaData clone() {
        AbstractConstructorMetaData clone = (AbstractConstructorMetaData)super.clone();
        this.doClone(clone);
        return clone;
    }

    protected void doClone(AbstractConstructorMetaData clone) {
        super.doClone(clone);
        clone.setFactory(CloneUtil.cloneObject(this.factory, ValueMetaData.class));
        clone.setValue(CloneUtil.cloneObject(this.value, ValueMetaData.class));
        clone.setParameters(CloneUtil.cloneList(this.parameters, ArrayList.class, ParameterMetaData.class));
    }
}

