/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.kernel.weld.plugins.annotated;

import java.lang.reflect.Constructor;

import javax.enterprise.inject.spi.AnnotatedConstructor;

import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.signature.ConstructorParametersSignature;
import org.jboss.metadata.spi.signature.ParametersSignature;

/**
 * Decorator that understands MDR metadata for constructor
 *
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 1.1 $
 */
class MDRAnnotatedConstructor<X> extends MDRAnnotatedCallable<X> implements AnnotatedConstructor<X>
{
   /**
    * Constructor
    *
    * @param owner the annotated type containing this callable
    * @param delegate the delegate
    * @param metaData the MDR metadata for the method or constructor
    * @param mainMetaData the MDR metadata for the class containing this method or constructor
    */
   MDRAnnotatedConstructor(MDRAnnotatedType<X> owner, AnnotatedConstructor<X> delegate, MetaData metaData, MetaData mainMetaData)
   {
      super(owner, delegate, metaData, mainMetaData);
   }

   /**
    * Gets the delegate
    * 
    * @return the delegate
    */
   @Override
   AnnotatedConstructor<X> getDelegate()
   {
      return (AnnotatedConstructor<X>)super.getDelegate();
   }

   /**
    * Gets the java.lang.reflect.Constructor wrapped by this
    * 
    * @return the Constructor
    */
   public Constructor<X> getJavaMember()
   {
      return getDelegate().getJavaMember();
   }

   /**
    * Gets the MDR parameters signature for a parameter
    * 
    * @param i the index of the parameter
    * @return the parameter signature
    */
   @Override
   ParametersSignature getParametersSignature(int i)
   {
      return new ConstructorParametersSignature(getJavaMember(), i);
   }
}
