/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.kernel.weld.plugins.weld;

import java.util.Set;

import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;

import org.jboss.kernel.spi.dependency.KernelControllerContext;

/**
 * 
 * @param <T> the class of the target
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 1.1 $
 */
public class ExistingInstanceInjectionTarget<T> extends ExistingInstanceHolder<T> implements InjectionTarget<T>
{
   final InjectionTarget<T> injectionTarget;
   
   ExistingInstanceInjectionTarget(InjectionTarget<T> injectionTarget, KernelControllerContext context)
   {
      super(context);
      
      if (injectionTarget == null)
         throw new IllegalArgumentException("Null injection target");
      
      this.injectionTarget = injectionTarget;
   }
   
   public void inject(T instance, CreationalContext<T> ctx)
   {
    //No op, handled during the installation of the WeldKernelControllerContext
   }

   public void postConstruct(T instance)
   {
      //No op, handled during the installation of the WeldKernelControllerContext
   }

   public void preDestroy(T instance)
   {
      //No op, handled during the uninstallation of the WeldKernelControllerContext
   }

   public void dispose(T instance)
   {
      //No op
   }

   public Set<InjectionPoint> getInjectionPoints()
   {
      return injectionTarget.getInjectionPoints();
   }

   public T produce(CreationalContext<T> ctx)
   {
      return getInstanceFromContext();
   }

}
