/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.kernel.weld.plugins.annotated;

import javax.enterprise.inject.spi.AnnotatedType;

import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.metadata.KernelMetaDataRepository;
import org.jboss.kernel.weld.spi.annotated.MDRAnnotatedTypeFactory;
import org.jboss.metadata.spi.MetaData;

/**
 * Decorates annotated types to understand MDR metadata 
 *  
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 1.1 $
 */
public class MDRAnnotatedTypeFactoryImpl extends MDRAnnotatedTypeFactory
{
   public <T> AnnotatedType<T> decorateAnnotatedType(AnnotatedType<T> delegate, MetaData metaData)
   {
      return new MDRAnnotatedType<T>(delegate, metaData);
   }

   @Override
   public <T> AnnotatedType<T> decorateAnnotatedType(AnnotatedType<T> delegate, KernelControllerContext context)
   {
      KernelController controller = (KernelController)context.getController();
      Kernel kernel = controller.getKernel();
      KernelMetaDataRepository repository = kernel.getMetaDataRepository();
      MetaData metaData = repository.getMetaData(context);
      
      return decorateAnnotatedType(delegate, metaData);
  }
}
