/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.weld.plugins.annotated;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Annotated;
import org.jboss.metadata.spi.MetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MDRAnnotated
implements Annotated {
    private Annotated delegate;
    private MetaData metaData;

    public MDRAnnotated(Annotated delegate, MetaData metaData) {
        if (delegate == null) {
            throw new IllegalArgumentException("Null delegate");
        }
        this.delegate = delegate;
        this.metaData = metaData;
    }

    Annotated getDelegate() {
        return this.delegate;
    }

    MetaData getMetaData() {
        return this.metaData;
    }

    public Type getBaseType() {
        return this.delegate.getBaseType();
    }

    public Set<Type> getTypeClosure() {
        return this.delegate.getTypeClosure();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        Annotation t;
        if (this.metaData != null && (t = this.metaData.getAnnotation(annotationType)) != null) {
            return (T)t;
        }
        return (T)this.getDelegate().getAnnotation(annotationType);
    }

    public Set<Annotation> getAnnotations() {
        HashSet<Annotation> annotations = new HashSet<Annotation>(this.getDelegate().getAnnotations());
        if (this.metaData == null) {
            return annotations;
        }
        Annotation[] metaDataAnnotations = this.metaData.getAnnotations();
        if (metaDataAnnotations.length == 0) {
            return annotations;
        }
        if (annotations.size() == 0) {
            HashSet<Annotation> metaDataAnns = new HashSet<Annotation>();
            for (Annotation ann : metaDataAnnotations) {
                metaDataAnns.add(ann);
            }
            return metaDataAnns;
        }
        HashMap<Class<? extends Annotation>, Annotation> done = new HashMap<Class<? extends Annotation>, Annotation>();
        for (Annotation annotation : annotations) {
            done.put(annotation.annotationType(), annotation);
        }
        for (Annotation annotation : metaDataAnnotations) {
            done.put(annotation.annotationType(), annotation);
        }
        return new HashSet<Annotation>(done.values());
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        if (this.metaData != null && this.metaData.isAnnotationPresent(annotationType)) {
            return true;
        }
        return this.getDelegate().isAnnotationPresent(annotationType);
    }
}

