/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.kernel.weld.plugins.annotations;

import java.util.List;

import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.kernel.plugins.annotations.ClassAnnotationPlugin;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.weld.metadata.api.annotations.WeldEnabled;
import org.jboss.kernel.weld.plugins.weld.WeldFromMcRegistry;
import org.jboss.metadata.spi.MetaData;
import org.jboss.reflect.spi.ClassInfo;

/**
 * Annotation plugin looking for the @WeldEnabled annotation. On install it will
 * add the context to the WeldFromMcRegistry. On uninstall it will remove it from the 
 * WeldFromMcRegistry.
 * 
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 1.1 $
 */
public class WeldEnabledAnnotationPlugin extends ClassAnnotationPlugin<WeldEnabled>
{
   public static final WeldEnabledAnnotationPlugin INSTANCE = new WeldEnabledAnnotationPlugin();

   protected WeldEnabledAnnotationPlugin()
   {
      super(WeldEnabled.class);
   }

   @Override
   protected boolean isCleanup()
   {
      return true;
   }

   @Override
   protected List<? extends MetaDataVisitorNode> internalApplyAnnotation(ClassInfo info, MetaData retrieval, WeldEnabled annotation, KernelControllerContext context) throws Throwable
   {
      WeldFromMcRegistry.getInstance().registerBean(context);
      return null;
   }

   @Override
   protected void internalCleanAnnotation(ClassInfo info, MetaData retrieval, WeldEnabled annotation, KernelControllerContext context) throws Throwable
   {
      WeldFromMcRegistry.getInstance().unregisterBean(context);
   }
}
