/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.kernel.weld.plugins.weld;

import javax.enterprise.inject.spi.AnnotatedType;

/**
 * The annotated type implementations in Weld do not implement equals and hashCode,
 * so wrap them so they can be used as keys in a map
 * 
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 1.1 $
 */
public class AnnotatedTypeWrapper
{
   private final AnnotatedType<?> annotatedType;
   
   private volatile int hashCode;
   
   public AnnotatedTypeWrapper(AnnotatedType<?> annotatedType)
   {
      if (annotatedType == null)
         throw new IllegalArgumentException("Null type");
      this.annotatedType = annotatedType;
   }
   
   AnnotatedType<?> getAnnotatedType()
   {
      return annotatedType;
   }
   
   @Override
   public boolean equals(Object obj)
   {
      if (obj instanceof AnnotatedTypeWrapper == false)
         return false;

      AnnotatedTypeWrapper other = (AnnotatedTypeWrapper)obj;
      
      if (this.annotatedType.getJavaClass() != other.annotatedType.getJavaClass())
         return false;
      
      if (this.annotatedType.getAnnotations() == null && other.annotatedType.getAnnotations() != null)
         return false;
      if (this.annotatedType.getAnnotations() != null && other.annotatedType.getAnnotations() == null)
         return false;
      if (this.annotatedType.getAnnotations() == null && other.annotatedType.getAnnotations() == null)
         return true;

      return this.annotatedType.getAnnotations().equals(this.annotatedType.getAnnotations());
   }

   @Override
   public int hashCode()
   {
      int result = hashCode;
      if (result == 0)
      {
         result = 17;
         result = 31 * result + annotatedType.hashCode();
         if (annotatedType.getAnnotations() != null)
            result = 31 * result + annotatedType.hashCode();
         
         hashCode = result;
      }
      return 17;
   }
}
