/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.kernel.weld.plugins.weld;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;

import javax.enterprise.event.Observes;
import javax.enterprise.inject.InjectionException;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.inject.spi.ProcessProducer;
import javax.enterprise.inject.spi.Producer;

import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.weld.plugins.dependency.UnsatisfiedDependencyRegistry;

/**
 * Web Beans extension bean to register MC beans that should be accessible from web beans 
 * 
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 1.1 $
 */
public class McBeanRegistryObserver implements Extension
{
   public void addType(@Observes BeforeBeanDiscovery event, BeanManager beanManager)
   {
      WeldFromMcRegistry.getInstance().initializeTypes(beanManager);
      for (AnnotatedTypeWrapper typeWrapper : WeldFromMcRegistry.getInstance().getTypes())
      {   
         event.addAnnotatedType(typeWrapper.getAnnotatedType());
      }
   }
   
   public <X> void processInjectionTarget(@Observes ProcessInjectionTarget<X> event)
   {
      AnnotatedType<?> type = event.getAnnotatedType();
      KernelControllerContext context = WeldFromMcRegistry.getInstance().getContext(type);
      if (context != null)
      {
         InjectionTarget<X> target = event.getInjectionTarget();
         ExistingInstanceInjectionTarget<X> tgt = new ExistingInstanceInjectionTarget<X>(target, context);
         event.setInjectionTarget(tgt);
      }
   }
   
   public <X> void processProducer(@Observes ProcessProducer<?, X> event)
   {
      AnnotatedType<?> type = event.getAnnotatedMember().getDeclaringType();
      KernelControllerContext context = WeldFromMcRegistry.getInstance().getContext(type);
      if (context != null)
      {
         Producer<X> producer = event.getProducer();
         if (producer.getInjectionPoints().size() > 0)
         {
            throw new IllegalStateException("Only producer fields or parameterless producer methods can be used");
         }
         
         Member member = event.getAnnotatedMember().getJavaMember();
         
         if (member instanceof Field)
         {
            Producer<X> wrapped = new ExisitingInstanceFieldProducer<X>((Field)member, producer, context);
            event.setProducer(wrapped);
         }
         else if (member instanceof Method)
         {
            Producer<X> wrapped = new ExisitingInstanceMethodProducer<X>((Method)member, producer, context);
            event.setProducer(wrapped);
         }
         else
         {
            throw new IllegalStateException("Invalid member type " + member);
         }
      }
   }
   
   public void processAfterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery)
   {
      try
      {
         UnsatisfiedDependencyRegistry.getInstance().incrementContexts();
      }
      catch(Throwable t)
      {
         throw new InjectionException("Error happened installing hung MC contexts following install of web beans", t);
      }
   }
}
