/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.weld.plugins.weld;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.InjectionException;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.inject.spi.ProcessProducer;
import javax.enterprise.inject.spi.Producer;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.weld.plugins.dependency.UnsatisfiedDependencyRegistry;
import org.jboss.kernel.weld.plugins.weld.AnnotatedTypeWrapper;
import org.jboss.kernel.weld.plugins.weld.ExisitingInstanceFieldProducer;
import org.jboss.kernel.weld.plugins.weld.ExisitingInstanceMethodProducer;
import org.jboss.kernel.weld.plugins.weld.ExistingInstanceInjectionTarget;
import org.jboss.kernel.weld.plugins.weld.WeldFromMcRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class McBeanRegistryObserver
implements Extension {
    public void addType(@Observes BeforeBeanDiscovery event, BeanManager beanManager) {
        WeldFromMcRegistry.getInstance().initializeTypes(beanManager);
        for (AnnotatedTypeWrapper typeWrapper : WeldFromMcRegistry.getInstance().getTypes()) {
            event.addAnnotatedType(typeWrapper.getAnnotatedType());
        }
    }

    public <X> void processInjectionTarget(@Observes ProcessInjectionTarget<X> event) {
        AnnotatedType type = event.getAnnotatedType();
        KernelControllerContext context = WeldFromMcRegistry.getInstance().getContext(type);
        if (context != null) {
            InjectionTarget target = event.getInjectionTarget();
            ExistingInstanceInjectionTarget tgt = new ExistingInstanceInjectionTarget(target, context);
            event.setInjectionTarget(tgt);
        }
    }

    public <X> void processProducer(@Observes ProcessProducer<?, X> event) {
        AnnotatedType type = event.getAnnotatedMember().getDeclaringType();
        KernelControllerContext context = WeldFromMcRegistry.getInstance().getContext(type);
        if (context != null) {
            Producer producer = event.getProducer();
            if (producer.getInjectionPoints().size() > 0) {
                throw new IllegalStateException("Only producer fields or parameterless producer methods can be used");
            }
            Member member = event.getAnnotatedMember().getJavaMember();
            if (member instanceof Field) {
                ExisitingInstanceFieldProducer wrapped = new ExisitingInstanceFieldProducer((Field)member, producer, context);
                event.setProducer(wrapped);
            } else if (member instanceof Method) {
                ExisitingInstanceMethodProducer wrapped = new ExisitingInstanceMethodProducer((Method)member, producer, context);
                event.setProducer(wrapped);
            } else {
                throw new IllegalStateException("Invalid member type " + member);
            }
        }
    }

    public void processAfterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery) {
        try {
            UnsatisfiedDependencyRegistry.getInstance().incrementContexts();
        }
        catch (Throwable t) {
            throw new InjectionException("Error happened installing hung MC contexts following install of web beans", t);
        }
    }
}

