/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.kernel.weld.plugins.dependency;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/**
 * 
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 1.1 $
 */
public class UnsatisfiedDependencyRegistry
{
   private static UnsatisfiedDependencyRegistry INSTANCE = new UnsatisfiedDependencyRegistry();
   
   Object IGNORE = new Object();

   ConcurrentMap<WeldKernelControllerContext, Object> hungContexts = new ConcurrentHashMap<WeldKernelControllerContext, Object>();
   
   private UnsatisfiedDependencyRegistry()
   {
   }
   
   public static UnsatisfiedDependencyRegistry getInstance()
   {
      return INSTANCE;
   }
   
   public void addHungContext(WeldKernelControllerContext context)
   {
      hungContexts.putIfAbsent(context, IGNORE);
   }
   
   public void removeHungContext(WeldKernelControllerContext context)
   {
      hungContexts.remove(context);
   }
   
   public void incrementContexts() throws Throwable
   {
      int size = hungContexts.size();
      while (size > 0)
      {
         for (WeldKernelControllerContext context : hungContexts.keySet())
         {
            context.getController().change(context, context.getRequiredState());
         }
         
         if (hungContexts.size() == 0 || hungContexts.size() == size)
            break;
         size = hungContexts.size();
      }
   }
}
