/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.kernel.weld.plugins.dependency;

import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.plugins.dependency.InstantiateAction;
import org.jboss.kernel.spi.dependency.InstantiateKernelControllerContextAware;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.dependency.KernelControllerContextAware;

/**
 * InstantiateAction that determines if a bean should be instantiated by web beans, and if so delegates
 * to instantiation to web beans. Otherwise, it instantiates it normally using normal MC instantiation.
 * 
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 1.1 $
 */
public class WeldInstantiateAction extends InstantiateAction
{
   @Override
   protected void installActionInternal(KernelControllerContext context) throws Throwable
   {
      if (context instanceof WeldKernelControllerContext == false)
         throw new IllegalArgumentException("context is not a WabBeansKernelControllerContext");
      
      WeldInjector<?> injector = ((WeldKernelControllerContext)context).getWeldInjector();
      if (injector.createInWeld())
         context.setTarget(injector.instantiate());
      else
         super.installActionInternal(context);
   }

   @Override
   protected void uninstallActionInternal(KernelControllerContext context)
   {
      context.setTarget(null);
   }

   protected ControllerState getState()
   {
      return ControllerState.INSTANTIATED;
   }

   protected Class<? extends KernelControllerContextAware> getActionAwareInterface()
   {
      return InstantiateKernelControllerContextAware.class;
   }
}
