/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.managed.factory.test;

import java.util.HashMap;
import java.util.Map;

import javax.management.ObjectName;

import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.metatype.api.types.CompositeMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.PropertiesMetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.MapCompositeValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.PropertiesMetaValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.jboss.metatype.spi.values.MetaMapper;
import org.jboss.test.managed.factory.AbstractManagedObjectFactoryTest;
import org.jboss.test.managed.factory.support.ObjectNameBean;

/**
 * Tests of specifying a MetaMapper on managed properties
 * @author Scott.Stark@jboss.org
 * @version $Revision:$
 */
public class PropertyMetaMapperUnitTestCase extends AbstractManagedObjectFactoryTest
{
   private ObjectNameBean bean;

   public PropertyMetaMapperUnitTestCase(String name)
   {
      super(name);
   }

   protected void setUp()
      throws Exception
   {
      super.setUp();

      bean = new ObjectNameBean();
      bean.setNameAsString(new ObjectName("testObjectNameBean:key1=value1,key2=value2"));
      bean.setNameAsComposite(new ObjectName("nameAsComposite:key1=value1,key2=value2"));
      bean.setNameAsCompositeFixedKeys(new ObjectName("nameAsCompositeFixedKeys:key1=value1,key2=value2"));
      bean.setNameAsProperties(new ObjectName("nameAsProperties:key1=value1,key2=value2"));
   }

   public void testNameAsString()
      throws Exception
   {
      // A String type for ObjectName
      ManagedObject managedObject = super.initManagedObject(bean);
      ManagedProperty nameAsString = managedObject.getProperty("nameAsString");
      assertTrue(nameAsString.getTransientAttachment(MetaMapper.class) != null);
      MetaType nameAsStringType = nameAsString.getMetaType();
      assertEquals(SimpleMetaType.STRING, nameAsStringType);
      nameAsString.setValue(SimpleValueSupport.wrap("testObjectNameBean-update:key1=value1,key2=value2"));
      ObjectName nameAsStringON = bean.getNameAsString();
      assertEquals("testObjectNameBean-update", nameAsStringON.getDomain());
   }

   public void testNameAsComposite()
   {
      ManagedObject managedObject = super.initManagedObject(bean);

      // A CompositeMetaType for ObjectName
      ManagedProperty nameAsComposite = managedObject.getProperty("nameAsComposite");
      assertTrue(nameAsComposite.getTransientAttachment(MetaMapper.class) != null);
      MetaType nameAsCompositeType = nameAsComposite.getMetaType();
      assertTrue(nameAsCompositeType instanceof CompositeMetaType);
      Map<String, MetaValue> map = new HashMap<String, MetaValue>();
      map.put("domain", SimpleValueSupport.wrap("nameAsComposite-update"));
      map.put("key1", SimpleValueSupport.wrap("value1"));
      map.put("key2", SimpleValueSupport.wrap("value2"));
      map.put("key3", SimpleValueSupport.wrap("value3"));
      MapCompositeValueSupport value = new MapCompositeValueSupport(map, SimpleMetaType.STRING);
      nameAsComposite.setValue(value);
      ObjectName nameAsCompositeON = bean.getNameAsComposite();
      assertEquals("nameAsComposite-update:key1=value1,key2=value2,key3=value3", nameAsCompositeON.getCanonicalName());
   }

   public void testNameAsCompositeFixedKeys()
   {
      ManagedObject managedObject = super.initManagedObject(bean);
   
      // A CompositeMetaType for ObjectName
      ManagedProperty nameAsCompositeFixedKeys = managedObject.getProperty("nameAsCompositeFixedKeys");
      assertTrue(nameAsCompositeFixedKeys.getTransientAttachment(MetaMapper.class) != null);
      MetaType nameAsCompositeFixedKeysType = nameAsCompositeFixedKeys.getMetaType();
      assertTrue(nameAsCompositeFixedKeysType instanceof CompositeMetaType);
      CompositeMetaType nameAsCompositeFixedKeysCMT = (CompositeMetaType) nameAsCompositeFixedKeysType;
      assertEquals("The first key", nameAsCompositeFixedKeysCMT.getDescription("key1"));
      assertEquals("The second key", nameAsCompositeFixedKeysCMT.getDescription("key2"));
      Map<String, MetaValue> map = new HashMap<String, MetaValue>();
      map.put("domain", SimpleValueSupport.wrap("nameAsCompositeFixedKeys-update"));
      map.put("key1", SimpleValueSupport.wrap("value1"));
      map.put("key2", SimpleValueSupport.wrap("value2"));
      map.put("key3", SimpleValueSupport.wrap("value3"));
      MapCompositeValueSupport value = new MapCompositeValueSupport(map, SimpleMetaType.STRING);
      nameAsCompositeFixedKeys.setValue(value);
      ObjectName nameAsCompositeFixedKeysON = bean.getNameAsCompositeFixedKeys();
      assertEquals("nameAsCompositeFixedKeys-update:key1=value1,key2=value2,key3=value3", nameAsCompositeFixedKeysON.getCanonicalName());
   }
   
   public void testNameAsProperties()
   {
      ManagedObject managedObject = super.initManagedObject(bean);

      // A PropertiesMetaType for ObjectName
      ManagedProperty nameAsProperties = managedObject.getProperty("nameAsProperties");
      assertTrue(nameAsProperties.getTransientAttachment(MetaMapper.class) != null);
      MetaType nameAsPropertiesType = nameAsProperties.getMetaType();
      assertTrue(nameAsPropertiesType instanceof PropertiesMetaType);
      PropertiesMetaValue props = new PropertiesMetaValue();
      props.put("domain", "nameAsProperties-update");
      props.put("key1", "value1");
      props.put("key2", "value2");
      props.put("key3", "value3");
      nameAsProperties.setValue(props);
      ObjectName nameAsPropertiesON = bean.getNameAsProperties();
      assertEquals("nameAsProperties-update:key1=value1,key2=value2,key3=value3", nameAsPropertiesON.getCanonicalName());
   }
}
