/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.managed.plugins.constraints;

import org.jboss.managed.spi.factory.ManagedPropertyConstraintsPopulator;
import org.jboss.managed.spi.factory.ManagedPropertyConstraintsPopulatorFactory;

/**
 * ManagedPropertyConstraintsPopulatorFactory for Number constraints
 * @author Scott.Stark@jboss.org
 * @version $Revision: 81573 $
 */
public class NumberConstraintsPopulatorFactory
   implements ManagedPropertyConstraintsPopulatorFactory
{

   public ManagedPropertyConstraintsPopulator newInstance(String min,
         String max, String[] legalValues, String... args)
   {
      String numberClass = null;
      if(args != null && args.length == 1)
         numberClass = args[0];
      try
      {
         return new NumberConstraintsPopulator(min, max, numberClass);
      }
      catch(Exception e)
      {
         throw new IllegalArgumentException(e);
      }
   }

   public ManagedPropertyConstraintsPopulator newInstance(String min,
         String max, String[] legalValues)
   {
      String[] args = null;
      return newInstance(min, max, legalValues, args);
   }

}
