/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.managed.factory.support.mcf;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;

import org.jboss.metatype.api.types.CollectionMetaType;
import org.jboss.metatype.api.types.MapCompositeMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.CollectionValue;
import org.jboss.metatype.api.values.CollectionValueSupport;
import org.jboss.metatype.api.values.CompositeValue;
import org.jboss.metatype.api.values.MapCompositeValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.jboss.metatype.spi.values.MetaMapper;

/**
 * A MetaMapper for ManagedConnectionFactoryPropertyMetaData
 * @author Scott.Stark@jboss.org
 * @version $Revision: 81571 $
 */
public class MCFPropertyMetaDataMapper extends MetaMapper<Collection<ManagedConnectionFactoryPropertyMetaData>>
{
   CollectionMetaType type;

   public MCFPropertyMetaDataMapper()
   {
      MapCompositeMetaType etype = new MapCompositeMetaType(SimpleMetaType.STRING);
      etype.addItem("name", "the name of the bean");
      etype.addItem("value", "the string value of the bean");
      etype.addItem("type", "the type name of the value");
      type = new CollectionMetaType("java.util.List", etype);
   }

   @Override
   public MetaType getMetaType()
   {
      return type;
   }
   @Override
   public Type mapToType()
   {
      return ManagedConnectionFactoryPropertyMetaData.class;
   }

   @Override
   public MetaValue createMetaValue(MetaType metaType, Collection<ManagedConnectionFactoryPropertyMetaData> list)
   {
      ArrayList<MetaValue> values = new ArrayList<MetaValue>();
      for(ManagedConnectionFactoryPropertyMetaData mcfpmd : list)
      {
         MapCompositeValueSupport metaValue = new MapCompositeValueSupport(SimpleMetaType.STRING);
         metaValue.put("name", SimpleValueSupport.wrap(mcfpmd.getName()));
         metaValue.put("value", SimpleValueSupport.wrap(mcfpmd.getValue()));
         metaValue.put("type", SimpleValueSupport.wrap(mcfpmd.getType()));
         values.add(metaValue);
      }
      MetaValue[] elements = new MetaValue[values.size()];
      values.toArray(elements);
      CollectionValueSupport cvalue = new CollectionValueSupport(type, elements);
      return cvalue;
   }

   @Override
   public Collection<ManagedConnectionFactoryPropertyMetaData> unwrapMetaValue(MetaValue metaValue)
   {
      CollectionValue cvalue = (CollectionValue) metaValue;
      MetaValue[] elements = cvalue.getElements();
      ArrayList<ManagedConnectionFactoryPropertyMetaData> values = new ArrayList<ManagedConnectionFactoryPropertyMetaData>();
      if(elements != null)
      {
         for(MetaValue mv : elements)
         {
            CompositeValue cv = (CompositeValue) mv;
            ManagedConnectionFactoryPropertyMetaData bean = new ManagedConnectionFactoryPropertyMetaData();
            SimpleValue name = (SimpleValue) cv.get("name");
            SimpleValue value = (SimpleValue) cv.get("value");
            SimpleValue type = (SimpleValue) cv.get("value");
            bean.setName((String) name.getValue());
            bean.setValue((String) value.getValue());
            bean.setType((String) type.getValue());
            values.add(bean);
         }
      }
      return values;
   }
}
