/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.metatype.plugins.types;

import javax.management.ObjectName;

import org.jboss.metatype.api.types.CompositeMetaType;
import org.jboss.metatype.api.types.ImmutableCompositeMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.PropertiesMetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.spi.types.MetaTypeBuilder;

/**
 * A type builder for the javax.management.ObjectName type
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:$
 */
public class ObjectNameTypeBuilder implements MetaTypeBuilder
{
   /** The singleton instance */
   public static final ObjectNameTypeBuilder INSTANCE = new ObjectNameTypeBuilder();
   
   /** The MetaType for Class */
   public static final CompositeMetaType META_TYPE = new ImmutableCompositeMetaType(
       ObjectName.class.getName(), 
       ObjectName.class.getName(), 
       new String[] { "domain", "keyPropertyList" }, 
       new String[] { "The domain name", "The unordered set of keys and associated values" },
       new MetaType[] { SimpleMetaType.STRING, PropertiesMetaType.INSTANCE }
   );

   public MetaType buildMetaType()
   {
      // TODO Auto-generated method stub
      return META_TYPE;
   }

}
