/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.managed.factory.support;

import javax.management.ObjectName;

import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.metatype.api.annotations.MetaMapping;
import org.jboss.metatype.api.annotations.MetaMappingFactory;
import org.jboss.metatype.plugins.values.mappers.ObjectNameMetaMapper;
import org.jboss.metatype.plugins.values.mappers.ObjectNameMetaMapperFactory;
import org.jboss.metatype.plugins.values.mappers.PropertiesObjectNameMetaMapper;
import org.jboss.metatype.plugins.values.mappers.StringObjectNameMetaMapper;

/**
 * Test bean for validating MetaMapping on managed properties
 * @author Scott.Stark@jboss.org
 * @version $Revision: 86636 $
 */
@ManagementObject
public class ObjectNameBean
{
   private ObjectName nameAsString;
   private ObjectName nameAsComposite;
   private ObjectName nameAsCompositeFixedKeys;
   private ObjectName nameAsProperties;
   private ObjectName nameAsDefault;

   @ManagementProperty(includeInTemplate=true)
   @MetaMapping(StringObjectNameMetaMapper.class)
   public ObjectName getNameAsString()
   {
      return nameAsString;
   }
   public void setNameAsString(ObjectName nameAsString)
   {
      this.nameAsString = nameAsString;
   }

   @ManagementProperty()
   @MetaMapping(ObjectNameMetaMapper.class)
   public ObjectName getNameAsComposite()
   {
      return nameAsComposite;
   }
   public void setNameAsComposite(ObjectName nameAsComposite)
   {
      this.nameAsComposite = nameAsComposite;
   }

   @ManagementProperty()
   @MetaMapping(PropertiesObjectNameMetaMapper.class)
   public ObjectName getNameAsProperties()
   {
      return nameAsProperties;
   }
   public void setNameAsProperties(ObjectName nameAsProperties)
   {
      this.nameAsProperties = nameAsProperties;
   }
   @ManagementProperty()
   @MetaMappingFactory(value=ObjectNameMetaMapperFactory.class, args={"key1", "The first key", "key2", "The second key"})
   public ObjectName getNameAsCompositeFixedKeys()
   {
      return nameAsCompositeFixedKeys;
   }
   public void setNameAsCompositeFixedKeys(ObjectName nameAsCompositeFixedKeys)
   {
      this.nameAsCompositeFixedKeys = nameAsCompositeFixedKeys;
   }
   
   @ManagementProperty()
   public ObjectName getNameAsDefault()
   {
      return nameAsDefault;
   }
   public void setNameAsDefault(ObjectName nameAsDefault)
   {
      this.nameAsDefault = nameAsDefault;
   }

   
}
