/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.managed.factory.test;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.RunState;
import org.jboss.managed.api.RunStateMapper;
import org.jboss.managed.api.ManagedDeployment.DeploymentPhase;
import org.jboss.managed.api.annotation.ManagementDeployment;
import org.jboss.managed.plugins.ManagedComponentImpl;
import org.jboss.managed.plugins.ManagedDeploymentImpl;
import org.jboss.metatype.api.values.CollectionValue;
import org.jboss.metatype.api.values.GenericValue;
import org.jboss.test.managed.factory.AbstractManagedObjectFactoryTest;
import org.jboss.test.managed.factory.support.deployment.JmsDestination;
import org.jboss.test.managed.factory.support.deployment.JmsDestinations;
import org.jboss.test.managed.factory.support.deployment.QueueDestination;
import org.jboss.test.managed.factory.support.deployment.SecurityDomain;

/**
 * @author Scott.Stark@jboss.org
 * @version $Revision:$
 */
public class ManagedDeploymentUnitTestCase extends AbstractManagedObjectFactoryTest
{
   public ManagedDeploymentUnitTestCase(String name)
   {
      super(name);
   }

   public void testManagementDeploymentMO()
   {
      getLog().info("JmsDestinations.CS: "+JmsDestinations.class.getProtectionDomain().getCodeSource());
      JmsDestinations destinations = new JmsDestinations();
      List<JmsDestination> queues = new ArrayList<JmsDestination>();
      QueueDestination q1 = new QueueDestination();
      q1.setJndiName("queues/Q1");
      q1.setDomain(new SecurityDomain("java:/jaas/JMS"));
      q1.setState("State0");
      queues.add(q1);
      destinations.setDestinations(queues);

      ManagedObject mo = initManagedObject(destinations);
      assertNotNull(mo);
      Map<String, Annotation> annotations = mo.getAnnotations();
      getLog().info(annotations);
      ManagementDeployment mda = (ManagementDeployment) annotations.get(ManagementDeployment.class.getName());
      assertNotNull(mda);
      assertEquals(DeploymentPhase.APPLICATION, mda.phase());
      assertEquals(1, mda.types().length);
      assertEquals("jms", mda.types()[0]);

      // Create a ManagedDeployment for the root MO
      Map<String, ManagedObject> unitMOs = Collections.singletonMap(JmsDestinations.class.getName(), mo);
      ManagedDeploymentImpl md = new ManagedDeploymentImpl("testManagementDeploymentMO",
            "testManagementDeploymentMO", DeploymentPhase.APPLICATION, null, unitMOs);
      // Create ManagedComponents for the destinations
      ManagedProperty destinationsMP = mo.getProperty("destinations");
      assertNotNull(destinationsMP);
      CollectionValue destinationsValue = (CollectionValue) destinationsMP.getValue();
      assertNotNull(destinationsValue);
      assertEquals(1, destinationsValue.getSize());
      GenericValue q1GV = (GenericValue) destinationsValue.getElements()[0];
      assertNotNull(q1GV);
      ManagedObject q1MO = (ManagedObject) q1GV.getValue();
      assertNotNull(q1MO);

      ComponentType type = new ComponentType("JMSDestination", "queue");
      RunStateMapper stateMapper = null;
      ManagedComponentImpl mc = new ManagedComponentImpl(type, md, q1MO, stateMapper);
      md.addComponent(q1MO.getName(), mc);

      RunState state = mc.getRunState();
      assertEquals(RunState.RUNNING, state);
   }
}
