/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.metatype.api.types;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import org.jboss.metatype.api.values.PropertiesMetaValue;


/**
 * A MetaType for java.util.Properties
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision: 87526 $
 */
public class PropertiesMetaType extends AbstractMetaType
{
   private static final long serialVersionUID = 1;
   public static final PropertiesMetaType INSTANCE = new PropertiesMetaType();
   /** A mapping from known property names to description */
   private Map<String, String> propertyNameDescriptions = Collections.emptyMap();

   public PropertiesMetaType()
   {
      this(Properties.class.getName());
   }
   public PropertiesMetaType(String description)
   {
      super(Properties.class.getName(), description);
   }
   public PropertiesMetaType(String description, Map<String, String> propertyNameDescriptions)
   {
      super(Properties.class.getName(), description);
      this.propertyNameDescriptions = propertyNameDescriptions;
   }

   public void addProperty(String name, String description)
   {
      if(propertyNameDescriptions.size() == 0)
         propertyNameDescriptions = new HashMap<String,String>();
      propertyNameDescriptions.put(name, description);
   }
   
   public boolean isProperty(String name)
   {
      return propertyNameDescriptions.containsKey(name);
   }
   public String getDescription(String name)
   {
      return propertyNameDescriptions.get(name);
   }
   
   @Override
   public boolean isProperties()
   {
      return true;
   }
   @Override
   public boolean isValue(Object obj)
   {
      return obj instanceof PropertiesMetaValue;
   }

   /**
    * Equality of PropertiesMetaType is just based on the class
    */
   @Override
   public boolean equals(Object obj)
   {
      return obj instanceof PropertiesMetaType;
   }
   @Override
   public int hashCode()
   {
      return getClass().hashCode();
   }
   
}
