/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.metatype.api.values;

import java.util.Map;
import java.util.Properties;

import org.jboss.metatype.api.types.PropertiesMetaType;

/**
 * A mapping from the jdk Properties to a MetaValue
 * @author Scott.Stark@jboss.org
 * @version $Revision: 87526 $
 */
public class PropertiesMetaValue extends Properties
   implements MetaValue
{
   private static final long serialVersionUID = 1;
   private PropertiesMetaType type = PropertiesMetaType.INSTANCE; 

   /**
    * Build a PropertiesMetaValue from a Properties by copying all key/value
    * pairs from props into the new PropertiesMetaValue.
    * 
    * @param props - the Properties to copy
    * @return PropertiesMetaValue
    */
   public static PropertiesMetaValue wrap(Map<String,String> props)
   {
      PropertiesMetaValue value = new PropertiesMetaValue();
      value.putAll(props);
      return value;
   }

   /**
    * Creates an empty PropertiesMetaValue
    */
   public PropertiesMetaValue()
   {
   }
   /**
    * Create a PropertiesMetaValue with props as the defaults. If you want to
    * create a PropertiesMetaValue with only the key/value pairs of props use
    * {@link #wrap(Properties)}.
    * 
    * @param props - default properties
    */
   public PropertiesMetaValue(Properties props)
   {
      this(props, PropertiesMetaType.INSTANCE);
   }
   /**
    * Create a PropertiesMetaValue with props as the defaults. If you want to
    * create a PropertiesMetaValue with only the key/value pairs of props use
    * {@link #wrap(Properties)}.
    * 
    * @param props - default properties
    * @param type - the properties 
    */
   public PropertiesMetaValue(Properties props, PropertiesMetaType type)
   {
      if(props != null)
         super.putAll(props);
      this.type = type;
   }

   public PropertiesMetaType getMetaType()
   {
      return type;
   }

   @Override
   public MetaValue clone()
   {
      PropertiesMetaValue clone = new PropertiesMetaValue();
      clone.putAll(this);
      return clone;
   }

}
