/*
 * JBoss, Home of Professional Open Source
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.managed.plugins.jmx;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryManagerMXBean;

import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.managed.api.annotation.ManagementObjectID;

/**
 * Stub class for the MemoryManagerMXBean interface that is marked up with
 * management annotations.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:$
 */
@ManagementObject(
      isRuntime=true,
      componentType=@ManagementComponent(type="MBean", subtype="Platform"),
      targetInterface=MemoryManagerMXBean.class)
public class MemoryManagerMXBeanMO implements MemoryManagerMXBean
{

   @ManagementProperty
   public String[] getMemoryPoolNames()
   {
      return null;
   }

   @ManagementProperty
   @ManagementObjectID(prefix=ManagementFactory.MEMORY_MANAGER_MXBEAN_DOMAIN_TYPE)
   public String getName()
   {
      return null;
   }

   @ManagementProperty
   public boolean isValid()
   {
      return false;
   }

}
