/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metatype.api.values;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamField;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.TableMetaType;
import org.jboss.metatype.api.values.AbstractMetaValue;
import org.jboss.metatype.api.values.CompositeValue;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.TableValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableValueSupport
extends AbstractMetaValue
implements TableValue {
    private static final long serialVersionUID = -6862672408820383430L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("dataMap", HashMap.class), new ObjectStreamField("tableType", TableMetaType.class)};
    private HashMap<List<MetaValue>, CompositeValue> dataMap;
    private TableMetaType tableType;
    private transient String[] indexNames;

    public TableValueSupport(TableMetaType tableType) {
        this(tableType, 101, 0.75f);
    }

    public TableValueSupport(TableMetaType tableType, int initialCapacity, float loadFactor) {
        this.init(new HashMap<List<MetaValue>, CompositeValue>(initialCapacity, loadFactor), tableType);
    }

    @Override
    public TableMetaType getMetaType() {
        return this.tableType;
    }

    @Override
    public MetaValue[] calculateIndex(CompositeValue value) {
        this.validateCompositeValue(value);
        return value.getAll(this.indexNames);
    }

    @Override
    public void clear() {
        this.dataMap.clear();
    }

    @Override
    public boolean containsKey(MetaValue[] key) {
        if (key == null) {
            return false;
        }
        return this.dataMap.containsKey(Arrays.asList(key));
    }

    @Override
    public boolean containsValue(CompositeValue value) {
        return this.dataMap.containsValue(value);
    }

    @Override
    public CompositeValue get(MetaValue[] key) {
        this.validateKey(key);
        return this.dataMap.get(Arrays.asList(key));
    }

    @Override
    public boolean isEmpty() {
        return this.dataMap.isEmpty();
    }

    @Override
    public Set<List<MetaValue>> keySet() {
        return this.dataMap.keySet();
    }

    @Override
    public void put(CompositeValue value) {
        List<MetaValue> index = Arrays.asList(this.calculateIndex(value));
        if (this.dataMap.containsKey(index)) {
            throw new IllegalArgumentException("The index is already used " + index);
        }
        this.dataMap.put(index, value);
    }

    @Override
    public void putAll(CompositeValue[] values) {
        int i;
        if (values == null) {
            return;
        }
        HashSet<List<MetaValue>> keys = new HashSet<List<MetaValue>>();
        for (i = 0; i < values.length; ++i) {
            List<MetaValue> index = Arrays.asList(this.calculateIndex(values[i]));
            if (keys.contains(index)) {
                throw new IllegalArgumentException("Duplicate index in values " + index + " for value " + values[i]);
            }
            keys.add(index);
            if (!this.dataMap.containsKey(index)) continue;
            throw new IllegalArgumentException("Index already used " + index + " for value " + values[i]);
        }
        for (i = 0; i < values.length; ++i) {
            this.put(values[i]);
        }
    }

    @Override
    public CompositeValue remove(MetaValue[] key) {
        this.validateKey(key);
        return this.dataMap.remove(Arrays.asList(key));
    }

    @Override
    public int size() {
        return this.dataMap.size();
    }

    @Override
    public Collection<CompositeValue> values() {
        return this.dataMap.values();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof TableValue)) {
            return false;
        }
        TableValue other = (TableValue)obj;
        if (!this.tableType.equals(other.getMetaType())) {
            return false;
        }
        if (this.size() != other.size()) {
            return false;
        }
        for (Map.Entry<List<MetaValue>, CompositeValue> entry : this.dataMap.entrySet()) {
            List<MetaValue> list = entry.getKey();
            MetaValue[] indexes = list.toArray(new MetaValue[list.size()]);
            CompositeValue thisValue = entry.getValue();
            CompositeValue otherValue = other.get(indexes);
            if (thisValue == null && otherValue == null) {
                return true;
            }
            if (thisValue == null && otherValue != null) {
                return false;
            }
            if (((Object)thisValue).equals(otherValue)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = this.tableType.hashCode();
        for (CompositeValue value : this.dataMap.values()) {
            hash += ((Object)value).hashCode();
        }
        return hash;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(this.getClass().getSimpleName());
        buffer.append(": tableType=[");
        buffer.append(this.getMetaType());
        buffer.append("] mappings=[");
        Iterator<Map.Entry<List<MetaValue>, CompositeValue>> entries = this.dataMap.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<List<MetaValue>, CompositeValue> entry = entries.next();
            buffer.append(entry.getKey());
            buffer.append("=");
            buffer.append(entry.getValue());
            if (!entries.hasNext()) continue;
            buffer.append(",");
        }
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public TableValueSupport clone() {
        TableValueSupport result = (TableValueSupport)super.clone();
        result.dataMap = (HashMap)this.dataMap.clone();
        return result;
    }

    private void init(HashMap<List<MetaValue>, CompositeValue> dataMap, TableMetaType tableType) {
        if (dataMap == null) {
            throw new IllegalArgumentException("null dataMap");
        }
        if (tableType == null) {
            throw new IllegalArgumentException("null table type");
        }
        this.dataMap = dataMap;
        this.tableType = tableType;
        List<String> indexNameList = tableType.getIndexNames();
        this.indexNames = indexNameList.toArray(new String[indexNameList.size()]);
    }

    private void validateCompositeValue(CompositeValue value) {
        if (value == null) {
            throw new IllegalArgumentException("null value");
        }
        if (!value.getMetaType().equals(this.tableType.getRowType())) {
            throw new IllegalArgumentException("value has composite type " + value.getMetaType() + " expected row type " + this.tableType.getRowType());
        }
    }

    private void validateKey(MetaValue[] key) {
        if (key == null || key.length == 0) {
            throw new IllegalArgumentException("null or empty key");
        }
        if (key.length != this.indexNames.length) {
            throw new IllegalArgumentException("key has " + key.length + " elements, " + "should be " + this.indexNames.length);
        }
        for (int i = 0; i < key.length; ++i) {
            MetaType metaType = this.tableType.getRowType().getType(this.indexNames[i]);
            if (key[i] == null || metaType.isValue(key[i])) continue;
            throw new IllegalArgumentException("key element " + i + " " + key + " is not a value for " + metaType);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = in.readFields();
        HashMap dataMap = (HashMap)getField.get("dataMap", null);
        TableMetaType tableType = (TableMetaType)getField.get("tableType", null);
        try {
            this.init(dataMap, tableType);
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected error during deserialization", e);
        }
    }
}

