/*
 * JBoss, Home of Professional Open Source
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.managed.factory.support;

import java.io.Serializable;

import org.jboss.managed.api.annotation.ActivationPolicy;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementProperty;

/**
 * Tests of managed property activation policy settings
 * @author Scott.Stark@jboss.org
 * @version $Revision: 86627 $
 */
@ManagementObject
public class ManagementPropertyActivationPolicy
   implements Serializable
{
   private static final long serialVersionUID = 1;
   
   @ManagementProperty()
   public String getDefaultProp()
   {
      return null;
   }
   @ManagementProperty(activationPolicy=ActivationPolicy.IMMEDIATE)
   public String getImmediateProp()
   {
      return null;
   }
   @ManagementProperty(activationPolicy=ActivationPolicy.COMPONENT_RESTART)
   public String getCompRestartProp()
   {
      return null;
   }
   @ManagementProperty(activationPolicy=ActivationPolicy.DEPLOYMENT_RESTART)
   public String getDeployRestartProp()
   {
      return null;
   }
   @ManagementProperty(activationPolicy=ActivationPolicy.SERVER_RESTART)
   public String getServerRestartProp()
   {
      return null;
   }
}
